/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.ClassificationTitlesInitializer;
import ca.licef.lompad.JDialogAlert;
import ca.licef.lompad.LangStrings;
import ca.licef.lompad.Preferences;
import ca.licef.lompad.Util;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.xml.transform.stream.StreamSource;
import licef.IOUtil;
import licef.StringUtil;
import licef.XMLUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Classification {
    private String url;
    private File file;
    private LangStrings titles;
    private Model model;
    private String conceptSchemeUri;
    private static String language = null;
    private static Boolean isShowTaxumId = null;
    private static Map<String, Classification> classifs = null;

    public Classification(File file) {
        this.file = file;
        try {
            URL url = file.toURI().toURL();
            this.url = url.toString();
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
    }

    public Classification(String url, File file) {
        this.url = url;
        this.file = file;
    }

    public String getUrl() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public LangStrings getTitles() {
        if (this.titles == null) {
            try {
                ClassificationTitlesInitializer initializer = new ClassificationTitlesInitializer(new BufferedInputStream(new FileInputStream(this.file)));
                this.titles = initializer.getTitles();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return this.titles;
    }

    public String getTitle(String language) {
        String title = this.getTitles().getString(language);
        return title == null ? this.getUrl() : title;
    }

    public Model getModel() {
        if (this.model == null) {
            try {
                this.initModel(false);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConceptSchemeUri() throws IOException {
        if (this.conceptSchemeUri == null) {
            String queryStr = this.getQuery("getConceptSchemeUri.sparql", new Object[0]);
            Query query2 = QueryFactory.create(queryStr);
            QueryExecution exec = QueryExecutionFactory.create(query2, this.model);
            try {
                ResultSet results = exec.execSelect();
                while (results.hasNext()) {
                    QuerySolution res = results.nextSolution();
                    Iterator<String> it = res.varNames();
                    while (it.hasNext()) {
                        String varName = it.next().toString();
                        RDFNode n = res.get(varName);
                        this.conceptSchemeUri = n.toString();
                    }
                }
            }
            finally {
                exec.close();
            }
        }
        return this.conceptSchemeUri;
    }

    public String toString() {
        return this.getTitle(Preferences.getInstance().getLocale().getLanguage());
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Classification)) {
            return false;
        }
        Classification classif = (Classification)obj;
        return this.url.equals(classif.getUrl());
    }

    public static Collection<Classification> getAll() {
        if (classifs == null) {
            classifs = new HashMap<String, Classification>();
            try {
                Classification.init();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return classifs.values();
    }

    public static Classification get(String strUrl) {
        return classifs.get(strUrl);
    }

    public void register() {
        classifs.put(this.getUrl(), this);
    }

    public static String retrieveTaxonPathId(String id) {
        int indexOfHash = id.indexOf("#");
        if (indexOfHash != -1) {
            return id.substring(indexOfHash + 1);
        }
        String[] array = StringUtil.split(id, '/');
        int size = array.length;
        if (size > 0) {
            if (!"".equals(array[size - 1])) {
                return array[size - 1];
            }
            if (size > 1) {
                return array[size - 2];
            }
        }
        return id;
    }

    public static void init() {
        classifs.clear();
        String classifFolder = Util.getClassificationFolder();
        if (classifFolder != null) {
            File[] classifFiles = new File(classifFolder).listFiles();
            for (int i = 0; i < classifFiles.length; ++i) {
                try {
                    Classification classif = new Classification(classifFiles[i]);
                    classifs.put(classif.getUrl(), classif);
                    continue;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        language = Preferences.getInstance().getLocale().getLanguage();
        isShowTaxumId = Preferences.getInstance().isShowTaxumId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModel(boolean isInferenceNeeded) throws IOException, MalformedURLException {
        URL tmpUrl = new URL(this.url);
        InputStream is = (InputStream)tmpUrl.getContent();
        Model model = null;
        try {
            model = ModelFactory.createDefaultModel();
            model.read(is, null);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        this.model = model;
        if (isInferenceNeeded) {
            this.computeInference();
        }
    }

    public boolean delete() {
        try {
            File file = new File(new URI(this.getUrl().toString()));
            boolean isDeleted = file.delete();
            if (isDeleted) {
                classifs.remove(this.getUrl());
            }
            return isDeleted;
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File doImportFile(Component parent) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        if (Preferences.getInstance().getPrevClassifDir() != null) {
            chooser.setCurrentDirectory(Preferences.getInstance().getPrevClassifDir());
        }
        if ((returnVal = chooser.showOpenDialog(parent)) == 0) {
            try {
                Preferences.getInstance().setPrevClassifDir(chooser.getCurrentDirectory());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                boolean isVdexFile;
                File skosInputFile = chooser.getSelectedFile();
                File tmpFile = null;
                String xml = IOUtil.readStringFromFile(chooser.getSelectedFile());
                String rootTagName = XMLUtil.getRootTagName(xml);
                if (rootTagName != null) {
                    String[] array = StringUtil.split(rootTagName, ':');
                    rootTagName = array[array.length - 1].toLowerCase();
                }
                boolean bl = isVdexFile = rootTagName != null && "vdex".equals(rootTagName);
                if (isVdexFile) {
                    String xsltFile = "/xslt/convertVDEXToSKOS.xsl";
                    StreamSource xslt = new StreamSource(Util.class.getResourceAsStream(xsltFile));
                    StreamSource xmlSource = new StreamSource(new BufferedReader(new StringReader(xml)));
                    Node skosNode = XMLUtil.applyXslToDocument2(xslt, xmlSource, null, null, null);
                    tmpFile = File.createTempFile("lompad", "inputSkos");
                    BufferedWriter tmpFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile, false), "UTF-8"));
                    try {
                        XMLUtil.serialize(skosNode, false, (Writer)tmpFileWriter);
                    }
                    finally {
                        if (tmpFileWriter != null) {
                            ((Writer)tmpFileWriter).close();
                        }
                    }
                    skosInputFile = tmpFile;
                }
                Classification classif = new Classification(skosInputFile);
                classif.initModel(true);
                String uri = classif.getConceptSchemeUri();
                if (uri == null) {
                    throw new Exception("ConceptScheme's URI not found.");
                }
                String sha1 = DigestUtils.shaHex(uri);
                File localFile = new File(Util.getClassificationFolder(), sha1 + ".rdf");
                classif.dumpModelToRdf(localFile);
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                return localFile;
            }
            catch (Exception e3) {
                e3.printStackTrace();
                String msg = "classifImportFailed";
                if ("Classification identifier not found.".equals(e3.getMessage())) {
                    msg = "classifIdentifierNotFound";
                }
                JDialogAlert dialog = new JDialogAlert(Util.getTopJFrame((Container)parent), "titleErr", msg);
                dialog.setSize(320, 140);
                dialog.setVisible(true);
                return null;
            }
        }
        return null;
    }

    public static boolean isVdexFile(File file) throws Exception {
        String xml = IOUtil.readStringFromFile(file);
        String rootTagName = XMLUtil.getRootTagName(xml);
        return rootTagName != null && "vdex".equals(rootTagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQuery(String queryId, Object ... params) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        InputStream is = this.getClass().getResourceAsStream("/queries/" + queryId);
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            IOUtil.copy(bis, bos);
        }
        finally {
            bis.close();
            bos.close();
        }
        String rawQuery = baos.toString("UTF-8");
        if (params == null || params.length == 0) {
            return rawQuery;
        }
        String query2 = MessageFormat.format(rawQuery, params);
        return query2;
    }

    private void computeInference() {
        Model modelSkos = ModelFactory.createDefaultModel();
        InputStream is = this.getClass().getResourceAsStream("/skos.rdf");
        this.model.read(is, "");
        Reasoner reasoner = ReasonerRegistry.getOWLMicroReasoner();
        reasoner = reasoner.bindSchema(modelSkos);
        InfModel infModel = ModelFactory.createInfModel(reasoner, this.model);
        this.model.add(infModel.listStatements());
    }

    private void dumpModelToRdf(File file) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
            this.model.write(writer, "RDF/XML");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

