/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.JDialogVCardEditor;
import ca.licef.lompad.JTextFieldPopup;
import ca.licef.lompad.LocalizeJLabel;
import ca.licef.lompad.Util;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.w3c.dom.Element;

class EntityComponent
extends FormComponent {
    String vCard = null;
    JPanel jPanelEntity = new JPanel();
    LocalizeJLabel jLabelGivenName;
    LocalizeJLabel jLabelFamilyName;
    LocalizeJLabel jLabelEMail;
    LocalizeJLabel jLabelOrg;
    JTextFieldPopup jTextFieldGivenName;
    JTextFieldPopup jTextFieldFamilyName;
    JTextFieldPopup jTextFieldEMail;
    JTextFieldPopup jTextFieldOrg;
    JPanel jPanelVCard;
    JButton jButtonVCard;

    public EntityComponent(boolean isFirst) {
        super(null);
        this.jPanelEntity.setOpaque(false);
        this.jTextFieldGivenName = new JTextFieldPopup();
        this.jTextFieldFamilyName = new JTextFieldPopup();
        this.jTextFieldEMail = new JTextFieldPopup();
        this.jTextFieldOrg = new JTextFieldPopup();
        this.jButtonVCard = new JButton(Util.vcardIcon);
        this.jButtonVCard.setBorderPainted(false);
        this.jButtonVCard.setFocusPainted(false);
        this.jButtonVCard.setPreferredSize(new Dimension(28, 23));
        this.jPanelVCard = new JPanel();
        this.jPanelVCard.setLayout(new FlowLayout(2, 0, 0));
        this.jPanelVCard.add(this.jButtonVCard);
        double xBorder = 2.0;
        double yBorder = 0.0;
        double shortGap = 2.0;
        double largeGap = 10.0;
        double sectionGap = 20.0;
        double[][] sizeForFirst = new double[][]{{xBorder, 0.23, shortGap, 0.23, shortGap, 0.23, shortGap, 0.23, shortGap, 0.06}, {yBorder, 0.5, shortGap, 0.5, yBorder}};
        double[][] sizeForOther = new double[][]{{xBorder, 0.23, shortGap, 0.23, shortGap, 0.23, shortGap, 0.23, shortGap, 0.06}, {yBorder, -1.0, yBorder}};
        this.jPanelEntity.setLayout(new TableLayout(isFirst ? sizeForFirst : sizeForOther));
        if (isFirst) {
            Font labelFont = new Font("Dialog", 0, 12);
            this.jLabelGivenName = new LocalizeJLabel("givenName");
            this.jLabelGivenName.setFont(labelFont);
            this.jLabelFamilyName = new LocalizeJLabel("familyName");
            this.jLabelFamilyName.setFont(labelFont);
            this.jLabelEMail = new LocalizeJLabel("email");
            this.jLabelEMail.setFont(labelFont);
            this.jLabelOrg = new LocalizeJLabel("org");
            this.jLabelOrg.setFont(labelFont);
            this.jPanelEntity.add((Component)this.jLabelGivenName, "1, 1");
            this.jPanelEntity.add((Component)this.jLabelFamilyName, "3, 1");
            this.jPanelEntity.add((Component)this.jLabelEMail, "5, 1");
            this.jPanelEntity.add((Component)this.jLabelOrg, "7, 1");
            this.jPanelEntity.add((Component)this.jTextFieldGivenName, "1, 3");
            this.jPanelEntity.add((Component)this.jTextFieldFamilyName, "3, 3");
            this.jPanelEntity.add((Component)this.jTextFieldEMail, "5, 3");
            this.jPanelEntity.add((Component)this.jTextFieldOrg, "7, 3");
            this.jPanelEntity.add((Component)this.jPanelVCard, "9, 3");
        } else {
            this.jPanelEntity.add((Component)this.jTextFieldGivenName, "1, 1");
            this.jPanelEntity.add((Component)this.jTextFieldFamilyName, "3, 1");
            this.jPanelEntity.add((Component)this.jTextFieldEMail, "5, 1");
            this.jPanelEntity.add((Component)this.jTextFieldOrg, "7, 1");
            this.jPanelEntity.add((Component)this.jPanelVCard, "9, 1");
        }
        this.jPanelGauche.add(this.jPanelEntity);
        SymAction lSymAction = new SymAction();
        this.jButtonVCard.addActionListener(lSymAction);
        SymMouse aSymMouse = new SymMouse();
        this.jButtonVCard.addMouseListener(aSymMouse);
    }

    boolean isFilled() {
        return !this.jTextFieldGivenName.getText().trim().equals("") || !this.jTextFieldFamilyName.getText().trim().equals("") || !this.jTextFieldEMail.getText().trim().equals("") || !this.jTextFieldOrg.getText().trim().equals("");
    }

    public void setEnabled(boolean b) {
        this.jTextFieldGivenName.setEditable(b);
        this.jTextFieldGivenName.setBackground(Color.white);
        this.jTextFieldFamilyName.setEditable(b);
        this.jTextFieldFamilyName.setBackground(Color.white);
        this.jTextFieldEMail.setEditable(b);
        this.jTextFieldEMail.setBackground(Color.white);
        this.jTextFieldOrg.setEditable(b);
        this.jTextFieldOrg.setBackground(Color.white);
    }

    private void editVCard() {
        if (this.vCard == null || "".equals(this.vCard)) {
            this.generateVCard();
        } else {
            try {
                this.updateVCard();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JDialogVCardEditor jDialog = new JDialogVCardEditor(Util.getTopJFrame(this), this.vCard);
        jDialog.setVisible(true);
        if (jDialog.bOk) {
            this.vCard = jDialog.getVCardValue().trim();
            this.setVCardValues();
        }
        jDialog.dispose();
    }

    void jButton_mouseInOut(JButton jButton, boolean in) {
        jButton.setBorderPainted(in);
    }

    void setVCardValues() {
        int index;
        if (this.vCard == null) {
            return;
        }
        String vCard = this.vCard;
        String fnField = null;
        String nField = null;
        String familyName = null;
        String givenName = null;
        String email = null;
        String org = null;
        while ((index = vCard.indexOf("\n")) != -1) {
            String token = vCard.substring(0, index);
            if (token.startsWith("N:")) {
                nField = token.substring(token.indexOf(":") + 1);
            }
            if (token.startsWith("FN:")) {
                fnField = token.substring(token.indexOf(":") + 1);
            }
            if (token.startsWith("EMAIL")) {
                email = token.substring(token.indexOf(":") + 1);
            }
            if (token.startsWith("ORG:")) {
                org = token.substring("ORG:".length());
            }
            if (!(vCard = vCard.substring(index + 1)).startsWith("END:")) continue;
            break;
        }
        if (nField != null && !"".equals(nField)) {
            String[] vals = nField.split(";");
            if (vals.length >= 1) {
                familyName = vals[0];
            }
            if (vals.length >= 2) {
                givenName = vals[1];
            }
        }
        if (!(givenName != null && !"".equals(givenName) || familyName != null && !"".equals(familyName) || fnField == null || "".equals(fnField))) {
            String[] vals = fnField.split(" ");
            if (vals.length == 1) {
                familyName = vals[0];
            } else if (vals.length == 2) {
                givenName = vals[0];
                familyName = vals[1];
            }
        }
        this.jTextFieldGivenName.setText(givenName);
        this.jTextFieldGivenName.setCaretPosition(0);
        this.jTextFieldFamilyName.setText(familyName);
        this.jTextFieldFamilyName.setCaretPosition(0);
        this.jTextFieldEMail.setText(email);
        this.jTextFieldEMail.setCaretPosition(0);
        this.jTextFieldOrg.setText(org);
        this.jTextFieldOrg.setCaretPosition(0);
    }

    void generateVCard() {
        String familyName = this.jTextFieldFamilyName.getText().trim();
        String givenName = this.jTextFieldGivenName.getText().trim();
        String email = this.jTextFieldEMail.getText().trim();
        String org = this.jTextFieldOrg.getText().trim();
        if ((familyName + givenName + email + org).length() == 0) {
            return;
        }
        String vCard = "N:" + familyName + ";" + givenName + ";;;" + "\n";
        vCard = vCard + "FN:" + givenName + ("".equals(givenName) ? "" : " ") + familyName + "\n";
        if (!"".equals(email)) {
            vCard = vCard + "EMAIL;TYPE=INTERNET:" + email + "\n";
        }
        if (!"".equals(org)) {
            vCard = vCard + "ORG:" + org + "\n";
        }
        this.vCard = "".equals(vCard) ? null : "BEGIN:VCARD\nVERSION:3.0\n" + vCard + "END:VCARD";
    }

    void updateVCard() {
        this.updateNandFN();
        this.updateEMAIL();
        this.updateORG();
    }

    void updateNandFN() {
        String familyName = this.jTextFieldFamilyName.getText().trim();
        String givenName = this.jTextFieldGivenName.getText().trim();
        int start = this.vCard.indexOf("\nN:");
        if (start != -1) {
            boolean hasChanged;
            int end = this.vCard.indexOf("\n", start + 1);
            String previousValue = this.vCard.substring(start + 3, end);
            String[] vals = previousValue.split(";");
            if (vals.length >= 1) {
                hasChanged = !familyName.equals(vals[0]);
            } else {
                boolean bl = hasChanged = !"".equals(familyName);
            }
            if (!hasChanged) {
                if (vals.length >= 2) {
                    hasChanged = !givenName.equals(vals[1]);
                } else {
                    boolean bl = hasChanged = !"".equals(givenName);
                }
            }
            if (hasChanged) {
                String additionalName = "";
                String prefix = "";
                String suffix = "";
                if (vals.length >= 3) {
                    additionalName = vals[2];
                }
                if (vals.length >= 4) {
                    prefix = vals[3];
                }
                if (vals.length >= 5) {
                    suffix = vals[4];
                }
                this.vCard = this.vCard.substring(0, start) + "\nN:" + familyName + ";" + givenName + ";" + additionalName + ";" + prefix + ";" + suffix + this.vCard.substring(end);
                start = this.vCard.indexOf("\nFN:");
                if (start != -1) {
                    end = this.vCard.indexOf("\n", start + 1);
                    this.vCard = this.vCard.substring(0, start) + "\nFN:" + givenName + ("".equals(givenName) ? "" : " ") + familyName + this.vCard.substring(end);
                } else {
                    start = this.vCard.indexOf("\nEND:VCARD");
                    this.vCard = this.vCard.substring(0, start) + "\nFN:" + givenName + ("".equals(givenName) ? "" : " ") + familyName + this.vCard.substring(start);
                }
            }
        } else {
            start = this.vCard.indexOf("\nEND:VCARD");
            this.vCard = this.vCard.substring(0, start) + "\nN:" + familyName + ";" + givenName + ";;;" + this.vCard.substring(start);
            start = this.vCard.indexOf("\nFN:");
            if (start != -1) {
                int end = this.vCard.indexOf("\n", start + 1);
                this.vCard = this.vCard.substring(0, start) + "\nFN:" + givenName + ("".equals(givenName) ? "" : " ") + familyName + this.vCard.substring(end);
            } else {
                start = this.vCard.indexOf("\nEND:VCARD");
                this.vCard = this.vCard.substring(0, start) + "\nFN:" + givenName + ("".equals(givenName) ? "" : " ") + familyName + this.vCard.substring(start);
            }
        }
    }

    void updateEMAIL() {
        String email = this.jTextFieldEMail.getText().trim();
        if ("".equals(email)) {
            int start = this.vCard.indexOf("\nEMAIL");
            if (start != -1) {
                int end = this.vCard.indexOf("\n", start + 1);
                this.vCard = this.vCard.substring(0, start) + this.vCard.substring(end);
            }
        } else {
            int start = this.vCard.indexOf("\nEMAIL");
            if (start != -1) {
                boolean hasChanged;
                String previousValue;
                int end = this.vCard.indexOf("\n", start + 1);
                String pref = ":";
                int typeIndex = this.vCard.indexOf(";TYPE", start + 6);
                if (typeIndex != -1) {
                    int valIndex = this.vCard.indexOf(":", typeIndex + 1);
                    pref = this.vCard.substring(typeIndex, valIndex + 1);
                    previousValue = this.vCard.substring(valIndex + 1, end);
                } else {
                    previousValue = this.vCard.substring(start + 7, end);
                }
                boolean bl = hasChanged = !email.equals(previousValue);
                if (hasChanged) {
                    this.vCard = this.vCard.substring(0, start) + "\nEMAIL" + pref + email + this.vCard.substring(end);
                }
            } else {
                start = this.vCard.indexOf("\nEND:VCARD");
                this.vCard = this.vCard.substring(0, start) + "\nEMAIL;TYPE=INTERNET:" + email + this.vCard.substring(start);
            }
        }
    }

    void updateORG() {
        String org = this.jTextFieldOrg.getText().trim();
        if ("".equals(org)) {
            int start = this.vCard.indexOf("\nORG:");
            if (start != -1) {
                int end = this.vCard.indexOf("\n", start + 1);
                this.vCard = this.vCard.substring(0, start) + this.vCard.substring(end);
            }
        } else {
            int start = this.vCard.indexOf("\nORG:");
            if (start != -1) {
                boolean hasChanged;
                int end = this.vCard.indexOf("\n", start + 1);
                String previousValue = this.vCard.substring(start + 5, end);
                boolean bl = hasChanged = !org.equals(previousValue);
                if (hasChanged) {
                    this.vCard = this.vCard.substring(0, start) + "\nORG:" + org + this.vCard.substring(end);
                }
            } else {
                start = this.vCard.indexOf("\nEND:VCARD");
                this.vCard = this.vCard.substring(0, start) + "\nORG:" + org + this.vCard.substring(start);
            }
        }
    }

    String toXML(String key) {
        if (this.vCard == null || "".equals(this.vCard)) {
            this.generateVCard();
        } else {
            try {
                this.updateVCard();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.vCard == null || "".equals(this.vCard)) {
            return null;
        }
        return "<![CDATA[" + this.vCard + "]]>";
    }

    void fromXML(String path, Element e2) {
        if (e2.getFirstChild() == null) {
            return;
        }
        String vCard = e2.getFirstChild().getNodeValue();
        this.vCard = vCard.trim();
        this.setVCardValues();
    }

    String toHTML(String key) {
        String familyName = Util.convertSpecialCharactersForXML(this.jTextFieldFamilyName.getText().trim());
        String givenName = Util.convertSpecialCharactersForXML(this.jTextFieldGivenName.getText().trim());
        String email = Util.convertSpecialCharactersForXML(this.jTextFieldEMail.getText().trim());
        String org = Util.convertSpecialCharactersForXML(this.jTextFieldOrg.getText().trim());
        String html = "";
        if (!familyName.equals("") || !givenName.equals("")) {
            if (!givenName.equals("")) {
                html = html + (html.equals("") ? "" : " ") + givenName;
            }
            if (!familyName.equals("")) {
                html = html + (html.equals("") ? "" : " ") + familyName;
            }
        }
        if (!email.equals("")) {
            html = html + (html.equals("") ? "" : " (") + "<a href=\"mailto:" + email + "\">" + email + "</a>)";
        }
        if (!org.equals("")) {
            html = html + (html.equals("") ? "" : "; ") + org;
        }
        html = html.equals("") ? null : html + "<br>";
        return html;
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseEntered(MouseEvent event) {
            Object object = event.getSource();
            if (object instanceof JButton) {
                EntityComponent.this.jButton_mouseInOut((JButton)object, true);
            }
        }

        public void mouseExited(MouseEvent event) {
            Object object = event.getSource();
            if (object instanceof JButton) {
                EntityComponent.this.jButton_mouseInOut((JButton)object, false);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == EntityComponent.this.jButtonVCard) {
                EntityComponent.this.editVCard();
            }
        }
    }
}

