/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormMediator;
import ca.licef.lompad.JDialogFormatSelector;
import ca.licef.lompad.JTextFieldPopup;
import ca.licef.lompad.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FormatComponent
extends FormComponent {
    JTextFieldPopup jTextField = new JTextFieldPopup();
    JButton jButtonWizard;
    Component horizontalStrut;

    public FormatComponent(FormMediator mediator) {
        super(mediator);
        this.jPanelGauche.add(this.jTextField);
        this.jButtonWizard = new JButton(Util.wizardIcon);
        this.jButtonWizard.setFont(new Font("Dialog", 0, 12));
        this.jButtonWizard.setFocusPainted(false);
        this.jButtonWizard.setBorderPainted(false);
        this.jButtonWizard.setPreferredSize(new Dimension(23, 23));
        this.horizontalStrut = Box.createHorizontalStrut(5);
        this.jPanelDroite.add(this.horizontalStrut);
        this.jPanelDroite.add(this.jButtonWizard);
        SymAction lSymAction = new SymAction();
        this.jButtonWizard.addActionListener(lSymAction);
        SymMouse aSymMouse = new SymMouse();
        this.jButtonWizard.addMouseListener(aSymMouse);
    }

    @Override
    boolean isFilled() {
        return !this.jTextField.getText().trim().equals("");
    }

    @Override
    public void setEnabled(boolean b) {
        this.jTextField.setEditable(b);
        this.jTextField.setBackground(Color.white);
        this.horizontalStrut.setVisible(b);
        this.jButtonWizard.setVisible(b);
    }

    @Override
    void updateAfterAdded() {
        this.jTextField.requestFocus();
    }

    void jButtonWizard_actionPerformed(ActionEvent event) {
        JDialogFormatSelector jDialog = new JDialogFormatSelector(Util.getTopJFrame(this));
        jDialog.setVisible(true);
        if (jDialog.bOk) {
            this.jTextField.setText(jDialog.format);
        }
        jDialog.dispose();
    }

    void jButton_mouseInOut(JButton jButton, boolean in) {
        jButton.setBorderPainted(in);
    }

    @Override
    String toXML(String key) {
        String xml = null;
        if (!this.jTextField.getText().trim().equals("")) {
            xml = Util.convertSpecialCharactersForXML(this.jTextField.getText().trim());
        }
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        if (e2.getFirstChild() != null) {
            this.jTextField.setText(e2.getFirstChild().getNodeValue().trim());
            this.jTextField.setCaretPosition(0);
        }
    }

    @Override
    String toHTML(String key) {
        String html = null;
        if (!this.jTextField.getText().trim().equals("")) {
            html = this.jTextField.getText().trim() + "<br>";
        }
        return html;
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseEntered(MouseEvent event) {
            Object object = event.getSource();
            if (object instanceof JButton) {
                FormatComponent.this.jButton_mouseInOut((JButton)object, true);
            }
        }

        public void mouseExited(MouseEvent event) {
            Object object = event.getSource();
            if (object instanceof JButton) {
                FormatComponent.this.jButton_mouseInOut((JButton)object, false);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == FormatComponent.this.jButtonWizard) {
                FormatComponent.this.jButtonWizard_actionPerformed(event);
            }
        }
    }
}

