/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.LightCalendar;
import ca.licef.lompad.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import licef.StringUtil;

class JDialogDateSelector
extends JDialog {
    JPanel jPanelContent;
    JPanel jPanelButton;
    JButton jButtonOk;
    JButton jButtonCancel;
    JComboBox jComboBoxMonth;
    JSpinner jSpinnerYear;
    LightCalendar calendar;
    boolean bOk;
    Date currentDate;

    public JDialogDateSelector(Frame parent) {
        this(parent, new Date());
    }

    public JDialogDateSelector(Frame parent, Date initDate) {
        super(parent, "title", true);
        this.setSize(220, 270);
        this.currentDate = initDate;
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.currentDate);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout(0, 5));
        this.jPanelContent = new JPanel(){

            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        this.jPanelContent.setLayout(new BorderLayout(0, 5));
        cp.add((Component)this.jPanelContent, "Center");
        JPanel jPanelTop = new JPanel();
        jPanelTop.setLayout(new BoxLayout(jPanelTop, 0));
        this.jComboBoxMonth = new JComboBox();
        this.jComboBoxMonth.setFont(new Font("Dialog", 0, 12));
        this.jComboBoxMonth.setMinimumSize(new Dimension(23, 24));
        this.jComboBoxMonth.setPreferredSize(new Dimension(1000, 24));
        this.jComboBoxMonth.setMaximumSize(new Dimension(1000, 24));
        DateFormatSymbols dfs = new DateFormatSymbols(Preferences.getInstance().getLocale());
        String[] months = dfs.getMonths();
        for (int i = 0; i < months.length - 1; ++i) {
            this.jComboBoxMonth.addItem(StringUtil.capitalize(months[i]));
        }
        int iMonth = cal.get(2);
        this.jComboBoxMonth.setSelectedIndex(iMonth);
        SpinnerDateModel model = new SpinnerDateModel();
        this.jSpinnerYear = new JSpinner(model);
        JSpinner.DateEditor editor = new JSpinner.DateEditor(this.jSpinnerYear, "yyyy");
        this.jSpinnerYear.setEditor(editor);
        editor.getTextField().setEditable(false);
        model.setValue(this.currentDate);
        this.jSpinnerYear.setMinimumSize(new Dimension(23, 24));
        this.jSpinnerYear.setPreferredSize(new Dimension(1000, 24));
        this.jSpinnerYear.setMaximumSize(new Dimension(1000, 24));
        jPanelTop.add(this.jComboBoxMonth);
        jPanelTop.add(Box.createHorizontalStrut(5));
        jPanelTop.add(this.jSpinnerYear);
        this.jPanelContent.add((Component)jPanelTop, "North");
        this.calendar = new LightCalendar(this, false);
        this.calendar.setDate(this.currentDate);
        this.jPanelContent.add((Component)this.calendar, "Center");
        this.jButtonOk = new JButton("OK");
        this.jButtonOk.setFont(this.jComboBoxMonth.getFont());
        this.jButtonCancel = new JButton("cancel");
        this.jButtonCancel.setFont(this.jButtonOk.getFont());
        this.jPanelButton = new JPanel();
        this.jPanelButton.setLayout(new FlowLayout(2));
        this.jPanelButton.add(this.jButtonOk);
        this.jPanelButton.add(this.jButtonCancel);
        cp.add((Component)this.jPanelButton, "South");
        SymAction lSymAction = new SymAction();
        this.jComboBoxMonth.addActionListener(lSymAction);
        this.jButtonOk.addActionListener(lSymAction);
        this.jButtonCancel.addActionListener(lSymAction);
        SymChange lSymChange = new SymChange();
        this.jSpinnerYear.addChangeListener(lSymChange);
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.JDialogDateSelectorRes", Preferences.getInstance().getLocale());
        this.setTitle(" " + resBundle.getString("title"));
        this.jButtonCancel.setText(resBundle.getString("cancel"));
    }

    public void setVisible(boolean b) {
        if (b) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        }
        super.setVisible(b);
    }

    void jComboBoxMonth_actionPerformed() {
        Calendar previousCal = Calendar.getInstance();
        previousCal.setTime(this.currentDate);
        Calendar newCal = Calendar.getInstance();
        newCal.set(1, previousCal.get(1));
        newCal.set(2, this.jComboBoxMonth.getSelectedIndex());
        int newMonth = this.jComboBoxMonth.getSelectedIndex();
        if (previousCal.get(5) > 28 && newMonth == 1) {
            newCal.set(5, 28);
        } else if (previousCal.get(5) == 31 && (newMonth == 3 || newMonth == 5 || newMonth == 8 || newMonth == 10)) {
            newCal.set(5, 30);
        } else {
            newCal.set(5, previousCal.get(5));
        }
        this.calendar.setDate(newCal.getTime());
        this.calendar.selectionner(newCal.getTime());
        this.currentDate = newCal.getTime();
    }

    void jButtonOk_actionPerformed() {
        this.bOk = true;
        this.setVisible(false);
    }

    void jButtonCancel_actionPerformed() {
        this.setVisible(false);
    }

    void jSpinnerYear_changePerformed() {
        Calendar previousCal = Calendar.getInstance();
        previousCal.setTime(this.currentDate);
        Calendar cTemp = Calendar.getInstance();
        cTemp.setTime((Date)this.jSpinnerYear.getModel().getValue());
        Calendar newCal = Calendar.getInstance();
        newCal.set(1, cTemp.get(1));
        newCal.set(2, previousCal.get(2));
        if (previousCal.get(5) > 28 && previousCal.get(2) == 1) {
            newCal.set(5, 28);
        } else {
            newCal.set(5, previousCal.get(5));
        }
        this.calendar.setDate(newCal.getTime());
        this.calendar.selectionner(newCal.getTime());
        this.currentDate = newCal.getTime();
    }

    class SymChange
    implements ChangeListener {
        SymChange() {
        }

        public void stateChanged(ChangeEvent event) {
            Object object = event.getSource();
            if (object == JDialogDateSelector.this.jSpinnerYear) {
                JDialogDateSelector.this.jSpinnerYear_changePerformed();
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JDialogDateSelector.this.jComboBoxMonth) {
                JDialogDateSelector.this.jComboBoxMonth_actionPerformed();
            } else if (object == JDialogDateSelector.this.jButtonOk) {
                JDialogDateSelector.this.jButtonOk_actionPerformed();
            } else if (object == JDialogDateSelector.this.jButtonCancel) {
                JDialogDateSelector.this.jButtonCancel_actionPerformed();
            }
        }
    }
}

