/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.Classification;
import ca.licef.lompad.JPanelTaxonomy;
import ca.licef.lompad.LocalizeTaxon;
import ca.licef.lompad.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class JDialogTaxonPathSelector
extends JDialog {
    JPanel jPanelContent;
    JPanelTaxonomy jPanelTaxonomy;
    JPanel jPanelButton;
    JButton jButtonOk;
    JButton jButtonCancel;
    SymTree aSymTree;
    String source;
    Object[] taxonPath;
    boolean bOk = false;

    public JDialogTaxonPathSelector(Frame parent) {
        super(parent, "title", true);
        this.setSize(500, 400);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.jPanelContent = new JPanel(){

            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        this.jPanelContent.setLayout(new BorderLayout());
        cp.add((Component)this.jPanelContent, "Center");
        this.jPanelTaxonomy = new JPanelTaxonomy(this);
        this.jPanelContent.add("Center", this.jPanelTaxonomy);
        this.jButtonOk = new JButton("OK");
        this.jButtonOk.setFont(new Font("Dialog", 0, 12));
        this.jButtonOk.setEnabled(false);
        this.jButtonCancel = new JButton("cancel");
        this.jButtonCancel.setFont(this.jButtonOk.getFont());
        this.jPanelButton = new JPanel();
        this.jPanelButton.setLayout(new FlowLayout(2));
        this.jPanelButton.add(this.jButtonOk);
        this.jPanelButton.add(this.jButtonCancel);
        cp.add((Component)this.jPanelButton, "South");
        SymAction lSymAction = new SymAction();
        this.jButtonOk.addActionListener(lSymAction);
        this.jButtonCancel.addActionListener(lSymAction);
        SymMouse aSymMouse = new SymMouse();
        this.jPanelTaxonomy.jComboBoxClassification.addMouseListener(aSymMouse);
        this.aSymTree = new SymTree();
        Iterator it = this.jPanelTaxonomy.getTrees().iterator();
        while (it.hasNext()) {
            ((JTree)it.next()).addTreeSelectionListener(this.aSymTree);
        }
    }

    void updateLocalization() {
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.JDialogTaxonPathSelectorRes", Preferences.getInstance().getLocale());
        this.setTitle(resBundle.getString("title"));
        this.jButtonCancel.setText(resBundle.getString("cancel"));
    }

    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            this.bOk = false;
            this.updateLocalization();
        }
        if (this.jPanelTaxonomy != null) {
            this.jPanelTaxonomy.setVisible(b);
        }
        super.setVisible(b);
    }

    void addTreeListener(JTree tree) {
        tree.addTreeSelectionListener(this.aSymTree);
    }

    void jButtonOk_actionPerformed() throws IOException {
        int selectedIndex = this.jPanelTaxonomy.getSelectedIndex();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jPanelTaxonomy.getCurrentTree().getLastSelectedPathComponent();
        LocalizeTaxon taxon = (LocalizeTaxon)node.getUserObject();
        Classification classif = (Classification)this.jPanelTaxonomy.jComboBoxClassification.getSelectedItem();
        this.source = classif.getConceptSchemeUri();
        this.taxonPath = this.jPanelTaxonomy.getTaxonPath();
        this.bOk = true;
        this.setVisible(false);
    }

    void jButtonCancel_actionPerformed() {
        this.setVisible(false);
    }

    void update() {
        JTree currentTree = this.jPanelTaxonomy.getCurrentTree();
        boolean isEnabled = currentTree != null && currentTree.getSelectionPath() != null && currentTree.getSelectionPath().getPathCount() != 0;
        this.jButtonOk.setEnabled(isEnabled);
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent e2) {
            Object object = e2.getSource();
            if (object.equals(JDialogTaxonPathSelector.this.jPanelTaxonomy.jComboBoxClassification)) {
                JDialogTaxonPathSelector.this.update();
            }
        }
    }

    class SymTree
    implements TreeSelectionListener {
        SymTree() {
        }

        public void valueChanged(TreeSelectionEvent e2) {
            JDialogTaxonPathSelector.this.update();
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JDialogTaxonPathSelector.this.jButtonOk) {
                try {
                    JDialogTaxonPathSelector.this.jButtonOk_actionPerformed();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            } else if (object == JDialogTaxonPathSelector.this.jButtonCancel) {
                JDialogTaxonPathSelector.this.jButtonCancel_actionPerformed();
            }
        }
    }
}

