/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.Preferences;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class JTextAreaPopup
extends JTextArea {
    PopupMenuMouseListener pop = new PopupMenuMouseListener();

    public JTextAreaPopup() {
        this.setWrapStyleWord(true);
        this.addMouseListener(this.pop);
    }

    public JTextAreaPopup(String text) {
        super(text);
        this.addMouseListener(this.pop);
    }

    class PopupMenuMouseListener
    extends MouseAdapter {
        private JMenuItem cutItem;
        private JMenuItem copyItem;
        private JMenuItem pasteItem;
        private JMenuItem selectAllItem;
        private JTextComponent textComponent;
        String savedstring = "";
        String lastactionselected = "";

        PopupMenuMouseListener() {
        }

        JPopupMenu createPopup() {
            JPopupMenu popup = new JPopupMenu();
            ResourceBundle resBundle = ResourceBundle.getBundle("properties.PopupMouseListenerRes", Preferences.getInstance().getLocale());
            Font font = new Font("Dialog", 0, 12);
            AbstractAction action = new AbstractAction(resBundle.getString("cut")){

                public void actionPerformed(ActionEvent ae) {
                    PopupMenuMouseListener.this.lastactionselected = "c";
                    PopupMenuMouseListener.this.savedstring = PopupMenuMouseListener.this.textComponent.getText();
                    PopupMenuMouseListener.this.textComponent.cut();
                }
            };
            this.cutItem = popup.add(action);
            this.cutItem.setFont(font);
            action = new AbstractAction(resBundle.getString("copy")){

                public void actionPerformed(ActionEvent ae) {
                    PopupMenuMouseListener.this.lastactionselected = "";
                    PopupMenuMouseListener.this.textComponent.copy();
                }
            };
            this.copyItem = popup.add(action);
            this.copyItem.setFont(font);
            action = new AbstractAction(resBundle.getString("paste")){

                public void actionPerformed(ActionEvent ae) {
                    PopupMenuMouseListener.this.lastactionselected = "p";
                    PopupMenuMouseListener.this.savedstring = PopupMenuMouseListener.this.textComponent.getText();
                    PopupMenuMouseListener.this.textComponent.paste();
                }
            };
            this.pasteItem = popup.add(action);
            this.pasteItem.setFont(font);
            popup.addSeparator();
            action = new AbstractAction(resBundle.getString("selectall")){

                public void actionPerformed(ActionEvent ae) {
                    PopupMenuMouseListener.this.lastactionselected = "s";
                    PopupMenuMouseListener.this.savedstring = PopupMenuMouseListener.this.textComponent.getText();
                    PopupMenuMouseListener.this.textComponent.selectAll();
                }
            };
            this.selectAllItem = popup.add(action);
            this.selectAllItem.setFont(font);
            return popup;
        }

        public void mouseClicked(MouseEvent e2) {
            if (e2.getModifiers() == 4) {
                if (!(e2.getSource() instanceof JTextComponent)) {
                    return;
                }
                JPopupMenu popup = this.createPopup();
                this.textComponent = (JTextComponent)e2.getSource();
                this.textComponent.requestFocus();
                boolean enabled = this.textComponent.isEnabled();
                boolean editable = this.textComponent.isEditable();
                boolean nonempty = this.textComponent.getText() != null && !this.textComponent.getText().equals("");
                boolean marked = this.textComponent.getSelectedText() != null;
                boolean pasteAvailable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
                this.cutItem.setEnabled(enabled && editable && marked);
                this.copyItem.setEnabled(enabled && marked);
                this.pasteItem.setEnabled(enabled && editable && pasteAvailable);
                this.selectAllItem.setEnabled(enabled && nonempty);
                popup.show(e2.getComponent(), e2.getX(), e2.getY());
            }
        }
    }
}

