/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.Preferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LangStrings {
    private Map<String, String> strings;

    public LangStrings(Map<String, String> strings) {
        this.strings = strings;
    }

    public String toString() {
        String lang = Preferences.getInstance().getLocale().getLanguage();
        return this.getString(lang);
    }

    public String getString(String language) {
        String string = this.strings.get(language);
        if (string == null) {
            if (this.strings.size() == 1) {
                Iterator<String> it = this.strings.values().iterator();
                string = it.next();
            } else {
                for (String key : this.strings.keySet()) {
                    String lang;
                    int indexOfDash = key.indexOf("-");
                    if (indexOfDash == -1 || !language.equals(lang = key.substring(0, indexOfDash))) continue;
                    return this.strings.get(key);
                }
                for (String key : this.strings.keySet()) {
                    String lang;
                    if (key.length() <= 2 || !language.equals(lang = key.substring(0, 2))) continue;
                    return this.strings.get(key);
                }
                string = this.strings.get("en");
                if (string == null) {
                    string = this.strings.get("fr");
                }
            }
        }
        return string;
    }

    public List<String> getOrderedStrings() {
        ArrayList<String> orderedStrings = new ArrayList<String>();
        Object[] languages = this.strings.keySet().toArray();
        Arrays.sort(languages);
        for (Object lang : languages) {
            orderedStrings.add((String)lang);
            orderedStrings.add(this.strings.get(lang));
        }
        return orderedStrings;
    }
}

