/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormContainer;
import ca.licef.lompad.FormWrapper;
import ca.licef.lompad.IllegalTagException;
import ca.licef.lompad.OrCompositeComponent;
import ca.licef.lompad.Util;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrCompositeForm
extends FormContainer {
    public OrCompositeForm(boolean isMultiple) {
        super(isMultiple);
    }

    @Override
    public void clearFormIcon() {
    }

    @Override
    void addFormContent() {
        FormWrapper wrapper = new FormWrapper("4.4.1", true);
        wrapper.setIcon(Util.greenIcon);
        wrapper.addToggle();
        OrCompositeComponent c = new OrCompositeComponent();
        c.setMinimumSize(new Dimension(10, 100));
        c.setPreferredSize(new Dimension(10, 100));
        c.setMaximumSize(new Dimension(2000, 100));
        wrapper.addComponent(c);
        this.addComponent(wrapper);
    }

    @Override
    String toXML(String key) {
        String xml = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = ((FormWrapper)c).toXML(key, false);
            if (res == null) continue;
            xml = xml + "<" + Util.getTag(key) + ">\n" + res + "</" + Util.getTag(key) + ">\n";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        NodeList list = e2.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String pathElem = path + "/" + child.getTagName().toLowerCase();
            FormWrapper c = null;
            try {
                int pos = Util.getPosTag(pathElem);
                if (this.isFilled()) {
                    if (!this.isMultipleContainer) {
                        return;
                    }
                    this.addFormContent();
                    c = (FormWrapper)this.vComponents.lastElement();
                } else {
                    c = (FormWrapper)this.vComponents.firstElement();
                }
                c.fromXML(pathElem, child, false, observations);
                continue;
            }
            catch (IllegalTagException illegalTagException) {
                // empty catch block
            }
        }
    }

    @Override
    String toHTMLData(String key) {
        String html = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c instanceof FormContainer ? c.toHTMLData(key) : c.toHTML(key);
            if (res == null) continue;
            html = html + (html.equals("") ? "" : ("fr".equals(Util.resBundleLabel.getLocale().getLanguage()) ? "OU" : "OR") + "<br>") + res;
        }
        if (html.equals("")) {
            html = null;
        }
        return html;
    }
}

