/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormContainer;
import ca.licef.lompad.IllegalTagException;
import ca.licef.lompad.LangstringForm;
import ca.licef.lompad.LangstringMediator;
import ca.licef.lompad.Preferences;
import ca.licef.lompad.TaxonComponent;
import ca.licef.lompad.Util;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaxonElementForm
extends FormContainer {
    Object[] values = (Object[])LangstringForm.values.clone();

    public TaxonElementForm() {
        super(true);
        this.mediator = new LangstringMediator(this, this.values);
        this.offset = 2;
    }

    @Override
    void addFormContent() {
        TaxonComponent c = new TaxonComponent((LangstringMediator)this.mediator, this.vComponents.size() == 0);
        c.setMinimumSize(new Dimension(10, 25));
        c.setPreferredSize(new Dimension(10, 25));
        c.setMaximumSize(new Dimension(2000, 25));
        this.addComponent(c);
    }

    public void setValues(Object[] taxon) {
        int index;
        String id = (String)taxon[0];
        ArrayList titles = (ArrayList)taxon[1];
        String lang = Preferences.getInstance().getLocale().getLanguage();
        if ("".equals(lang)) {
            lang = "en";
        }
        if ((index = titles.indexOf(lang)) != -1) {
            String entry = (String)titles.remove(index + 1);
            titles.remove(index);
            titles.add(0, lang);
            titles.add(1, entry);
        }
        Iterator it = titles.iterator();
        while (it.hasNext()) {
            lang = (String)it.next();
            String entry = (String)it.next();
            TaxonComponent c = null;
            if (this.isFilled()) {
                this.addFormContent();
                c = (TaxonComponent)this.vComponents.lastElement();
            } else {
                c = (TaxonComponent)this.vComponents.firstElement();
            }
            c.setValues(id, entry, lang);
        }
    }

    @Override
    String toXML(String key) {
        String xml = "";
        String xml_Id = null;
        String xml_Entry = "";
        int i = 0;
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            String res;
            TaxonComponent c = (TaxonComponent)e2.nextElement();
            if (i == 0) {
                xml_Id = c.toXML_Id(key);
            }
            if ((res = c.toXML_Entry()) != null) {
                xml_Entry = xml_Entry + res + "\n";
            }
            ++i;
        }
        if (xml_Id != null) {
            xml = xml + xml_Id;
        }
        if (!xml_Entry.equals("")) {
            xml = xml + "<" + Util.getTag(key + ".2") + ">" + xml_Entry + "</" + Util.getTag(key + ".2") + ">\n";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        NodeList list = e2.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            String pathElem = path + "/" + child.getTagName().toLowerCase();
            try {
                TaxonComponent c = null;
                int pos = Util.getPosTag(pathElem);
                c = (TaxonComponent)this.vComponents.firstElement();
                if (pos == 1) {
                    c.fromXML_Id(child);
                }
                if (pos != 2) continue;
                if (this.isFilled()) {
                    this.addFormContent();
                    c = (TaxonComponent)this.vComponents.lastElement();
                }
                NodeList list2 = child.getElementsByTagNameNS("http://ltsc.ieee.org/xsd/LOM", "string");
                for (int i2 = 0; i2 < list2.getLength(); ++i2) {
                    Node node2 = list2.item(i2);
                    if (node2.getNodeType() != 1) continue;
                    Element child2 = (Element)node2;
                    if (c == null) {
                        this.addFormContent();
                        c = (TaxonComponent)this.vComponents.lastElement();
                    }
                    c.fromXML_Entry(child2);
                    c = null;
                }
                continue;
            }
            catch (IllegalTagException illegalTagException) {
                // empty catch block
            }
        }
    }

    @Override
    String toHTMLData(String key) {
        String html = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c instanceof FormContainer ? c.toHTMLData(key) : c.toHTML(key);
            if (res == null) continue;
            if (!"".equals(html)) {
                html = html + "; ";
            }
            html = html + res;
        }
        html = html.equals("") ? null : html + "<br>";
        return html;
    }
}

