/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormContainer;
import ca.licef.lompad.FormMediator;
import ca.licef.lompad.TextComponent;
import ca.licef.lompad.Util;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextForm
extends FormContainer {
    boolean isOneLine;
    Object[] numericParam;

    public TextForm(String title, boolean isLine, boolean isMultipleContainer, boolean isOneLine) {
        super(title, isLine, isMultipleContainer);
        this.isOneLine = isOneLine;
        this.mediator = new FormMediator(this);
        this.offset = 2;
    }

    @Override
    void addFormContent() {
        TextComponent c = new TextComponent(this.mediator, this.isOneLine);
        if (this.numericParam != null) {
            c.setNumericTextField(this.numericParam);
        }
        int height = this.isOneLine ? 25 : 60;
        c.setMinimumSize(new Dimension(10, height));
        c.setPreferredSize(new Dimension(10, height));
        c.setMaximumSize(new Dimension(2000, height));
        this.addComponent(c);
        this.mediator.buttonAddComponentPerformed(c);
    }

    void setNumericTextField(int length, String minMask, String maxMask) {
        this.numericParam = new Object[]{new Integer(length), minMask, maxMask};
    }

    @Override
    String toXML(String key) {
        String xml = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c.toXML(key);
            if (res == null || "".equals(res.trim())) continue;
            xml = xml + "<" + Util.getTag(key) + ">" + res.trim() + "</" + Util.getTag(key) + ">\n";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    String defaultToXML(String key) {
        return super.toXML(key);
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        TextComponent c = null;
        if (this.isFilled()) {
            if (!this.isMultipleContainer) {
                return;
            }
            this.addFormContent();
            c = (TextComponent)this.vComponents.lastElement();
        } else {
            c = (TextComponent)this.vComponents.firstElement();
        }
        c.fromXML(path, e2, observations);
    }

    @Override
    String toHTML(String key) {
        return this.toHTMLRow(key);
    }
}

