/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;

public class JSONInputIterator
extends QueryIteratorBase {
    private InputStream input;
    private boolean isBooleanResults = false;
    private boolean boolResult = false;
    private boolean headerSeen = false;
    private Binding binding = null;
    private TokenizerJSON tokens;
    private PeekIterator<Token> peekIter;
    private Queue<Binding> cache = new LinkedList<Binding>();
    private Set<String> vars = new HashSet<String>();
    private Token tokenEOF = null;
    protected long currLine = -1L;
    protected long currCol = -1L;

    public JSONInputIterator(InputStream input) {
        this.input = input;
        this.tokens = new TokenizerJSON(PeekReader.makeUTF8(input));
        this.peekIter = new PeekIterator<Token>(this.tokens);
        this.preParse();
    }

    public Iterator<String> getVars() {
        return this.vars.iterator();
    }

    public boolean isBooleanResult() {
        return this.isBooleanResults;
    }

    private void preParse() {
        this.expect("Expected the start of the JSON Results Object", TokenType.LBRACE);
        while (true) {
            if (!this.isPropertyName()) {
                Token t = this.nextToken();
                String name = t.getImage();
                this.checkColon();
                if (name.equals("head")) {
                    if (this.headerSeen) {
                        this.exception(t, "Invalid duplicate header property", new Object[0]);
                    }
                    this.parseHeader();
                } else if (name.equals("boolean")) {
                    this.parseBoolean();
                } else if (name.equals("results")) {
                    if (this.isBooleanResults) {
                        this.exception(t, "Encountered results property when boolean property has already been countered", new Object[0]);
                    }
                    this.parseToFirstResult();
                    if (this.headerSeen) {
                        return;
                    }
                    boolean complete = this.cacheResults(100);
                    if (!complete) {
                        return;
                    }
                } else {
                    this.ignoreValue();
                }
                this.checkComma(TokenType.RBRACE);
                continue;
            }
            if (this.lookingAt(TokenType.RBRACE)) {
                if (!this.headerSeen) {
                    this.exception(this.peekToken(), "End of JSON Results Object encountered before a valid header was seen", new Object[0]);
                }
                this.nextToken();
                if (!this.lookingAt(TokenType.EOF)) {
                    this.exception(this.peekToken(), "Unexpected content after end of JSON Results Object", new Object[0]);
                }
                return;
            }
            this.exception(this.peekToken(), "Expected a JSON property name but got %s", this.peekToken());
        }
    }

    private void parseHeader() {
        while (true) {
            if (this.isPropertyName()) {
                Token t = this.nextToken();
                String name = t.getImage();
                this.checkColon();
                if (name.equals("vars")) {
                    this.parseVars();
                } else if (name.equals("link")) {
                    this.skipLinks();
                } else {
                    this.exception(t, "Unexpected property %s encountered in head object", name);
                }
                this.checkComma(TokenType.RBRACE);
                continue;
            }
            if (this.lookingAt(TokenType.RBRACE)) {
                this.nextToken();
                return;
            }
            this.exception(this.peekToken(), "Unexpected Token encountered while parsing head object", new Object[0]);
        }
    }

    private void parseVars() {
        if (this.lookingAt(TokenType.LBRACKET)) {
            this.nextToken();
            this.vars.clear();
            while (true) {
                if (this.lookingAt(TokenType.STRING1) || this.lookingAt(TokenType.STRING2)) {
                    Token t = this.nextToken();
                    String var = t.getImage();
                    this.vars.add(var);
                    this.checkComma(TokenType.RBRACKET);
                    continue;
                }
                if (this.lookingAt(TokenType.RBRACKET)) {
                    this.nextToken();
                    return;
                }
                this.exception(this.peekToken(), "Unexpected Token encountered while parsing the variables list in the head object", new Object[0]);
            }
        }
        this.exception(this.peekToken(), "Unexpected Token ecountered, expected a [ to start the array of variables in the head object", new Object[0]);
    }

    private void skipLinks() {
        if (this.lookingAt(TokenType.LBRACKET)) {
            this.nextToken();
            while (true) {
                if (this.lookingAt(TokenType.RBRACKET)) {
                    this.nextToken();
                    return;
                }
                if (this.lookingAt(TokenType.STRING1) || this.lookingAt(TokenType.STRING2)) {
                    this.nextToken();
                } else {
                    this.exception(this.peekToken(), "Unexpected Token when a Link URI was expected", new Object[0]);
                }
                this.checkComma(TokenType.RBRACKET);
            }
        }
        this.exception(this.peekToken(), "Unexpected token when a [ was expected to start the list of URIs for a link property", new Object[0]);
    }

    private void parseToFirstResult() {
        if (this.lookingAt(TokenType.LBRACE)) {
            this.nextToken();
            if (this.isPropertyName()) {
                Token t = this.nextToken();
                String name = t.getImage();
                if (name.equals("bindings")) {
                    this.checkColon();
                    if (this.lookingAt(TokenType.LBRACKET)) {
                        this.nextToken();
                    } else {
                        this.exception(this.peekToken(), "Unexpected Token encountered, expected a [ for the start of the bindings array", new Object[0]);
                    }
                } else {
                    this.exception(t, "Unexpected Token encountered, expected the bindings property", new Object[0]);
                }
            } else {
                this.exception(this.peekToken(), "Unexpected Token ecnountered, expected the bindings property", new Object[0]);
            }
        } else {
            this.exception(this.peekToken(), "Unexpected Token encountered, expected a { to start the results list object", new Object[0]);
        }
    }

    private void parseToEnd() {
        this.checkComma(TokenType.RBRACE);
    }

    private void ignoreValue() {
        if (this.isPropertyName()) {
            this.nextToken();
            this.checkComma(TokenType.RBRACE);
        } else if (this.lookingAt(TokenType.DECIMAL) || this.lookingAt(TokenType.INTEGER) || this.lookingAt(TokenType.DOUBLE) || this.lookingAt(TokenType.KEYWORD)) {
            this.nextToken();
            this.checkComma(TokenType.RBRACE);
        } else if (this.lookingAt(TokenType.LBRACE)) {
            this.nextToken();
            int openBraces = 1;
            while (openBraces >= 1) {
                Token next = this.nextToken();
                if (next.getType().equals((Object)TokenType.LBRACE)) {
                    ++openBraces;
                    continue;
                }
                if (!next.getType().equals((Object)TokenType.RBRACE)) continue;
                --openBraces;
            }
            this.checkComma(TokenType.RBRACE);
        } else if (this.lookingAt(TokenType.LBRACKET)) {
            this.nextToken();
            int openBraces = 1;
            while (openBraces >= 1) {
                Token next = this.nextToken();
                if (next.getType().equals((Object)TokenType.LBRACKET)) {
                    ++openBraces;
                    continue;
                }
                if (!next.getType().equals((Object)TokenType.RBRACKET)) continue;
                --openBraces;
            }
            this.checkComma(TokenType.RBRACE);
        } else {
            this.exception(this.peekToken(), "Unexpected Token", new Object[0]);
        }
    }

    private boolean cacheResults(int n) {
        for (int i = 0; i < n; ++i) {
            if (!this.parseNextBinding()) {
                return true;
            }
            this.cache.add(this.binding);
            this.binding = null;
        }
        return false;
    }

    private void parseBoolean() {
        this.isBooleanResults = true;
        if (this.lookingAt(TokenType.KEYWORD)) {
            Token t = this.nextToken();
            String keyword = t.getImage();
            if (keyword.equals("true")) {
                this.boolResult = true;
            } else if (keyword.equals("false")) {
                this.boolResult = false;
            } else {
                this.exception(t, "Unexpected keyword %s encountered, expected true or false", keyword);
            }
        } else {
            this.exception(this.peekToken(), "Unexpected token when a true/false keyword was expected for the value of the boolean property", new Object[0]);
        }
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println("JSONInputIterator");
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.isBooleanResults) {
            return false;
        }
        if (this.input != null) {
            if (this.cache.size() > 0) {
                this.binding = this.cache.remove();
                return true;
            }
            if (this.binding == null) {
                return this.parseNextBinding();
            }
            return true;
        }
        return false;
    }

    private boolean parseNextBinding() {
        if (this.lookingAt(TokenType.LBRACE)) {
            this.nextToken();
            BindingMap b = BindingFactory.create();
            while (true) {
                if (this.isPropertyName()) {
                    Token t = this.nextToken();
                    String var = t.getImage();
                    this.checkColon();
                    Node n = this.parseNode();
                    b.add(Var.alloc(var), n);
                    this.checkComma(TokenType.RBRACE);
                    continue;
                }
                if (this.lookingAt(TokenType.RBRACE)) break;
                this.exception(this.peekToken(), "Unexpected Token encountered, expected a property name to indicate the value for a variable", new Object[0]);
            }
            this.nextToken();
            this.checkComma(TokenType.RBRACKET);
            this.binding = b;
            return true;
        }
        if (this.lookingAt(TokenType.RBRACKET)) {
            this.nextToken();
            if (this.lookingAt(TokenType.RBRACE)) {
                this.nextToken();
                this.parseToEnd();
            } else {
                this.exception(this.peekToken(), "Unexpected Token encountered, expected a } to end the results object", new Object[0]);
            }
        } else {
            this.exception(this.peekToken(), "Unexpected Token encountered, expected a { for the start of a binding of ] to end the array of bindings", new Object[0]);
        }
        return false;
    }

    private Node parseNode() {
        String datatype = null;
        String lang = null;
        String value = null;
        String type = null;
        if (this.lookingAt(TokenType.LBRACE)) {
            Token pos = this.nextToken();
            while (true) {
                if (this.isPropertyName()) {
                    Token t = this.nextToken();
                    String name = t.getImage();
                    this.checkColon();
                    if (name.equals("type")) {
                        if (type != null) {
                            this.exception(t, "Illegal duplicate type property", new Object[0]);
                        }
                        type = this.parseNodeInfo("type");
                        continue;
                    }
                    if (name.equals("value")) {
                        if (value != null) {
                            this.exception(t, "Illegal duplicate value property", new Object[0]);
                        }
                        value = this.parseNodeInfo("value");
                        continue;
                    }
                    if (name.equals("datatype")) {
                        if (datatype != null) {
                            this.exception(t, "Illegal duplicate datatype property", new Object[0]);
                        }
                        datatype = this.parseNodeInfo("datatype");
                        continue;
                    }
                    if (name.equals("xml:lang")) {
                        if (lang != null) {
                            this.exception(t, "Illegal duplicate xml:lang property", new Object[0]);
                        }
                        lang = this.parseNodeInfo("xml:lang");
                        continue;
                    }
                    this.exception(t, "Unexpected Property Name '%s', expected one of type, value, datatype or xml:lang", name);
                    continue;
                }
                if (this.lookingAt(TokenType.RBRACE)) break;
                this.exception(this.peekToken(), "Unexpected Token, expected a property name as part of a Node object", new Object[0]);
            }
            this.nextToken();
            if (type == null) {
                this.exception(pos, "Encountered a Node object with no type property", new Object[0]);
            }
            if (value == null) {
                this.exception(pos, "Encountered a Node object with no value property", new Object[0]);
            }
            if (type.equals("uri")) {
                return NodeFactory.createURI(value);
            }
            if (type.equals("literal")) {
                if (datatype != null) {
                    return NodeFactory.createLiteral(value, TypeMapper.getInstance().getSafeTypeByName(datatype));
                }
                if (lang != null) {
                    return NodeFactory.createLiteral(value, lang, false);
                }
                return NodeFactory.createLiteral(value);
            }
            if (type.equals("bnode")) {
                return NodeFactory.createAnon(new AnonId(value));
            }
            this.exception(pos, "Encountered a Node object with an invalid type value '%s', expected one of uri, literal or bnode", type);
        } else {
            this.exception(this.peekToken(), "Unexpected Token, expected a { for the start of a Node object", new Object[0]);
        }
        return null;
    }

    private String parseNodeInfo(String name) {
        if (this.lookingAt(TokenType.STRING1) || this.lookingAt(TokenType.STRING2)) {
            Token t = this.nextToken();
            String value = t.getImage();
            this.checkComma(TokenType.RBRACE);
            return value;
        }
        this.exception(this.peekToken(), "Unexpected Token, expected a string as the value for the %s property", name);
        return null;
    }

    @Override
    protected Binding moveToNextBinding() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Binding b = this.binding;
        this.binding = null;
        return b;
    }

    @Override
    protected void closeIterator() {
        IO.close(this.input);
        this.input = null;
    }

    @Override
    protected void requestCancel() {
    }

    private boolean isPropertyName() {
        return this.lookingAt(TokenType.STRING1) || this.lookingAt(TokenType.STRING2);
    }

    private Token checkValidForStringProperty(String property) {
        Token t = null;
        if (this.lookingAt(TokenType.STRING1) || this.lookingAt(TokenType.STRING2)) {
            t = this.nextToken();
        } else {
            this.exception(this.peekToken(), "JSON Values given for property " + property + " must be Strings", new Object[0]);
        }
        return t;
    }

    private void checkColon() {
        if (!this.lookingAt(TokenType.COLON)) {
            this.exception(this.peekToken(), "Expected a : character after a JSON Property Name but got %s", this.peekToken());
        }
        this.nextToken();
    }

    private void checkComma(TokenType terminator) {
        if (this.lookingAt(TokenType.COMMA)) {
            this.nextToken();
        } else {
            if (this.lookingAt(terminator)) {
                return;
            }
            this.exception(this.peekToken(), "Unexpected Token encountered, expected a , or a %s", new Object[]{terminator});
        }
    }

    protected final Token peekToken() {
        if (this.eof()) {
            return this.tokenEOF;
        }
        return this.peekIter.peek();
    }

    protected final boolean eof() {
        if (this.tokenEOF != null) {
            return true;
        }
        if (!this.moreTokens()) {
            this.tokenEOF = new Token(this.tokens.getLine(), this.tokens.getColumn());
            this.tokenEOF.setType(TokenType.EOF);
            return true;
        }
        return false;
    }

    protected final boolean moreTokens() {
        return this.peekIter.hasNext();
    }

    protected final boolean lookingAt(TokenType tokenType) {
        if (this.eof()) {
            return tokenType == TokenType.EOF;
        }
        if (tokenType == TokenType.NODE) {
            return this.peekToken().isNode();
        }
        return this.peekToken().hasType(tokenType);
    }

    protected final Token nextToken() {
        if (this.eof()) {
            return this.tokenEOF;
        }
        try {
            Token t = this.peekIter.next();
            this.currLine = t.getLine();
            this.currCol = t.getColumn();
            return t;
        }
        catch (RiotParseException ex) {
            this.raiseException(ex);
            throw ex;
        }
        catch (AtlasException ex) {
            RiotParseException ex2 = new RiotParseException(ex.getMessage(), -1L, -1L);
            this.raiseException(ex2);
            throw ex2;
        }
    }

    protected final void expectOrEOF(String msg, TokenType tokenType) {
        if (this.eof()) {
            return;
        }
        this.expect(msg, tokenType);
    }

    protected final void expect(String msg, TokenType ttype) {
        if (!this.lookingAt(ttype)) {
            Token location = this.peekToken();
            this.exception(location, msg, new Object[0]);
        }
        this.nextToken();
    }

    protected final void exception(Token token, String msg, Object ... args) {
        if (token != null) {
            this.exceptionDirect(String.format(msg, args), token.getLine(), token.getColumn());
        } else {
            this.exceptionDirect(String.format(msg, args), -1L, -1L);
        }
    }

    protected final void exceptionDirect(String msg, long line, long col) {
        this.raiseException(new RiotParseException(msg, line, col));
    }

    protected final void raiseException(RiotParseException ex) {
        throw new QueryException("Error passing SPARQL JSON results", ex);
    }
}

