/*
 * Decompiled with CFR 0.152.
 */
package licef;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.MimetypesFileTypeMap;
import licef.StringUtil;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.impl.client.DefaultHttpClient;

public class IOUtil {
    public static final String UTF8_BOM = "\ufeff";
    private static MimetypesFileTypeMap mimeTypes = null;

    public static boolean isURL(String s) {
        try {
            new URL(s);
            return !s.startsWith("file:/");
        }
        catch (MalformedURLException e2) {
            return false;
        }
    }

    public static void getFile(String url, File file, boolean isCompressed) throws Exception {
        FileOutputStream outputStream = null;
        DataInputStream inputStream = null;
        try {
            URL u = new URL(url);
            outputStream = new FileOutputStream(file);
            inputStream = isCompressed ? new DataInputStream(new GZIPInputStream(u.openStream())) : new DataInputStream(u.openStream());
            IOUtil.copy(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
        }
        catch (Exception e2) {
            System.out.println(e2 + "");
        }
    }

    public static void getFile(String url, File file) throws Exception {
        IOUtil.getFile(url, file, false);
    }

    public static byte[] readFileIntoByteArray(File file, boolean isCompressed) {
        try {
            byte[] buffer = null;
            FileInputStream fisInput = new FileInputStream(file);
            DataInputStream input = null;
            input = isCompressed ? new DataInputStream(new GZIPInputStream(fisInput)) : new DataInputStream(fisInput);
            buffer = new byte[input.available()];
            input.readFully(buffer);
            input.close();
            return buffer;
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static byte[] readFileIntoByteArray(File file) {
        return IOUtil.readFileIntoByteArray(file, false);
    }

    public static byte[] readFileIntoByteArray(URL url, boolean isCompressed) {
        try {
            byte[] buffer = null;
            DataInputStream input = null;
            input = isCompressed ? new DataInputStream(new GZIPInputStream(url.openStream())) : new DataInputStream(url.openStream());
            buffer = new byte[input.available()];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtil.copy(input, output);
            buffer = output.toByteArray();
            input.close();
            output.close();
            return buffer;
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static byte[] readFileIntoByteArray(URL url) {
        return IOUtil.readFileIntoByteArray(url, false);
    }

    public static void writeByteArrayToFile(byte[] buffer, File file, boolean isCompressed) {
        IOUtil.createDirectory(file.getParent());
        try {
            FileOutputStream foutput = new FileOutputStream(file);
            DataOutputStream output = null;
            output = isCompressed ? new DataOutputStream(new GZIPOutputStream(foutput)) : new DataOutputStream(foutput);
            output.write(buffer);
            output.flush();
            output.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void writeByteArrayToFile(byte[] buffer, File file) {
        IOUtil.writeByteArrayToFile(buffer, file, false);
    }

    public static byte[] compressByteArray(byte[] array) {
        try {
            ByteArrayOutputStream bOutput = new ByteArrayOutputStream();
            GZIPOutputStream gOutput = new GZIPOutputStream(bOutput);
            gOutput.write(array);
            gOutput.finish();
            return bOutput.toByteArray();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static byte[] decompressByteArray(byte[] zipArray) {
        try {
            int bytesRead;
            ByteArrayInputStream bInput = new ByteArrayInputStream(zipArray);
            GZIPInputStream gInput = new GZIPInputStream(bInput);
            ByteArrayOutputStream bOutput = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((bytesRead = gInput.read(buffer)) != -1) {
                bOutput.write(buffer, 0, bytesRead);
            }
            return bOutput.toByteArray();
        }
        catch (IOException e2) {
            System.out.println("" + e2);
            return null;
        }
    }

    public static Object readObject(File file, boolean isCompressed) {
        Object object = null;
        try {
            FileInputStream fisInput = new FileInputStream(file);
            ObjectInputStream input = isCompressed ? new ObjectInputStream(new GZIPInputStream(fisInput)) : new ObjectInputStream(fisInput);
            object = input.readObject();
            input.close();
            return object;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static Object readObject(File file) {
        return IOUtil.readObject(file, false);
    }

    public static Object readObject(URL url, boolean isCompressed) throws ClassNotFoundException, OptionalDataException, StreamCorruptedException, IOException {
        Object object = null;
        InputStream isInput = url.openStream();
        ObjectInputStream input = new ObjectInputStream(isCompressed ? new GZIPInputStream(isInput) : isInput);
        object = input.readObject();
        input.close();
        return object;
    }

    public static Object readObject(URL url) throws ClassNotFoundException, OptionalDataException, StreamCorruptedException, IOException {
        return IOUtil.readObject(url, false);
    }

    public static Object readObject(byte[] buffer) {
        Object object = null;
        try {
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(buffer));
            object = input.readObject();
            input.close();
            return object;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static void writeObject(File file, Object object, boolean isCompressed) {
        if (file.getParent() != null) {
            IOUtil.createDirectory(file.getParent());
        }
        try {
            FileOutputStream fisOutput = new FileOutputStream(file);
            ObjectOutputStream output = isCompressed ? new ObjectOutputStream(new GZIPOutputStream(fisOutput)) : new ObjectOutputStream(fisOutput);
            output.writeObject(object);
            output.flush();
            output.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void writeObject(File file, Object object) {
        IOUtil.writeObject(file, object, false);
    }

    public static byte[] writeObject(Object object) {
        try {
            ByteArrayOutputStream bOutput = new ByteArrayOutputStream();
            ObjectOutputStream oOutput = new ObjectOutputStream(bOutput);
            oOutput.writeObject(object);
            oOutput.flush();
            return bOutput.toByteArray();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static Vector readLines(URL url) {
        try {
            return IOUtil.readLines(url.openStream());
        }
        catch (IOException e2) {
            System.out.println(e2 + "");
            return null;
        }
    }

    public static Vector readLines(File file) {
        try {
            return IOUtil.readLines(new FileInputStream(file));
        }
        catch (FileNotFoundException e2) {
            System.out.println("" + e2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector readLines(InputStream in) {
        Vector<String> v = new Vector<String>();
        boolean firstLine = true;
        try {
            String nextLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((nextLine = br.readLine()) != null) {
                if (firstLine) {
                    if (nextLine.startsWith(UTF8_BOM)) {
                        nextLine = nextLine.substring(1);
                    }
                    firstLine = false;
                }
                v.addElement(nextLine);
            }
            Vector<String> vector = v;
            return vector;
        }
        catch (IOException e2) {
            System.out.println(e2.toString());
            Vector vector = null;
            return vector;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {
                System.out.println(e2.toString());
                return null;
            }
        }
    }

    public static String readStringFromFile(File location) throws IOException {
        return IOUtil.readString(new FileInputStream(location));
    }

    public static String readStringFromURL(URL url) throws IOException {
        return IOUtil.readString(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream in) throws IOException {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        BufferedOutputStream bostr = new BufferedOutputStream(ostr);
        BufferedInputStream bistr = new BufferedInputStream(in);
        try {
            IOUtil.copy(bistr, bostr);
        }
        finally {
            bostr.close();
            bistr.close();
        }
        String str2 = null;
        try {
            str2 = ostr.toString("UTF-8");
        }
        catch (UnsupportedEncodingException shoulNeverHappen) {
            str2 = ostr.toString();
        }
        return str2;
    }

    public static void writeStringToFile(String str2, File location) throws IOException {
        IOUtil.writeStringToFile(str2, location, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String str2, File location, boolean append) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(location, append));
            writer.write(str2);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void createDirectory(String dir) {
        String[] dirs = StringUtil.split(dir.replace('\\', '/'), '/');
        File f = null;
        for (int i = 0; i < dirs.length; ++i) {
            if ((f = f == null ? new File(dirs[i]) : new File(f, dirs[i])).exists()) continue;
            f.mkdir();
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean ok;
                if (children[i] == "." || children[i] == ".." || (ok = IOUtil.deleteDirectory(new File(dir, children[i])))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("copyFiles: Can not find source: " + src.getAbsolutePath() + ".");
        }
        if (!src.canRead()) {
            throw new IOException("copyFiles: No right to source: " + src.getAbsolutePath() + ".");
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("copyFiles: Could not create direcotry: " + dest.getAbsolutePath() + ".");
            }
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                IOUtil.copyFiles(src1, dest1);
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            try {
                fin = new FileInputStream(src);
                fout = new FileOutputStream(dest);
                IOUtil.copy(fin, fout);
            }
            catch (IOException e2) {
                IOException wrapper = new IOException("copyFiles: Unable to copy file: " + src.getAbsolutePath() + "to" + dest.getAbsolutePath() + ".");
                wrapper.initCause(e2);
                wrapper.setStackTrace(e2.getStackTrace());
                throw wrapper;
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
        }
    }

    public static String ask(String question, String defaultAnswer) throws IOException {
        StringBuffer formattedQuestion = new StringBuffer(question);
        if (defaultAnswer != null || !"".equals(defaultAnswer)) {
            formattedQuestion.append(" [").append(defaultAnswer).append("]");
        }
        formattedQuestion.append(":");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String answer = null;
        answer = reader.readLine();
        if (StringUtil.isEmpty(answer)) {
            return defaultAnswer;
        }
        return answer;
    }

    public static String ask(String question) throws IOException {
        return IOUtil.ask(question, null);
    }

    public static String enforceAbsoluteUrl(String url) {
        if (url == null || "".equals(url)) {
            return null;
        }
        if (url.startsWith("http")) {
            return url;
        }
        return "http://" + url;
    }

    public static String getMimeType(String fileOrUrl, boolean useInternet, int timeout) throws IOException {
        URL url = null;
        if (fileOrUrl.startsWith("http")) {
            url = new URL(fileOrUrl);
            if (useInternet) {
                DefaultHttpClient client = new DefaultHttpClient();
                if (timeout > 0) {
                    client.getParams().setParameter("http.connection.timeout", new Integer(timeout));
                    client.getParams().setParameter("http.socket.timeout", new Integer(timeout));
                }
                try {
                    Header header;
                    HttpHead method = new HttpHead(fileOrUrl);
                    HttpResponse resp = client.execute(method);
                    if (resp.getStatusLine().getStatusCode() == 200 && (header = resp.getFirstHeader("Content-Type")) != null) {
                        return StringUtil.split(header.getValue(), ';')[0];
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
        if (url != null) {
            String filename = url.getPath();
            int indexOfLastSlash = filename.lastIndexOf("/");
            if (indexOfLastSlash != -1) {
                filename = filename.substring(indexOfLastSlash + 1);
            }
            if ("".equals(filename)) {
                if (fileOrUrl.startsWith("http")) {
                    return "text/html";
                }
            } else {
                fileOrUrl = filename;
            }
        }
        if (mimeTypes == null) {
            IOUtil.initMimeTypes();
        }
        return mimeTypes.getContentType(fileOrUrl);
    }

    public static String getMimeType(String fileOrUrl) throws IOException {
        return IOUtil.getMimeType(fileOrUrl, true, 3000);
    }

    private static void initMimeTypes() throws IOException {
        mimeTypes = new MimetypesFileTypeMap();
        String[] mimeTypeDefinitions = IOUtil.getMimeTypeDefinitions();
        for (int i = 0; i < mimeTypeDefinitions.length; ++i) {
            mimeTypes.addMimeTypes(mimeTypeDefinitions[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getMimeTypeDefinitions() throws IOException {
        String line = null;
        ArrayList<String> defs = new ArrayList<String>();
        InputStream is = null;
        try {
            is = IOUtil.class.getResourceAsStream("mime.types");
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                defs.add(line);
            }
        }
        finally {
            is.close();
        }
        String[] aDefs = new String[defs.size()];
        return defs.toArray(aDefs);
    }
}

