/*
 * Decompiled with CFR 0.152.
 */
package licef;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionUtil {
    private static Pattern vp4 = Pattern.compile(".*(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+).*");
    private static Pattern vp3 = Pattern.compile(".*(\\d+)\\.(\\d+)\\.(\\d+).*");
    private static Pattern vp2 = Pattern.compile(".*(\\d+)\\.(\\d+).*");
    private static Pattern vp1 = Pattern.compile(".*(\\d+).*");
    private static Pattern[] versionPatterns = new Pattern[]{vp4, vp3, vp2, vp1};

    public static int compare(String v1, String v2) {
        return VersionUtil.compare(VersionUtil.getVersionParts(v1), VersionUtil.getVersionParts(v2));
    }

    public static ArrayList<Integer> getVersionParts(String version2) {
        ArrayList<Integer> parts = new ArrayList<Integer>();
        if (version2 == null) {
            return parts;
        }
        for (int i = 0; i < versionPatterns.length; ++i) {
            Matcher m = versionPatterns[i].matcher(version2);
            if (!m.matches()) continue;
            for (int g = 1; g <= m.groupCount(); ++g) {
                parts.add(Integer.parseInt(m.group(g)));
            }
            break;
        }
        return parts;
    }

    private static int compare(ArrayList<Integer> v1Parts, ArrayList<Integer> v2Parts) {
        int test;
        int i = 0;
        while (true) {
            if (v2Parts.size() < i + 1) {
                if (v1Parts.size() < i + 1) {
                    return 0;
                }
                return 1;
            }
            if (v1Parts.size() < i + 1) {
                return -1;
            }
            test = v1Parts.get(i).compareTo(v2Parts.get(i));
            if (test != 0) break;
            ++i;
        }
        return test;
    }
}

