/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.PrintStream;
import java.io.Serializable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.SAXException;

public class StandardErrorListener
implements ErrorListener,
Serializable {
    private int recoveryPolicy = 1;
    private int warningCount = 0;
    protected transient PrintStream errorOutput = System.err;

    public StandardErrorListener makeAnother(int hostLanguage) {
        return new StandardErrorListener();
    }

    public void setErrorOutput(PrintStream writer) {
        this.errorOutput = writer;
    }

    public PrintStream getErrorOutput() {
        return this.errorOutput;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void warning(TransformerException exception) throws TransformerException {
        if (this.recoveryPolicy == 0) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        String message = "";
        if (exception.getLocator() != null) {
            message = StandardErrorListener.getLocationMessage(exception) + "\n  ";
        }
        message = message + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(exception));
        if (exception instanceof ValidationException) {
            this.errorOutput.println("Validation error " + message);
        } else {
            this.errorOutput.println("Warning: " + message);
            ++this.warningCount;
            if (this.warningCount > 25) {
                this.errorOutput.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        }
    }

    public void error(TransformerException exception) throws TransformerException {
        String message;
        if (this.recoveryPolicy == 0) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        if (exception instanceof ValidationException) {
            String explanation = StandardErrorListener.getExpandedMessage(exception);
            String constraintReference = ((ValidationException)exception).getConstraintReferenceMessage();
            if (constraintReference != null) {
                explanation = explanation + " (" + constraintReference + ')';
            }
            message = "Validation error " + StandardErrorListener.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(explanation);
        } else {
            String prefix = this.recoveryPolicy == 1 ? "Recoverable error " : "Error ";
            message = prefix + StandardErrorListener.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(exception));
        }
        if (exception instanceof ValidationException) {
            this.errorOutput.println(message);
        } else if (this.recoveryPolicy == 1) {
            this.errorOutput.println(message);
            ++this.warningCount;
            if (this.warningCount > 25) {
                this.errorOutput.println("No more warnings will be displayed");
                this.recoveryPolicy = 0;
                this.warningCount = 0;
            }
        } else {
            this.errorOutput.println(message);
            this.errorOutput.println("Processing terminated because error recovery is disabled");
            throw XPathException.makeXPathException(exception);
        }
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        String message;
        if (exception instanceof XPathException && ((XPathException)exception).hasBeenReported()) {
            return;
        }
        if (this.errorOutput == null) {
            this.errorOutput = System.err;
        }
        if (exception instanceof ValidationException) {
            String explanation = StandardErrorListener.getExpandedMessage(exception);
            String constraintReference = ((ValidationException)exception).getConstraintReferenceMessage();
            if (constraintReference != null) {
                explanation = explanation + " (" + constraintReference + ')';
            }
            message = "Validation error " + StandardErrorListener.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(explanation);
        } else {
            message = "Error " + StandardErrorListener.getLocationMessage(exception) + "\n  " + StandardErrorListener.wordWrap(StandardErrorListener.getExpandedMessage(exception));
        }
        this.errorOutput.println(message);
        if (exception instanceof XPathException) {
            ((XPathException)exception).setHasBeenReported();
        }
    }

    public static String getLocationMessage(TransformerException err) {
        SourceLocator loc = err.getLocator();
        while (loc == null) {
            if (err.getException() instanceof TransformerException) {
                err = (TransformerException)err.getException();
                loc = err.getLocator();
                continue;
            }
            if (err.getCause() instanceof TransformerException) {
                err = (TransformerException)err.getCause();
                loc = err.getLocator();
                continue;
            }
            return "";
        }
        XPathContext context = null;
        if (err instanceof XPathException) {
            context = ((XPathException)err).getXPathContext();
        }
        return StandardErrorListener.getLocationMessage(loc, context);
    }

    private static String getLocationMessage(SourceLocator loc, XPathContext context) {
        String locmessage = "";
        String systemId = null;
        int lineNumber = -1;
        if (loc instanceof DOMLocator) {
            locmessage = locmessage + "at " + ((DOMLocator)loc).getOriginatingNode().getNodeName() + ' ';
        } else if (loc instanceof NodeInfo) {
            locmessage = locmessage + "at " + ((NodeInfo)((Object)loc)).getDisplayName() + ' ';
        } else if (loc instanceof InstructionInfoProvider) {
            String instructionName = StandardErrorListener.getInstructionName((InstructionInfoProvider)((Object)loc), context);
            if (!"".equals(instructionName)) {
                locmessage = locmessage + "at " + instructionName + ' ';
            }
            systemId = ((InstructionInfoProvider)((Object)loc)).getInstructionInfo().getSystemId();
            lineNumber = ((InstructionInfoProvider)((Object)loc)).getInstructionInfo().getLineNumber();
        }
        if (lineNumber == -1) {
            lineNumber = loc.getLineNumber();
        }
        if (lineNumber != -1) {
            locmessage = locmessage + "on line " + lineNumber + ' ';
        }
        if (loc.getColumnNumber() != -1) {
            locmessage = locmessage + "column " + loc.getColumnNumber() + ' ';
        }
        if (systemId != null && systemId.length() == 0) {
            systemId = null;
        }
        if (systemId == null) {
            systemId = loc.getSystemId();
        }
        if (systemId != null && systemId.length() != 0) {
            locmessage = locmessage + "of " + systemId + ':';
        }
        return locmessage;
    }

    public static String getExpandedMessage(TransformerException err) {
        String code = null;
        if (err instanceof XPathException) {
            code = ((XPathException)err).getErrorCodeLocalPart();
        }
        if (code == null && err.getException() instanceof XPathException) {
            code = ((XPathException)err.getException()).getErrorCodeLocalPart();
        }
        String message = "";
        if (code != null) {
            message = code;
        }
        Throwable e2 = err;
        while (e2 != null) {
            String next = e2.getMessage();
            if (next == null) {
                next = "";
            }
            if (next.startsWith("net.sf.saxon.trans.XPathException: ")) {
                next = next.substring(next.indexOf(": ") + 2);
            }
            if (!"TRaX Transform Exception".equals(next) && !message.endsWith(next)) {
                if (!"".equals(message) && !message.trim().endsWith(":")) {
                    message = message + ": ";
                }
                message = message + next;
            }
            if (e2 instanceof TransformerException) {
                e2 = e2.getException();
                continue;
            }
            if (!(e2 instanceof SAXException)) break;
            e2 = ((SAXException)e2).getException();
        }
        return message;
    }

    private static String getInstructionName(InstructionInfoProvider inst, XPathContext context) {
        if (context == null) {
            return "";
        }
        NamePool pool = context.getNamePool();
        try {
            InstructionInfo info = inst.getInstructionInfo();
            int construct = info.getConstructType();
            if (construct < 1024 && construct != 149 && construct != 181) {
                if (context.getController().getExecutable().getHostLanguage() == 50) {
                    return StandardNames.getDisplayName(construct);
                }
                String s = StandardNames.getDisplayName(construct);
                int colon = s.indexOf(58);
                if (colon > 0) {
                    String local = s.substring(colon + 1);
                    if (local.equals("document")) {
                        return "document node constructor";
                    }
                    if (local.equals("text") || s.equals("value-of")) {
                        return "text node constructor";
                    }
                    if (local.equals("element")) {
                        return "computed element constructor";
                    }
                    if (local.equals("attribute")) {
                        return "computed attribute constructor";
                    }
                    if (local.equals("variable")) {
                        return "variable declaration";
                    }
                    if (local.equals("param")) {
                        return "external variable declaration";
                    }
                }
                return s;
            }
            switch (construct) {
                case 2006: {
                    StructuredQName qName = info.getObjectName(pool);
                    String name = "element constructor";
                    if (context != null) {
                        name = name + " <" + qName.getDisplayName() + '>';
                    }
                    return name;
                }
                case 2007: {
                    StructuredQName qName = info.getObjectName(pool);
                    String name = "attribute constructor";
                    if (context != null) {
                        name = name + ' ' + qName.getDisplayName() + "=\"{...}\"";
                    }
                    return name;
                }
                case 149: {
                    StructuredQName qName = info.getObjectName(pool);
                    String name = "function";
                    if (context != null) {
                        name = name + ' ' + qName.getDisplayName() + "()";
                    }
                    return name;
                }
                case 181: {
                    StructuredQName qName = info.getObjectName(pool);
                    String name = "template";
                    if (context != null && qName != null) {
                        name = name + " name=\"" + qName.getDisplayName() + '\"';
                    }
                    return name;
                }
            }
            return "";
        }
        catch (Exception err) {
            return "";
        }
    }

    private static String wordWrap(String message) {
        int nl = message.indexOf(10);
        if (nl < 0) {
            nl = message.length();
        }
        if (nl > 100) {
            int i;
            for (i = 90; message.charAt(i) != ' ' && i > 0; --i) {
            }
            if (i > 10) {
                return message.substring(0, i) + "\n  " + StandardErrorListener.wordWrap(message.substring(i + 1));
            }
            return message;
        }
        if (nl < message.length()) {
            return message.substring(0, nl) + '\n' + StandardErrorListener.wordWrap(message.substring(nl + 1));
        }
        return message;
    }
}

