/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class UserFunctionCall
extends FunctionCall
implements InstructionInfoProvider {
    private SequenceType staticType;
    private UserFunction function;
    private boolean tailCall = false;
    private boolean confirmed = false;
    private int[] argumentEvaluationModes = null;

    public void setStaticType(SequenceType type) {
        this.staticType = type;
    }

    public void setFunction(UserFunction compiledFunction) {
        this.function = compiledFunction;
        this.confirmed = true;
    }

    public void checkFunctionCall(UserFunction compiledFunction, ExpressionVisitor visitor) throws XPathException {
        int n = compiledFunction.getNumberOfArguments();
        for (int i = 0; i < n; ++i) {
            RoleLocator role = new RoleLocator(0, compiledFunction.getFunctionName(), i, visitor.getConfiguration().getNamePool());
            role.setSourceLocator(this);
            this.argument[i] = TypeChecker.staticTypeCheck(this.argument[i], compiledFunction.getArgumentType(i), false, role, visitor);
        }
    }

    public UserFunction getFunction() {
        return this.function;
    }

    public void setConfirmed(boolean conf) {
        this.confirmed = conf;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public boolean isTailCall() {
        return this.tailCall;
    }

    public boolean isRecursiveTailCall() {
        return this.tailCall && this.getContainer() == this.function;
    }

    public Expression[] getArguments() {
        return this.argument;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    public final StructuredQName getFunctionName() {
        StructuredQName n = super.getFunctionName();
        if (n == null) {
            return this.function.getFunctionName();
        }
        return n;
    }

    public int[] getArgumentEvaluationModes() {
        return this.argumentEvaluationModes;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int getIntrinsicDependencies() {
        return 256;
    }

    public Expression copy() {
        if (this.function == null) {
            throw new UnsupportedOperationException("copy");
        }
        UserFunctionCall ufc = new UserFunctionCall();
        ufc.setFunction(this.function);
        ufc.setStaticType(this.staticType);
        Expression[] a2 = new Expression[this.argument.length];
        for (int i = 0; i < this.argument.length; ++i) {
            a2[i] = this.argument[i].copy();
        }
        ufc.argument = a2;
        if (this.argumentEvaluationModes != null) {
            int[] am2 = new int[this.argumentEvaluationModes.length];
            System.arraycopy(this.argumentEvaluationModes, 0, am2, 0, am2.length);
            ufc.argumentEvaluationModes = am2;
        }
        return ufc;
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (this.function != null) {
            if (e2 == this) {
                this.computeArgumentEvaluationModes();
            }
            if (this.staticType == SequenceType.ANY_SEQUENCE) {
                this.staticType = this.function.getResultType(visitor.getConfiguration().getTypeHierarchy());
            }
        }
        return e2;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 == this && this.function != null) {
            this.computeArgumentEvaluationModes();
            Expression e22 = visitor.getConfiguration().getOptimizer().tryInlineFunctionCall(this, visitor, contextItemType);
            if (e22 != this) {
                return visitor.optimize(e22, contextItemType);
            }
            return e22;
        }
        return e2;
    }

    public void computeArgumentEvaluationModes() {
        this.argumentEvaluationModes = new int[this.argument.length];
        for (int i = 0; i < this.argument.length; ++i) {
            int refs = this.function.getParameterDefinitions()[i].getReferenceCount();
            if (refs == 0) {
                this.argumentEvaluationModes[i] = 5;
                continue;
            }
            if (this.function.getParameterDefinitions()[i].isIndexedVariable()) {
                this.argumentEvaluationModes[i] = 12;
                continue;
            }
            if ((this.argument[i].getDependencies() & 0x100) != 0) {
                this.argumentEvaluationModes[i] = ExpressionTool.eagerEvaluationMode(this.argument[i]);
                continue;
            }
            int m = ExpressionTool.lazyEvaluationMode(this.argument[i]);
            if (m == 3 && refs > 1) {
                m = 4;
            }
            this.argumentEvaluationModes[i] = m;
        }
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        this.tailCall = true;
        return this.getFunctionName().equals(qName) && arity == this.getNumberOfArguments() ? 2 : 1;
    }

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 6;
        }
        return 1;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        ValueRepresentation val = this.callFunction(c);
        return Value.asItem(val);
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        ValueRepresentation result = this.callFunction(c);
        return Value.getIterator(result);
    }

    private ValueRepresentation callFunction(XPathContext c) throws XPathException {
        ValueRepresentation[] actualArgs = this.evaluateArguments(c);
        if (this.tailCall) {
            ((XPathContextMajor)c).requestTailCall(this.function, actualArgs);
            return EmptySequence.getInstance();
        }
        XPathContextMajor c2 = c.newCleanContext();
        c2.setOrigin(this);
        try {
            return this.function.call(actualArgs, c2);
        }
        catch (StackOverflowError err) {
            throw new XPathException("Too many nested function calls. May be due to infinite recursion.", this);
        }
        catch (NullPointerException err) {
            if (this.function == null) {
                throw new NullPointerException("Unbound function call " + this.function.getFunctionName().getDisplayName());
            }
            throw err;
        }
    }

    public void process(XPathContext context) throws XPathException {
        ValueRepresentation[] actualArgs = this.evaluateArguments(context);
        if (this.tailCall) {
            ((XPathContextMajor)context).requestTailCall(this.function, actualArgs);
        } else {
            SequenceReceiver out = context.getReceiver();
            XPathContextMajor c2 = context.newCleanContext();
            c2.setReceiver(out);
            c2.setOrigin(this);
            this.function.process(actualArgs, c2);
        }
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        ValueRepresentation[] actualArgs = this.evaluateArguments(context);
        if (this.tailCall) {
            ((XPathContextMajor)context).requestTailCall(this.function, actualArgs);
            return EmptyEventIterator.getInstance();
        }
        SequenceReceiver out = context.getReceiver();
        XPathContextMajor c2 = context.newCleanContext();
        c2.setReceiver(out);
        c2.setOrigin(this);
        return this.function.iterateEvents(actualArgs, c2);
    }

    private ValueRepresentation[] evaluateArguments(XPathContext c) throws XPathException {
        int numArgs = this.argument.length;
        ValueRepresentation[] actualArgs = new ValueRepresentation[numArgs];
        if (this.argumentEvaluationModes == null) {
            this.computeArgumentEvaluationModes();
        }
        for (int i = 0; i < numArgs; ++i) {
            int refs = this.function.getParameterDefinitions()[i].getReferenceCount();
            actualArgs[i] = ExpressionTool.evaluate(this.argument[i], this.argumentEvaluationModes[i], c, refs);
            if (actualArgs[i] == null) {
                actualArgs[i] = EmptySequence.getInstance();
            }
            if (refs <= 1 || !(actualArgs[i] instanceof Closure) || actualArgs[i] instanceof MemoClosure) continue;
            actualArgs[i] = ((Closure)actualArgs[i]).reduce();
        }
        return actualArgs;
    }

    public ValueRepresentation dynamicCall(ValueRepresentation[] suppliedArguments, XPathContext context) throws XPathException {
        ValueRepresentation[] convertedArgs = new ValueRepresentation[suppliedArguments.length];
        XPathContextMajor c2 = context.newCleanContext();
        c2.setOrigin(this);
        c2.setCaller(context);
        c2.openStackFrame(suppliedArguments.length);
        for (int i = 0; i < suppliedArguments.length; ++i) {
            c2.setLocalVariable(i, suppliedArguments[i]);
            convertedArgs[i] = ExpressionTool.lazyEvaluate(this.argument[i], c2, 10);
        }
        XPathContextMajor c3 = c2.newCleanContext();
        c3.setOrigin(this);
        return this.function.call(convertedArgs, c3);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("functionCall");
        out.emitAttribute("name", this.getDisplayName());
        out.emitAttribute("tailCall", this.tailCall ? "true" : "false");
        for (int a = 0; a < this.argument.length; ++a) {
            this.argument[a].explain(out);
        }
        out.endElement();
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails details = new InstructionDetails();
        details.setConstructType(2009);
        details.setLineNumber(this.getLineNumber());
        details.setSystemId(this.getSystemId());
        details.setObjectName(this.getFunctionName());
        details.setProperty("expression", this);
        details.setProperty("target", this.function);
        return details;
    }
}

