/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.exslt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public abstract class Math {
    public static double max(SequenceIterator nsv) throws XPathException {
        double max2 = Double.NEGATIVE_INFINITY;
        try {
            Item it;
            while ((it = nsv.next()) != null) {
                double x = Value.stringToNumber(it.getStringValueCS());
                if (Double.isNaN(x)) {
                    return x;
                }
                if (!(x > max2)) continue;
                max2 = x;
            }
            return max2;
        }
        catch (NumberFormatException err) {
            return Double.NaN;
        }
    }

    public static double min(SequenceIterator nsv) throws XPathException {
        try {
            Item it;
            double min2 = Double.POSITIVE_INFINITY;
            while ((it = nsv.next()) != null) {
                double x = Value.stringToNumber(it.getStringValueCS());
                if (Double.isNaN(x)) {
                    return x;
                }
                if (!(x < min2)) continue;
                min2 = x;
            }
            return min2;
        }
        catch (NumberFormatException e2) {
            return Double.NaN;
        }
    }

    public static Value highest(SequenceIterator nsv) throws XPathException {
        try {
            Item it;
            double max2 = Double.NEGATIVE_INFINITY;
            ArrayList<Item> highest = new ArrayList<Item>();
            while ((it = nsv.next()) != null) {
                double x = Value.stringToNumber(it.getStringValueCS());
                if (Double.isNaN(x)) {
                    return EmptySequence.getInstance();
                }
                if (x == max2) {
                    highest.add(it);
                    continue;
                }
                if (!(x > max2)) continue;
                max2 = x;
                highest.clear();
                highest.add(it);
            }
            return new SequenceExtent(highest);
        }
        catch (NumberFormatException e2) {
            return EmptySequence.getInstance();
        }
    }

    public static Value lowest(SequenceIterator nsv) throws XPathException {
        try {
            Item it;
            double min2 = Double.POSITIVE_INFINITY;
            ArrayList<Item> lowest = new ArrayList<Item>();
            while ((it = nsv.next()) != null) {
                double x = Value.stringToNumber(it.getStringValueCS());
                if (Double.isNaN(x)) {
                    return EmptySequence.getInstance();
                }
                if (x == min2) {
                    lowest.add(it);
                    continue;
                }
                if (!(x < min2)) continue;
                min2 = x;
                lowest.clear();
                lowest.add(it);
            }
            return new SequenceExtent(lowest);
        }
        catch (NumberFormatException e2) {
            return EmptySequence.getInstance();
        }
    }

    public static double abs(double x) {
        return java.lang.Math.abs(x);
    }

    public static double sqrt(double x) {
        return java.lang.Math.sqrt(x);
    }

    public static NumericValue power(NumericValue n, NumericValue e2) throws XPathException {
        if (n instanceof DoubleValue || n instanceof FloatValue || e2 instanceof DoubleValue || e2 instanceof FloatValue || !e2.isWholeNumber()) {
            return new DoubleValue(java.lang.Math.pow(n.getDoubleValue(), e2.getDoubleValue()));
        }
        if (e2 instanceof IntegerValue && n instanceof IntegerValue && e2.signum() >= 0.0) {
            long le = e2.longValue();
            if (le > Integer.MAX_VALUE) {
                throw new XPathException("exponent out of range");
            }
            return IntegerValue.makeIntegerValue(((IntegerValue)n).asBigInteger().pow((int)le));
        }
        BigDecimal nd = n.getDecimalValue();
        long le = e2.longValue();
        if (le > Integer.MAX_VALUE || le < Integer.MIN_VALUE) {
            throw new XPathException("exponent out of range");
        }
        try {
            Class<?> bigDecimalClass = nd.getClass();
            Method pow2 = bigDecimalClass.getMethod("pow", Integer.class);
            Integer[] argValues = new Integer[]{new Integer((int)le)};
            BigDecimal result = (BigDecimal)pow2.invoke((Object)nd, (Object[])argValues);
            return new DecimalValue(result);
        }
        catch (NoSuchMethodException err) {
            throw new XPathException("power(decimal) not available in JDK 1.4");
        }
        catch (IllegalAccessException err) {
            throw new XPathException("power(decimal) not available in JDK 1.4");
        }
        catch (InvocationTargetException err) {
            throw new XPathException("power(decimal) not available in JDK 1.4");
        }
    }

    public static double constant(XPathContext context, String name, double precision) throws XPathException {
        String con = "";
        if (name.equals("PI")) {
            con = "3.1415926535897932384626433832795028841971693993751";
        } else if (name.equals("E")) {
            con = "2.71828182845904523536028747135266249775724709369996";
        } else if (name.equals("SQRRT2")) {
            con = "1.41421356237309504880168872420969807856967187537694";
        } else if (name.equals("LN2")) {
            con = "0.69314718055994530941723212145817656807550013436025";
        } else if (name.equals("LN10")) {
            con = "2.302585092994046";
        } else if (name.equals("LOG2E")) {
            con = "1.4426950408889633";
        } else if (name.equals("SQRT1_2")) {
            con = "0.7071067811865476";
        } else {
            XPathException e2 = new XPathException("Unknown math constant " + name);
            e2.setXPathContext(context);
            throw e2;
        }
        return Double.parseDouble(con.substring(0, (int)precision + 2));
    }

    public static double log(double x) {
        return java.lang.Math.log(x);
    }

    public static double random() {
        return java.lang.Math.random();
    }

    public static double sin(double x) {
        return java.lang.Math.sin(x);
    }

    public static double cos(double x) {
        return java.lang.Math.cos(x);
    }

    public static double tan(double x) {
        return java.lang.Math.tan(x);
    }

    public static double asin(double x) {
        return java.lang.Math.asin(x);
    }

    public static double acos(double x) {
        return java.lang.Math.acos(x);
    }

    public static double atan(double x) {
        return java.lang.Math.atan(x);
    }

    public static double atan2(double x, double y) {
        return java.lang.Math.atan2(x, y);
    }

    public static double exp(double x) {
        return java.lang.Math.exp(x);
    }
}

