/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.evpull.BlockEventIterator;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.BlockIterator;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;

public class Block
extends Instruction {
    private Expression[] children;

    public static Expression makeBlock(Expression e1, Expression e2) {
        if (e1 == null || Literal.isEmptySequence(e1)) {
            return e2;
        }
        if (e2 == null || Literal.isEmptySequence(e2)) {
            return e1;
        }
        if (e1 instanceof Block || e2 instanceof Block) {
            Iterator it1 = e1 instanceof Block ? e1.iterateSubExpressions() : new MonoIterator(e1);
            Iterator it2 = e2 instanceof Block ? e2.iterateSubExpressions() : new MonoIterator(e2);
            ArrayList list = new ArrayList(10);
            while (it1.hasNext()) {
                list.add(it1.next());
            }
            while (it2.hasNext()) {
                list.add(it2.next());
            }
            Expression[] exps = new Expression[list.size()];
            exps = list.toArray(exps);
            Block b = new Block();
            b.setChildren(exps);
            return b;
        }
        Expression[] exps = new Expression[]{e1, e2};
        Block b = new Block();
        b.setChildren(exps);
        return b;
    }

    public static Expression makeBlock(List list) {
        Expression[] exps = new Expression[list.size()];
        exps = list.toArray(exps);
        Block b = new Block();
        b.setChildren(exps);
        return b;
    }

    public void setChildren(Expression[] children) {
        if (children == null || children.length == 0) {
            this.children = null;
        } else {
            this.children = children;
            for (int c = 0; c < children.length; ++c) {
                this.adoptChildExpression(children[c]);
            }
        }
    }

    public Expression[] getChildren() {
        return this.children;
    }

    public Iterator iterateSubExpressions() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Arrays.asList(this.children).iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int c = 0; c < this.children.length; ++c) {
            if (this.children[c] != original) continue;
            this.children[c] = replacement;
            found = true;
        }
        return found;
    }

    public Expression copy() {
        Expression[] c2 = new Expression[this.children.length];
        for (int c = 0; c < this.children.length; ++c) {
            c2[c] = this.children[c].copy();
        }
        Block b2 = new Block();
        b2.children = c2;
        return b2;
    }

    public final ItemType getItemType(TypeHierarchy th) {
        if (this.children == null || this.children.length == 0) {
            return EmptySequenceTest.getInstance();
        }
        ItemType t1 = this.children[0].getItemType(th);
        for (int i = 1; i < this.children.length; ++i) {
            if (!((t1 = Type.getCommonSuperType(t1, this.children[i].getItemType(th), th)) instanceof AnyItemType)) continue;
            return t1;
        }
        return t1;
    }

    public final int getCardinality() {
        if (this.children == null || this.children.length == 0) {
            return 8192;
        }
        int c1 = this.children[0].getCardinality();
        for (int i = 1; i < this.children.length && (c1 = Cardinality.sum(c1, this.children[i].getCardinality())) != 57344; ++i) {
        }
        return c1;
    }

    public final boolean createsNewNodes() {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.length; ++i) {
            int props = this.children[i].getSpecialProperties();
            if ((props & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        boolean allAtomic = true;
        boolean nested = false;
        if (this.children != null) {
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = visitor.simplify(this.children[c]);
                if (!Literal.isAtomic(this.children[c])) {
                    allAtomic = false;
                }
                if (this.children[c] instanceof Block) {
                    nested = true;
                    continue;
                }
                if (!Literal.isEmptySequence(this.children[c])) continue;
                nested = true;
            }
            if (this.children.length == 1) {
                return this.getChildren()[0];
            }
            if (this.children.length == 0) {
                return Literal.makeEmptySequence();
            }
            if (nested) {
                ArrayList list = new ArrayList(this.children.length * 2);
                this.flatten(list);
                this.children = new Expression[list.size()];
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i] = (Expression)list.get(i);
                    this.adoptChildExpression(this.children[i]);
                }
            }
            if (allAtomic) {
                Item[] values = new AtomicValue[this.children.length];
                for (int c = 0; c < this.children.length; ++c) {
                    values[c] = (AtomicValue)((Literal)this.children[c]).getValue();
                }
                return Literal.makeLiteral(new SequenceExtent(values));
            }
        } else {
            return Literal.makeEmptySequence();
        }
        return this;
    }

    private void flatten(List list) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] instanceof Block) {
                ((Block)this.children[i]).flatten(list);
                continue;
            }
            if (Literal.isEmptySequence(this.children[i])) continue;
            list.add(this.children[i]);
        }
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        boolean nested = false;
        if (this.children != null) {
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = visitor.typeCheck(this.children[c], contextItemType);
                this.adoptChildExpression(this.children[c]);
                if (this.children[c] instanceof Block) {
                    nested = true;
                    continue;
                }
                if (!Literal.isEmptySequence(this.children[c])) continue;
                nested = true;
            }
        }
        if (nested) {
            ArrayList list = new ArrayList(this.children.length * 2);
            this.flatten(list);
            this.children = new Expression[list.size()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = (Expression)list.get(i);
                this.adoptChildExpression(this.children[i]);
            }
        }
        if (this.children == null || this.children.length == 0) {
            return Literal.makeEmptySequence();
        }
        if (this.children.length == 1) {
            return this.children[0];
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        boolean allAtomic = true;
        if (this.children != null) {
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = visitor.optimize(this.children[c], contextItemType);
                this.adoptChildExpression(this.children[c]);
                if (Literal.isAtomic(this.children[c])) continue;
                allAtomic = false;
            }
            if (allAtomic) {
                Item[] items = new Item[this.children.length];
                for (int c = 0; c < this.children.length; ++c) {
                    items[c] = (AtomicValue)((Literal)this.children[c]).getValue();
                }
                return new Literal(new SequenceExtent(items));
            }
        }
        return this;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.children != null) {
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = this.doPromotion(this.children[c], offer);
                if (offer.accepted) break;
            }
        }
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (this.children != null) {
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c].checkPermittedContents(parentType, env, false);
            }
        }
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("sequence");
        if (this.children != null) {
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c].explain(out);
            }
        }
        out.endElement();
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.children == null) {
            return null;
        }
        TailCall tc = null;
        for (int i = 0; i < this.children.length; ++i) {
            try {
                if (this.children[i] instanceof TailCallReturner) {
                    tc = ((TailCallReturner)((Object)this.children[i])).processLeavingTail(context);
                    continue;
                }
                this.children[i].process(context);
                tc = null;
                continue;
            }
            catch (XPathException e2) {
                e2.maybeSetLocation(this.children[i]);
                e2.maybeSetContext(context);
                throw e2;
            }
        }
        return tc;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        if (this.children == null || this.children.length == 0) {
            return EmptyIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterate(context);
        }
        return new BlockIterator(this.children, context);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (this.children == null || this.children.length == 0) {
            return EmptyEventIterator.getInstance();
        }
        if (this.children.length == 1) {
            return this.children[0].iterateEvents(context);
        }
        return new BlockEventIterator(this.children, context);
    }
}

