/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class Doctype
extends Instruction {
    private Expression content;

    public Doctype(Expression content) {
        this.content = content;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.content = visitor.simplify(this.content);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.content = visitor.typeCheck(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.content = visitor.optimize(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.content);
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        return found;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.content = this.doPromotion(this.content, offer);
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public int getInstructionNameCode() {
        return 260;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        TinyBuilder builder;
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceReceiver out = c2.getReceiver();
        TinyBuilder receiver = builder = new TinyBuilder();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getContainer().getHostLanguage());
        receiver.setPipelineConfiguration(pipe);
        receiver.open();
        receiver.startDocument(0);
        c2.changeOutputDestination(null, receiver, false, this.getHostLanguage(), 3, null);
        this.content.process(c2);
        receiver.endDocument();
        receiver.close();
        DocumentInfo dtdRoot = (DocumentInfo)builder.getCurrentRoot();
        AxisIterator children = dtdRoot.iterateAxis((byte)3);
        NodeInfo docType = (NodeInfo)children.next();
        if (docType == null || !"doctype".equals(docType.getLocalPart())) {
            XPathException e2 = new XPathException("saxon:doctype instruction must contain dtd:doctype");
            e2.setXPathContext(context);
            throw e2;
        }
        String name = Navigator.getAttributeValue(docType, "", "name");
        String system = Navigator.getAttributeValue(docType, "", "system");
        String publicid = Navigator.getAttributeValue(docType, "", "public");
        if (name == null) {
            XPathException e3 = new XPathException("dtd:doctype must have a name attribute");
            e3.setXPathContext(context);
            throw e3;
        }
        this.write(out, "<!DOCTYPE " + name + ' ');
        if (system != null) {
            if (publicid != null) {
                this.write(out, "PUBLIC \"" + publicid + "\" \"" + system + '\"');
            } else {
                this.write(out, "SYSTEM \"" + system + '\"');
            }
        }
        boolean openSquare = false;
        children = docType.iterateAxis((byte)3);
        NodeInfo child = (NodeInfo)children.next();
        if (child != null) {
            this.write(out, " [");
            openSquare = true;
        }
        while (child != null) {
            XPathException e4;
            String elname;
            String localname2 = child.getLocalPart();
            if ("element".equals(localname2)) {
                XPathException e5;
                elname = Navigator.getAttributeValue(child, "", "name");
                String content = Navigator.getAttributeValue(child, "", "content");
                if (elname == null) {
                    e5 = new XPathException("dtd:element must have a name attribute");
                    e5.setXPathContext(context);
                    throw e5;
                }
                if (content == null) {
                    e5 = new XPathException("dtd:element must have a content attribute");
                    e5.setXPathContext(context);
                    throw e5;
                }
                this.write(out, "\n  <!ELEMENT " + elname + ' ' + content + '>');
            } else if (localname2.equals("attlist")) {
                NodeInfo attDef;
                elname = Navigator.getAttributeValue(child, "", "element");
                if (elname == null) {
                    XPathException e6 = new XPathException("dtd:attlist must have an attribute named 'element'");
                    e6.setXPathContext(context);
                    throw e6;
                }
                this.write(out, "\n  <!ATTLIST " + elname + ' ');
                AxisIterator attributes = child.iterateAxis((byte)3);
                while ((attDef = (NodeInfo)attributes.next()) != null) {
                    if ("attribute".equals(attDef.getLocalPart())) {
                        XPathException e7;
                        String atname = Navigator.getAttributeValue(attDef, "", "name");
                        String type = Navigator.getAttributeValue(attDef, "", "type");
                        String value = Navigator.getAttributeValue(attDef, "", "value");
                        if (atname == null) {
                            e7 = new XPathException("dtd:attribute must have a name attribute");
                            e7.setXPathContext(context);
                            throw e7;
                        }
                        if (type == null) {
                            e7 = new XPathException("dtd:attribute must have a type attribute");
                            e7.setXPathContext(context);
                            throw e7;
                        }
                        if (value == null) {
                            e7 = new XPathException("dtd:attribute must have a value attribute");
                            e7.setXPathContext(context);
                            throw e7;
                        }
                        this.write(out, "\n    " + atname + ' ' + type + ' ' + value);
                        continue;
                    }
                    e4 = new XPathException("Unrecognized element within dtd:attlist");
                    e4.setXPathContext(context);
                    throw e4;
                }
                this.write(out, ">");
            } else if (localname2.equals("entity")) {
                NodeInfo content;
                String entname = Navigator.getAttributeValue(child, "", "name");
                String parameter = Navigator.getAttributeValue(child, "", "parameter");
                String esystem = Navigator.getAttributeValue(child, "", "system");
                String epublicid = Navigator.getAttributeValue(child, "", "public");
                String notation = Navigator.getAttributeValue(child, "", "notation");
                if (entname == null) {
                    XPathException e8 = new XPathException("dtd:entity must have a name attribute");
                    e8.setXPathContext(context);
                    throw e8;
                }
                this.write(out, "\n  <!ENTITY ");
                if ("yes".equals(parameter)) {
                    this.write(out, "% ");
                }
                this.write(out, entname + ' ');
                if (esystem != null) {
                    if (epublicid != null) {
                        this.write(out, "PUBLIC \"" + epublicid + "\" \"" + esystem + "\" ");
                    } else {
                        this.write(out, "SYSTEM \"" + esystem + "\" ");
                    }
                }
                if (notation != null) {
                    this.write(out, "NDATA " + notation + ' ');
                }
                AxisIterator contents = child.iterateAxis((byte)3);
                while ((content = (NodeInfo)contents.next()) != null) {
                    content.copy(out, 0, false, this.locationId);
                }
                this.write(out, ">");
            } else if (localname2.equals("notation")) {
                String notname = Navigator.getAttributeValue(child, "", "name");
                String nsystem = Navigator.getAttributeValue(child, "", "system");
                String npublicid = Navigator.getAttributeValue(child, "", "public");
                if (notname == null) {
                    e4 = new XPathException("dtd:notation must have a name attribute");
                    e4.setXPathContext(context);
                    throw e4;
                }
                if (nsystem == null && npublicid == null) {
                    e4 = new XPathException("dtd:notation must have a system attribute or a public attribute");
                    e4.setXPathContext(context);
                    throw e4;
                }
                this.write(out, "\n  <!NOTATION " + notname);
                if (npublicid != null) {
                    this.write(out, " PUBLIC \"" + npublicid + "\" ");
                    if (nsystem != null) {
                        this.write(out, '\"' + nsystem + "\" ");
                    }
                } else {
                    this.write(out, " SYSTEM \"" + nsystem + "\" ");
                }
                this.write(out, ">");
            } else {
                XPathException e9 = new XPathException("Unrecognized element " + localname2 + " in DTD output");
                e9.setXPathContext(context);
                throw e9;
            }
            child = (NodeInfo)children.next();
        }
        if (openSquare) {
            this.write(out, "\n]");
        }
        this.write(out, ">\n");
        return null;
    }

    private void write(Receiver out, String s) throws XPathException {
        out.characters(s, this.locationId, 1);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("saxonDoctype");
        out.endElement();
    }
}

