/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.BracketedElementIterator;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventAnnotationStripper;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pull.UnconstructedElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Cardinality;

public abstract class ElementCreator
extends ParentNodeConstructor {
    protected boolean inheritNamespaces = true;
    protected boolean preservingTypes = true;

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.ELEMENT;
    }

    public boolean isPreservingTypes() {
        return this.preservingTypes;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public void setValidationMode(int mode) {
        super.setValidationMode(mode);
        if (mode != 3) {
            this.preservingTypes = false;
        }
    }

    public void suppressValidation(int validationMode) {
        if (this.validation == validationMode) {
            this.setValidationMode(3);
        }
    }

    protected void checkContentSequence(StaticContext env) throws XPathException {
        if (this.content instanceof Block) {
            TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
            Expression[] components = ((Block)this.content).getChildren();
            boolean foundChild = false;
            boolean foundPossibleChild = false;
            int childNodeKinds = 394;
            for (int i = 0; i < components.length; ++i) {
                XPathException de;
                ItemType it = components[i].getItemType(th);
                if (!(it instanceof NodeTest)) continue;
                boolean maybeEmpty = Cardinality.allowsZero(components[i].getCardinality());
                int possibleNodeKinds = ((NodeTest)it).getNodeKindMask();
                if ((possibleNodeKinds & 8) != 0) {
                    if (components[i] instanceof ValueOf && ((ValueOf)components[i]).select instanceof StringLiteral) {
                        String value = ((StringLiteral)((ValueOf)components[i]).select).getStringValue();
                        if (value.length() == 0) continue;
                        foundChild = true;
                        continue;
                    }
                    foundPossibleChild = true;
                    continue;
                }
                if ((possibleNodeKinds & ~childNodeKinds) == 0) {
                    if (maybeEmpty) {
                        foundPossibleChild = true;
                        continue;
                    }
                    foundChild = true;
                    continue;
                }
                if (foundChild && possibleNodeKinds == 4 && !maybeEmpty) {
                    de = new XPathException("Cannot create an attribute node after creating a child of the containing element");
                    de.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                    de.setLocator(components[i]);
                    throw de;
                }
                if (foundChild && possibleNodeKinds == 8192 && !maybeEmpty) {
                    de = new XPathException("Cannot create a namespace node after creating a child of the containing element");
                    de.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                    de.setLocator(components[i]);
                    throw de;
                }
                if ((foundChild || foundPossibleChild) && possibleNodeKinds == 4) {
                    env.issueWarning("Creating an attribute here will fail if previous instructions create any children", components[i]);
                    continue;
                }
                if (!foundChild && !foundPossibleChild || possibleNodeKinds != 8192) continue;
                env.issueWarning("Creating a namespace node here will fail if previous instructions create any children", components[i]);
            }
        }
    }

    public abstract int getNameCode(XPathContext var1) throws XPathException;

    public abstract String getNewBaseURI(XPathContext var1);

    protected abstract void outputNamespaceNodes(XPathContext var1, Receiver var2) throws XPathException;

    public int[] getActiveNamespaces() throws XPathException {
        return null;
    }

    public int getImplementationMethod() {
        return 5;
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (!this.preservingTypes && this.validation != 4) {
            return new SingletonEventIterator(this.evaluateItem(context));
        }
        StartElementEvent start = new StartElementEvent(context.getController().getConfiguration());
        start.setNameCode(this.getNameCode(context));
        start.setTypeCode(this.validation == 3 ? 572 : 630);
        start.setLocalNamespaces(this.getActiveNamespaces());
        BracketedElementIterator result = new BracketedElementIterator(start, this.content.iterateEvents(context), EndElementEvent.getInstance());
        if (this.validation == 4 && !context.getConfiguration().areAllNodesUntyped()) {
            return new EventAnnotationStripper(result);
        }
        return result;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        try {
            SequenceReceiver out;
            int nameCode = this.getNameCode(context);
            int typeCode = this.validation == 3 ? 572 : 630;
            XPathContext c2 = context;
            SequenceReceiver elemOut = out = context.getReceiver();
            if (!this.preservingTypes) {
                Controller controller = context.getController();
                SequenceReceiver validator = controller.getConfiguration().getElementValidator(out, nameCode, this.locationId, this.getSchemaType(), this.validation);
                if (validator != out) {
                    c2 = context.newMinorContext();
                    c2.setOrigin(this);
                    out = new TreeReceiver(validator);
                    c2.setReceiver(out);
                }
                elemOut = out;
            }
            if (elemOut.getSystemId() == null) {
                elemOut.setSystemId(this.getNewBaseURI(c2));
            }
            int properties = this.inheritNamespaces ? 0 : 128;
            elemOut.startElement(nameCode, typeCode, this.locationId, properties);
            this.outputNamespaceNodes(c2, elemOut);
            this.content.process(c2);
            elemOut.endElement();
            return null;
        }
        catch (XPathException e2) {
            e2.maybeSetLocation(this);
            e2.maybeSetContext(context);
            throw e2;
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        if (this.isLazyConstruction() && this.preservingTypes) {
            UnconstructedElement e2 = new UnconstructedElement(this, context);
            e2.setNameCode(this.getNameCode(context));
            return e2;
        }
        return this.constructElement(context);
    }

    private NodeInfo constructElement(XPathContext context) throws XPathException {
        try {
            Controller controller = context.getController();
            XPathContextMinor c2 = context.newMinorContext();
            c2.setOrigin(this);
            SequenceOutputter seq2 = controller.allocateSequenceOutputter(1);
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setHostLanguage(this.getHostLanguage());
            seq2.setPipelineConfiguration(pipe);
            int nameCode = this.getNameCode(c2);
            int typeCode = this.validation == 3 ? 572 : 630;
            SequenceReceiver ini = seq2;
            if (!this.preservingTypes) {
                SequenceReceiver validator = controller.getConfiguration().getElementValidator(ini, nameCode, this.locationId, this.getSchemaType(), this.validation);
                if (ini.getSystemId() == null) {
                    ini.setSystemId(this.getNewBaseURI(c2));
                }
                if (validator == ini) {
                    c2.setTemporaryReceiver(ini);
                } else {
                    TreeReceiver tr = new TreeReceiver(validator);
                    tr.setPipelineConfiguration(seq2.getPipelineConfiguration());
                    c2.setReceiver(tr);
                    ini = tr;
                }
            } else {
                c2.setTemporaryReceiver(ini);
                if (ini.getSystemId() == null) {
                    ini.setSystemId(this.getNewBaseURI(c2));
                }
            }
            ini.open();
            int properties = this.inheritNamespaces ? 0 : 128;
            ini.startElement(nameCode, typeCode, this.locationId, properties);
            this.outputNamespaceNodes(c2, ini);
            this.content.process(c2);
            ini.endElement();
            ini.close();
            NodeInfo result = (NodeInfo)seq2.popLastItem();
            seq2.reset();
            return result;
        }
        catch (XPathException err) {
            if (err instanceof ValidationException) {
                ((ValidationException)err).setSourceLocator(this);
                ((ValidationException)err).setSystemId(this.getSystemId());
            }
            err.maybeSetLocation(this);
            err.maybeSetContext(context);
            throw err;
        }
    }
}

