/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.Validation;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;

public final class FixedAttribute
extends SimpleNodeConstructor {
    private int nameCode;
    private SimpleType schemaType;
    private int annotation;
    private int options;
    private int validationAction;

    public FixedAttribute(int nameCode, int validationAction, SimpleType schemaType, int annotation) {
        this.nameCode = nameCode;
        this.schemaType = schemaType;
        this.annotation = annotation == -1 ? 631 : annotation;
        this.validationAction = validationAction;
        this.options = 0;
    }

    public int getInstructionNameCode() {
        return 131;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public void setNoSpecialChars() {
        this.options |= 4;
    }

    public void setSelect(Expression select, Configuration config) throws XPathException {
        CharSequence value;
        ValidationFailure err;
        super.setSelect(select, config);
        if (Literal.isAtomic(select) && this.schemaType != null && !this.schemaType.isNamespaceSensitive() && (err = this.schemaType.validateContent(value = ((Literal)select).getValue().getStringValueCS(), DummyNamespaceResolver.getInstance(), config.getNameChecker())) != null) {
            XPathException se = new XPathException("Attribute value " + Err.wrap(value, 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + err.getMessage());
            se.setErrorCode("XTTE1540");
            throw se;
        }
        if (select instanceof StringLiteral) {
            boolean special = false;
            String val = ((StringLiteral)select).getStringValue();
            for (int k = 0; k < val.length(); ++k) {
                char c = val.charAt(k);
                if (c >= '!' && c <= '~' && c != '<' && c != '>' && c != '&' && c != '\"') continue;
                special = true;
                break;
            }
            if (!special) {
                this.options |= 4;
            }
        }
        if ((this.nameCode & 0xFFFFF) == 388) {
            select = SystemFunction.makeSystemFunction("normalize-space", new Expression[]{select});
            super.setSelect(select, config);
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails details = (InstructionDetails)super.getInstructionInfo();
        details.setConstructType(2007);
        details.setObjectNameCode(this.nameCode);
        return details;
    }

    public int getAttributeNameCode() {
        return this.nameCode;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 16384;
    }

    public int getValidationAction() {
        return this.validationAction;
    }

    public Expression copy() {
        FixedAttribute exp = new FixedAttribute(this.nameCode, this.validationAction, this.schemaType, this.annotation);
        try {
            exp.setSelect(this.select.copy(), this.getExecutable().getConfiguration());
        }
        catch (XPathException err) {
            throw new UnsupportedOperationException(err.getMessage());
        }
        return exp;
    }

    public void localTypeCheck(ExpressionVisitor visitor, ItemType contextItemType) {
    }

    public int evaluateNameCode(XPathContext context) {
        return this.nameCode;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        SchemaType type;
        int fp = this.nameCode & 0xFFFFF;
        if (fp == 641 || fp == 643 || fp == 642 || fp == 644) {
            return;
        }
        if (parentType instanceof SimpleType) {
            XPathException err = new XPathException("Attribute " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the simple type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            if (this.getHostLanguage() == 50) {
                err.setErrorCode("XTTE1510");
            } else {
                err.setErrorCode("XQDY0027");
            }
            throw err;
        }
        try {
            type = ((ComplexType)parentType).getAttributeUseType(fp);
        }
        catch (SchemaException e2) {
            throw new XPathException(e2);
        }
        if (type == null) {
            XPathException err = new XPathException("Attribute " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the complex type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            if (this.getHostLanguage() == 50) {
                err.setErrorCode("XTTE1510");
            } else {
                err.setErrorCode("XQDY0027");
            }
            throw err;
        }
        if (type instanceof AnyType) {
            return;
        }
        try {
            this.select.checkPermittedContents(type, env, true);
        }
        catch (XPathException e3) {
            if (e3.getLocator() == null || e3.getLocator() == e3) {
                e3.setLocator(this);
            }
            throw e3;
        }
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        SequenceReceiver out = context.getReceiver();
        int opt = this.options;
        int ann = this.annotation;
        CharSequence value = this.expandChildren(context);
        if (this.schemaType != null) {
            ValidationFailure err = this.schemaType.validateContent(value, DummyNamespaceResolver.getInstance(), context.getConfiguration().getNameChecker());
            if (err != null) {
                ValidationException verr = new ValidationException("Attribute value " + Err.wrap(value, 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + err.getMessage());
                verr.setErrorCode("XTTE1540");
                verr.setLocator(this);
                throw verr;
            }
        } else if (this.validationAction == 1 || this.validationAction == 2) {
            try {
                ann = controller.getConfiguration().validateAttribute(this.nameCode, value, this.validationAction);
            }
            catch (ValidationException e2) {
                XPathException err = XPathException.makeXPathException(e2);
                String errorCode = e2.getErrorCodeLocalPart();
                if (errorCode == null) {
                    errorCode = this.validationAction == 1 ? "XTTE1510" : "XTTE1515";
                }
                err.setErrorCode(errorCode);
                err.setXPathContext(context);
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        }
        try {
            out.attribute(this.nameCode, ann, value, this.locationId, opt);
        }
        catch (XPathException err) {
            throw FixedAttribute.dynamicError(this, err, context);
        }
        return null;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Orphan o = (Orphan)super.evaluateItem(context);
        if (this.schemaType != null) {
            ValidationFailure err = this.schemaType.validateContent(o.getStringValueCS(), DummyNamespaceResolver.getInstance(), context.getConfiguration().getNameChecker());
            if (err != null) {
                throw new ValidationException("Attribute value " + Err.wrap(o.getStringValueCS(), 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + err.getMessage());
            }
            o.setTypeAnnotation(this.schemaType.getFingerprint());
            if (this.schemaType.isNamespaceSensitive()) {
                throw new XPathException("Cannot validate a parentless attribute whose content is namespace-sensitive");
            }
        } else if (this.validationAction == 1 || this.validationAction == 2) {
            try {
                int ann = context.getController().getConfiguration().validateAttribute(this.nameCode, o.getStringValueCS(), this.validationAction);
                o.setTypeAnnotation(ann);
            }
            catch (ValidationException e2) {
                XPathException err = XPathException.makeXPathException(e2);
                err.setErrorCode(e2.getErrorCodeLocalPart());
                err.setXPathContext(context);
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        }
        return o;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("directAttribute");
        out.emitAttribute("name", out.getNamePool().getDisplayName(this.nameCode));
        out.emitAttribute("validation", Validation.toString(this.validationAction));
        if (this.schemaType != null) {
            out.emitAttribute("type", this.schemaType.getDescription());
        }
        this.getSelect().explain(out);
        out.endElement();
    }
}

