/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class UnionPattern
extends Pattern {
    protected Pattern p1;
    protected Pattern p2;
    private int nodeType = 0;

    public UnionPattern(Pattern p1, Pattern p2) {
        this.p1 = p1;
        this.p2 = p2;
        if (p1.getNodeKind() == p2.getNodeKind()) {
            this.nodeType = p1.getNodeKind();
        }
    }

    public void setExecutable(Executable executable) {
        this.p1.setExecutable(executable);
        this.p2.setExecutable(executable);
        super.setExecutable(executable);
    }

    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        this.p1 = this.p1.simplify(visitor);
        this.p2 = this.p2.simplify(visitor);
        return this;
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.p1 = this.p1.analyze(visitor, contextItemType);
        this.p2 = this.p2.analyze(visitor, contextItemType);
        return this;
    }

    public void setOriginalText(String pattern) {
        super.setOriginalText(pattern);
        this.p1.setOriginalText(pattern);
        this.p2.setOriginalText(pattern);
    }

    public int allocateSlots(ExpressionContext env, int nextFree) {
        nextFree = this.p1.allocateSlots(env, nextFree);
        nextFree = this.p2.allocateSlots(env, nextFree);
        return nextFree;
    }

    public boolean matches(NodeInfo e2, XPathContext context) throws XPathException {
        return this.p1.matches(e2, context) || this.p2.matches(e2, context);
    }

    public int getNodeKind() {
        return this.nodeType;
    }

    public NodeTest getNodeTest() {
        if (this.nodeType == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(this.nodeType);
    }

    public int getDependencies() {
        return this.p1.getDependencies() | this.p2.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        return new MultiIterator(new Iterator[]{this.p1.iterateSubExpressions(), this.p2.iterateSubExpressions()});
    }

    public Pattern getLHS() {
        return this.p1;
    }

    public Pattern getRHS() {
        return this.p2;
    }

    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.p1.setSystemId(systemId);
        this.p2.setSystemId(systemId);
    }

    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        this.p1.setLineNumber(lineNumber);
        this.p2.setLineNumber(lineNumber);
    }
}

