/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceDeclarationsImpl;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;

public class PullNamespaceReducer
extends PullFilter
implements NamespaceResolver {
    private int[] namestack = new int[50];
    int elementJustEnded = -1;
    private int[] allNamespaces = new int[50];
    private int allNamespacesSize = 0;
    private int[] namespaceCountStack = new int[50];
    private int depth = 0;
    private int[] localNamespaces;
    private int localNamespacesSize = 0;
    private int nameCode;
    private NamespaceDeclarations declaredNamespaces;
    private AttributeCollection attributeCollection;
    private int[] pendingUndeclarations = null;
    private int[] nsBuffer = new int[20];

    public PullNamespaceReducer(PullProvider base) {
        super(base);
    }

    public int next() throws XPathException {
        this.currentEvent = super.next();
        switch (this.currentEvent) {
            case 4: {
                this.startElement();
                break;
            }
            case 5: {
                this.endElement();
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                this.nameCode = super.getNameCode();
                break;
            }
            default: {
                this.nameCode = -1;
            }
        }
        return this.currentEvent;
    }

    private void startElement() throws XPathException {
        this.namespaceCountStack[this.depth] = 0;
        if (++this.depth >= this.namespaceCountStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.namespaceCountStack, 0, newstack, 0, this.depth);
            this.namespaceCountStack = newstack;
            int[] name2 = new int[this.depth * 2];
            System.arraycopy(this.namestack, 0, name2, 0, this.depth);
            this.namestack = name2;
        }
        NamespaceDeclarations declarations = super.getNamespaceDeclarations();
        this.localNamespaces = declarations.getNamespaceCodes(this.nsBuffer);
        this.localNamespacesSize = 0;
        for (int i = 0; i < this.localNamespaces.length && this.localNamespaces[i] != -1; ++i) {
            if (!this.isNeeded(this.localNamespaces[i])) continue;
            this.addGlobalNamespace(this.localNamespaces[i]);
            int n = this.depth - 1;
            this.namespaceCountStack[n] = this.namespaceCountStack[n] + 1;
            this.localNamespaces[this.localNamespacesSize++] = this.localNamespaces[i];
        }
        this.namestack[this.depth - 1] = this.nameCode = this.checkProposedPrefix(super.getNameCode(), 0);
        this.attributeCollection = super.getAttributes();
        boolean modified = false;
        for (int i = 0; i < this.attributeCollection.getLength(); ++i) {
            int newnc;
            int nc = this.attributeCollection.getNameCode(i);
            if ((nc & 0xFFF00000) == 0 || nc == (newnc = this.checkProposedPrefix(nc, i + 1))) continue;
            if (!modified) {
                this.attributeCollection = this.copyAttributeCollection(this.attributeCollection);
                modified = true;
            }
            ((AttributeCollectionImpl)this.attributeCollection).setAttribute(i, newnc, this.attributeCollection.getTypeAnnotation(i), this.attributeCollection.getValue(i), this.attributeCollection.getLocationId(i), this.attributeCollection.getProperties(i));
        }
        if (this.localNamespacesSize < this.localNamespaces.length) {
            this.localNamespaces[this.localNamespacesSize] = -1;
        }
        this.declaredNamespaces = new NamespaceDeclarationsImpl(this.getNamePool(), this.localNamespaces);
        this.namespaceCountStack[this.depth - 1] = this.localNamespacesSize;
    }

    private void addLocalNamespace(int nc) {
        if (this.localNamespacesSize < this.localNamespaces.length) {
            this.localNamespaces[this.localNamespacesSize++] = nc;
        } else if (this.localNamespacesSize == 0) {
            this.localNamespaces = new int[10];
        } else {
            int[] nc2 = new int[this.localNamespacesSize * 2];
            System.arraycopy(this.localNamespaces, 0, nc2, 0, this.localNamespacesSize);
            this.localNamespaces = nc2;
            this.localNamespaces[this.localNamespacesSize++] = nc;
        }
        this.addGlobalNamespace(nc);
    }

    private boolean isNeeded(int nscode) {
        if (nscode == 65537) {
            return false;
        }
        if (this.pendingUndeclarations != null) {
            for (int p = 0; p < this.pendingUndeclarations.length; ++p) {
                if (nscode >> 16 != this.pendingUndeclarations[p] >> 16) continue;
                this.pendingUndeclarations[p] = -1;
            }
        }
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (this.allNamespaces[i] == nscode) {
                return false;
            }
            if (this.allNamespaces[i] >> 16 != nscode >> 16) continue;
            return true;
        }
        return nscode != 0;
    }

    private int checkProposedPrefix(int nameCode, int seq2) {
        NamePool namePool = this.getNamePool();
        int nscode = namePool.getNamespaceCode(nameCode);
        if (nscode == -1) {
            nscode = namePool.allocateNamespaceCode(nameCode);
        }
        int nsprefix = nscode >> 16;
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (nsprefix != this.allNamespaces[i] >> 16) continue;
            if ((nscode & 0xFFFF) == (this.allNamespaces[i] & 0xFFFF)) {
                return nameCode;
            }
            if (i + this.localNamespacesSize >= this.allNamespacesSize) {
                String prefix = this.getSubstitutePrefix(nscode, seq2);
                int newNameCode = namePool.allocate(prefix, namePool.getURI(nameCode), namePool.getLocalName(nameCode));
                int newNSCode = namePool.allocateNamespaceCode(newNameCode);
                this.addLocalNamespace(newNSCode);
                return newNameCode;
            }
            this.addLocalNamespace(nscode);
            return nameCode;
        }
        if (nscode != 0) {
            this.addLocalNamespace(nscode);
        }
        return nameCode;
    }

    private String getSubstitutePrefix(int nscode, int seq2) {
        String prefix = this.getNamePool().getPrefixFromNamespaceCode(nscode);
        return prefix + '_' + seq2;
    }

    private void addGlobalNamespace(int nscode) {
        if (this.allNamespacesSize + 1 >= this.allNamespaces.length) {
            int[] newlist = new int[this.allNamespacesSize * 2];
            System.arraycopy(this.allNamespaces, 0, newlist, 0, this.allNamespacesSize);
            this.allNamespaces = newlist;
        }
        this.allNamespaces[this.allNamespacesSize++] = nscode;
    }

    public int getNameCode() {
        if (this.currentEvent == 5) {
            return this.elementJustEnded;
        }
        return this.nameCode;
    }

    public AttributeCollection getAttributes() throws XPathException {
        return this.attributeCollection;
    }

    private AttributeCollectionImpl copyAttributeCollection(AttributeCollection in) {
        AttributeCollectionImpl out = new AttributeCollectionImpl(this.getNamePool());
        for (int i = 0; i < in.getLength(); ++i) {
            out.addAttribute(in.getNameCode(i), in.getTypeAnnotation(i), in.getValue(i), in.getLocationId(i), in.getProperties(i));
        }
        return out;
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        if (this.currentEvent == 5) {
            int nscount = this.namespaceCountStack[this.depth];
            int[] namespaces = new int[nscount];
            System.arraycopy(this.allNamespaces, this.allNamespacesSize, namespaces, 0, nscount);
            return new NamespaceDeclarationsImpl(this.getNamePool(), namespaces);
        }
        return this.declaredNamespaces;
    }

    public void endElement() throws XPathException {
        if (this.depth-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        this.elementJustEnded = this.namestack[this.depth];
        this.allNamespacesSize -= this.namespaceCountStack[this.depth];
    }

    protected short getURICode(short prefixCode) {
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (this.allNamespaces[i] >> 16 != prefixCode) continue;
            return (short)(this.allNamespaces[i] & 0xFFFF);
        }
        if (prefixCode == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        NamePool pool = this.getNamePool();
        if (!(prefix != null && prefix.length() != 0 || useDefault)) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short prefixCode = pool.getCodeForPrefix(prefix);
        short uriCode = this.getURICode(prefixCode);
        if (uriCode == -1) {
            return null;
        }
        return pool.getURIFromURICode(uriCode);
    }

    public Iterator iteratePrefixes() {
        NamePool pool = this.getNamePool();
        ArrayList<String> prefixes = new ArrayList<String>(this.allNamespacesSize);
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            String prefix = pool.getPrefixFromNamespaceCode(this.allNamespaces[i]);
            if (prefixes.contains(prefix)) continue;
            prefixes.add(prefix);
        }
        prefixes.add("xml");
        return prefixes.iterator();
    }
}

