/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.StandardCollationURIResolver;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.SubstringMatcher;

public class RuleBasedSubstringMatcher
implements SubstringMatcher {
    private RuleBasedCollator collator;

    public RuleBasedSubstringMatcher(RuleBasedCollator collator) {
        this.collator = collator;
    }

    public boolean comparesEqual(String s1, String s2) {
        return this.collator.compare(s1, s2) == 0;
    }

    public boolean contains(String s1, String s2) {
        CollationElementIterator iter1 = this.collator.getCollationElementIterator(s1);
        CollationElementIterator iter2 = this.collator.getCollationElementIterator(s2);
        return this.collationContains(iter1, iter2, null, false);
    }

    public boolean endsWith(String s1, String s2) {
        CollationElementIterator iter1 = this.collator.getCollationElementIterator(s1);
        CollationElementIterator iter2 = this.collator.getCollationElementIterator(s2);
        return this.collationContains(iter1, iter2, null, true);
    }

    public boolean startsWith(String s1, String s2) {
        CollationElementIterator iter1 = this.collator.getCollationElementIterator(s1);
        CollationElementIterator iter2 = this.collator.getCollationElementIterator(s2);
        return this.collationStartsWith(iter1, iter2);
    }

    public String substringAfter(String s1, String s2) {
        int[] ia;
        CollationElementIterator iter2;
        CollationElementIterator iter1 = this.collator.getCollationElementIterator(s1);
        boolean ba = this.collationContains(iter1, iter2 = this.collator.getCollationElementIterator(s2), ia = new int[2], false);
        if (ba) {
            return s1.substring(ia[1]);
        }
        return "";
    }

    public String substringBefore(String s1, String s2) {
        int[] ib;
        CollationElementIterator iter2;
        CollationElementIterator iter1 = this.collator.getCollationElementIterator(s1);
        boolean bb = this.collationContains(iter1, iter2 = this.collator.getCollationElementIterator(s2), ib = new int[2], false);
        if (bb) {
            return s1.substring(0, ib[0]);
        }
        return "";
    }

    private boolean collationStartsWith(CollationElementIterator s0, CollationElementIterator s1) {
        while (true) {
            int e0;
            int e1;
            if ((e1 = s1.next()) == 0) {
                continue;
            }
            if (e1 == -1) {
                return true;
            }
            while ((e0 = s0.next()) == 0) {
            }
            if (e0 != e1) break;
        }
        return false;
    }

    private boolean collationContains(CollationElementIterator s0, CollationElementIterator s1, int[] offsets, boolean matchAtEnd) {
        int e1;
        while ((e1 = s1.next()) == 0) {
        }
        if (e1 == -1) {
            return true;
        }
        int e0 = -1;
        while (true) {
            if (e0 != e1) {
                while ((e0 = s0.next()) == 0) {
                }
                if (e0 != -1) continue;
                return false;
            }
            int start = s0.getOffset();
            if (this.collationStartsWith(s0, s1)) {
                if (matchAtEnd) {
                    while ((e0 = s0.next()) == 0) {
                    }
                    if (e0 == -1) {
                        return true;
                    }
                } else {
                    if (offsets != null) {
                        offsets[0] = start - 1;
                        offsets[1] = s0.getOffset();
                    }
                    return true;
                }
            }
            s0.setOffset(start);
            if (s0.getOffset() != start) {
                s0.next();
            }
            s1.reset();
            e0 = -1;
            while ((e1 = s1.next()) == 0) {
            }
        }
    }

    public int compareStrings(String o1, String o2) {
        return this.collator.compare(o1, o2);
    }

    public Object getCollationKey(String s) {
        return null;
    }

    public static void main(String[] args) {
        Configuration config = new Configuration();
        StringCollator collator = StandardCollationURIResolver.getInstance().resolve(args[0], args[0], config);
        FastStringBuffer sb = new FastStringBuffer(100);
        if (collator instanceof RuleBasedCollator) {
            int e2;
            CollationElementIterator iter = ((RuleBasedCollator)((Object)collator)).getCollationElementIterator(args[1]);
            while ((e2 = iter.next()) != -1) {
                sb.append(e2 + " ");
            }
            System.err.println(sb.toString());
        }
    }
}

