/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.value.Value;

public class XPathException
extends TransformerException {
    private boolean isTypeError = false;
    private boolean isStaticError = false;
    String errorCodeNamespace;
    String errorCode;
    Value errorObject;
    private boolean hasBeenReported = false;
    transient XPathContext context;

    public XPathException(String message) {
        super(message);
    }

    public XPathException(Throwable err) {
        super(err);
    }

    public XPathException(String message, Throwable err) {
        super(message, err);
    }

    public XPathException(String message, SourceLocator loc) {
        super(message, loc);
    }

    public XPathException(String message, SourceLocator loc, Throwable err) {
        super(message, loc, err);
    }

    public XPathException(String message, String errorCode) {
        super(message);
        this.setErrorCode(errorCode);
    }

    public XPathException(String message, String errorCode, XPathContext context) {
        super(message);
        this.setErrorCode(errorCode);
        this.setXPathContext(context);
    }

    public static XPathException makeXPathException(TransformerException err) {
        if (err instanceof XPathException) {
            return (XPathException)err;
        }
        if (err.getException() instanceof XPathException) {
            return (XPathException)err.getException();
        }
        return new XPathException(err);
    }

    public XPathException makeStatic() {
        this.setIsStaticError(true);
        return this;
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public XPathContext getXPathContext() {
        return this.context;
    }

    public void setIsStaticError(boolean is) {
        this.isStaticError = is;
    }

    public boolean isStaticError() {
        return this.isStaticError;
    }

    public void setIsTypeError(boolean is) {
        this.isTypeError = is;
    }

    public boolean isTypeError() {
        return this.isTypeError;
    }

    public void setErrorCode(String code) {
        if (code != null) {
            this.errorCode = code;
            if (this.errorCodeNamespace == null) {
                this.errorCodeNamespace = "http://www.w3.org/2005/xqt-errors";
            }
        }
    }

    public void setErrorCode(String namespace2, String code) {
        this.errorCode = code;
        this.errorCodeNamespace = namespace2;
    }

    public String getErrorCodeLocalPart() {
        return this.errorCode;
    }

    public String getErrorCodeNamespace() {
        return this.errorCodeNamespace;
    }

    public void setErrorObject(Value value) {
        this.errorObject = value;
    }

    public Value getErrorObject() {
        return this.errorObject;
    }

    public void setHasBeenReported() {
        this.hasBeenReported = true;
    }

    public boolean hasBeenReported() {
        return this.hasBeenReported;
    }

    public void maybeSetLocation(SourceLocator locator) {
        if ((this.getLocator() == null || this.getLocator().getLineNumber() == -1) && locator != null) {
            this.setLocator(locator);
        }
    }

    public void maybeSetContext(XPathContext context) {
        if (this.getXPathContext() == null) {
            this.setXPathContext(context);
        }
    }

    public static class Circularity
    extends XPathException {
        public Circularity(String message) {
            super(message);
        }
    }
}

