/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class URLEncodedUtils {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final char[] DELIM = new char[]{'&'};

    public static List<NameValuePair> parse(URI uri, String encoding) {
        String query2 = uri.getRawQuery();
        if (query2 != null && query2.length() > 0) {
            ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
            Scanner scanner = new Scanner(query2);
            URLEncodedUtils.parse(result, scanner, encoding);
            return result;
        }
        return Collections.emptyList();
    }

    public static List<NameValuePair> parse(HttpEntity entity) throws IOException {
        String content;
        ContentType contentType = ContentType.get(entity);
        if (contentType != null && contentType.getMimeType().equalsIgnoreCase(CONTENT_TYPE) && (content = EntityUtils.toString(entity, Consts.ASCII)) != null && content.length() > 0) {
            Charset charset;
            Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
            if (charset == null) {
                charset = HTTP.DEF_CONTENT_CHARSET;
            }
            return URLEncodedUtils.parse(content, charset);
        }
        return Collections.emptyList();
    }

    public static boolean isEncoded(HttpEntity entity) {
        Header h = entity.getContentType();
        if (h != null) {
            HeaderElement[] elems = h.getElements();
            if (elems.length > 0) {
                String contentType = elems[0].getName();
                return contentType.equalsIgnoreCase(CONTENT_TYPE);
            }
            return false;
        }
        return false;
    }

    public static void parse(List<NameValuePair> parameters, Scanner scanner, String charset) {
        scanner.useDelimiter(PARAMETER_SEPARATOR);
        while (scanner.hasNext()) {
            String name = null;
            String value = null;
            String token = scanner.next();
            int i = token.indexOf(NAME_VALUE_SEPARATOR);
            if (i != -1) {
                name = URLEncodedUtils.decode(token.substring(0, i).trim(), charset);
                value = URLEncodedUtils.decode(token.substring(i + 1).trim(), charset);
            } else {
                name = URLEncodedUtils.decode(token.trim(), charset);
            }
            parameters.add(new BasicNameValuePair(name, value));
        }
    }

    public static List<NameValuePair> parse(String s, Charset charset) {
        if (s == null) {
            return Collections.emptyList();
        }
        BasicHeaderValueParser parser = BasicHeaderValueParser.DEFAULT;
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair nvp = parser.parseNameValuePair(buffer, cursor, DELIM);
            if (nvp.getName().length() <= 0) continue;
            list.add(new BasicNameValuePair(URLEncodedUtils.decode(nvp.getName(), charset), URLEncodedUtils.decode(nvp.getValue(), charset)));
        }
        return list;
    }

    public static String format(List<? extends NameValuePair> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = URLEncodedUtils.encode(nameValuePair.getName(), encoding);
            String encodedValue = URLEncodedUtils.encode(nameValuePair.getValue(), encoding);
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    public static String format(Iterable<? extends NameValuePair> parameters, Charset charset) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = URLEncodedUtils.encode(nameValuePair.getName(), charset);
            String encodedValue = URLEncodedUtils.encode(nameValuePair.getValue(), charset);
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String decode(String content, String charset) {
        if (content == null) {
            return null;
        }
        try {
            return URLDecoder.decode(content, charset != null ? charset : HTTP.DEF_CONTENT_CHARSET.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static String decode(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return URLEncodedUtils.decode(content, charset != null ? charset.name() : null);
    }

    private static String encode(String content, String charset) {
        if (content == null) {
            return null;
        }
        try {
            return URLEncoder.encode(content, charset != null ? charset : HTTP.DEF_CONTENT_CHARSET.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static String encode(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return URLEncodedUtils.encode(content, charset != null ? charset.name() : null);
    }
}

