/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Locale;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.system.IO_JenaWriters;
import org.apache.jena.riot.system.RiotLib;

public class RDFWriterRIOT
implements RDFWriter {
    private final String basename;
    private final String jenaName;
    private Context context = new Context();
    private WriterGraphRIOT writer;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public RDFWriterRIOT(String jenaName) {
        this.basename = "org.apache.jena.riot.writer." + jenaName.toLowerCase(Locale.ENGLISH);
        this.jenaName = jenaName;
    }

    private WriterGraphRIOT writer() {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.jenaName == null) {
            throw new IllegalArgumentException("Jena writer name is null");
        }
        this.writer = this.setWriter();
        return this.writer;
    }

    private WriterGraphRIOT setWriter() {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.jenaName == null) {
            throw new IllegalArgumentException("Jena writer name is null");
        }
        RDFFormat format = IO_JenaWriters.getFormatForJenaWriter(this.jenaName);
        if (format != null) {
            return RDFDataMgr.createGraphWriter(format);
        }
        Lang lang = RDFLanguages.nameToLang(this.jenaName);
        if (lang != null) {
            return RDFDataMgr.createGraphWriter(lang);
        }
        throw new RiotException("No graph writer for '" + this.jenaName + "'");
    }

    @Override
    public void write(Model model, Writer out, String base) {
        if (base != null && base.equals("")) {
            base = null;
        }
        Graph graph = model.getGraph();
        this.writer().write(out, graph, RiotLib.prefixMap(graph), base, this.context);
    }

    @Override
    public void write(Model model, OutputStream out, String base) {
        if (base != null && base.equals("")) {
            base = null;
        }
        Graph graph = model.getGraph();
        this.writer().write(out, graph, RiotLib.prefixMap(graph), base, this.context);
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        Symbol sym = Symbol.create(this.basename + propName);
        Object oldObj = this.context.get(sym);
        return oldObj;
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }
}

