/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectException
extends Statement {
    private Statement fNext;
    private final Class<? extends Throwable> fExpected;

    public ExpectException(Statement next, Class<? extends Throwable> expected) {
        this.fNext = next;
        this.fExpected = expected;
    }

    @Override
    public void evaluate() throws Exception {
        boolean complete;
        block3: {
            complete = false;
            try {
                this.fNext.evaluate();
                complete = true;
            }
            catch (Throwable e2) {
                if (this.fExpected.isAssignableFrom(e2.getClass())) break block3;
                String message = "Unexpected exception, expected<" + this.fExpected.getName() + "> but was<" + e2.getClass().getName() + ">";
                throw new Exception(message, e2);
            }
        }
        if (complete) {
            throw new AssertionError((Object)("Expected exception: " + this.fExpected.getName()));
        }
    }
}

