/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.w3c.util.InvalidDateException;

public class DateParser {
    private static boolean check(StringTokenizer st, String token) throws InvalidDateException {
        try {
            if (st.nextToken().equals(token)) {
                return true;
            }
            throw new InvalidDateException("Missing [" + token + "]");
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    private static Calendar getCalendar(String isodate) throws InvalidDateException {
        StringTokenizer st = new StringTokenizer(isodate, "-T:.+Z", true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        try {
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!DateParser.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!DateParser.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
            if (!DateParser.check(st, "T") || !st.hasMoreTokens()) {
                return calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            calendar.set(11, hour);
            if (!DateParser.check(st, ":") || !st.hasMoreTokens()) {
                return calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (st.hasMoreTokens()) {
                    int secondes = Integer.parseInt(st.nextToken());
                    calendar.set(13, secondes);
                    if (!st.hasMoreTokens()) {
                        return calendar;
                    }
                    tok = st.nextToken();
                    if (tok.equals(".")) {
                        String nt = st.nextToken();
                        while (nt.length() < 3) {
                            nt = nt + "0";
                        }
                        nt = nt.substring(0, 3);
                        int millisec = Integer.parseInt(nt);
                        calendar.set(14, millisec);
                        if (!st.hasMoreTokens()) {
                            return calendar;
                        }
                        tok = st.nextToken();
                    }
                } else {
                    throw new InvalidDateException("No secondes specified");
                }
            }
            if (!tok.equals("Z")) {
                if (!tok.equals("+") && !tok.equals("-")) {
                    throw new InvalidDateException("only Z, + or - allowed");
                }
                boolean plus = tok.equals("+");
                if (!st.hasMoreTokens()) {
                    throw new InvalidDateException("Missing hour field");
                }
                int tzhour = Integer.parseInt(st.nextToken());
                int tzmin = 0;
                if (!DateParser.check(st, ":") || !st.hasMoreTokens()) {
                    throw new InvalidDateException("Missing minute field");
                }
                tzmin = Integer.parseInt(st.nextToken());
                if (plus) {
                    ((Calendar)calendar).add(10, tzhour);
                    ((Calendar)calendar).add(12, tzmin);
                } else {
                    ((Calendar)calendar).add(10, -tzhour);
                    ((Calendar)calendar).add(12, -tzmin);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidDateException("[" + ex.getMessage() + "] is not an integer");
        }
        return calendar;
    }

    public static Calendar parse(String isodate) throws InvalidDateException {
        Calendar calendar = DateParser.getCalendar(isodate);
        return calendar;
    }

    private static String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    public static String getIsoDate(Calendar origCalendar) {
        if (origCalendar == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Calendar calendar = (Calendar)origCalendar.clone();
        calendar.setLenient(true);
        boolean isYearSet = calendar.isSet(1);
        boolean isMonthSet = calendar.isSet(2);
        boolean isDayOfMonthSet = calendar.isSet(5);
        boolean isHourOfDaySet = calendar.isSet(11);
        boolean isMinuteSet = calendar.isSet(12);
        boolean isSecondSet = calendar.isSet(13);
        boolean isMillisecondSet = calendar.isSet(14);
        if (!isYearSet) {
            return buffer.toString();
        }
        buffer.append(calendar.get(1));
        if (!isMonthSet) {
            return buffer.toString();
        }
        buffer.append("-");
        buffer.append(DateParser.twoDigit(calendar.get(2) + 1));
        if (!isDayOfMonthSet) {
            return buffer.toString();
        }
        buffer.append("-");
        buffer.append(DateParser.twoDigit(calendar.get(5)));
        if (!isHourOfDaySet) {
            return buffer.toString();
        }
        buffer.append("T");
        buffer.append(DateParser.twoDigit(calendar.get(11)));
        if (!isMinuteSet) {
            return buffer.toString();
        }
        buffer.append(":");
        buffer.append(DateParser.twoDigit(calendar.get(12)));
        if (!isSecondSet) {
            return buffer.toString();
        }
        buffer.append(":");
        buffer.append(DateParser.twoDigit(calendar.get(13)));
        if (!isMillisecondSet) {
            return buffer.toString();
        }
        buffer.append(".");
        buffer.append(DateParser.twoDigit(calendar.get(14) / 10));
        buffer.append("Z");
        return buffer.toString();
    }

    public static void test(String isodate) {
        System.out.println("----------------------------------");
        try {
            Calendar date2 = DateParser.parse(isodate);
            System.out.println(">> " + isodate);
            System.out.println(">> " + DateParser.getIsoDate(date2));
            System.out.println(">> " + date2.toString() + " [" + date2.getTime() + "]");
        }
        catch (InvalidDateException ex) {
            System.err.println(isodate + " is invalid");
            System.err.println(ex.getMessage());
        }
        System.out.println("----------------------------------");
    }

    public static void test(Calendar date2) {
        String isodate = null;
        System.out.println("----------------------------------");
        System.out.println(">> " + date2.getTime().toString() + " [" + date2.getTime().getTime() + "]");
        isodate = DateParser.getIsoDate(date2);
        System.out.println(">> " + isodate);
        System.out.println(">> " + date2.getTime().toString() + " [" + date2.getTime().getTime() + "]");
        System.out.println("----------------------------------");
    }

    public static void main(String[] args) {
        DateParser.test("1997-07-16T19:20:30.45-02:00");
        DateParser.test("1997-07-16T19:20:30+01:00");
        DateParser.test("1997-07-16T19:20:30+01:00");
        DateParser.test("1997-07-16T19:20");
        DateParser.test("1997-07-16");
        DateParser.test("1997-07");
        DateParser.test("1997");
        DateParser.test(Calendar.getInstance());
    }
}

