/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.LangStrings;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ClassificationTitlesInitializer
extends DefaultHandler {
    private boolean isInsideResource;
    private boolean isInsideConceptScheme;
    private boolean isInsidePrefLabel;
    private boolean areStringsFound;
    private String lang;
    private Map<String, String> strings;

    public ClassificationTitlesInitializer(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        block2: {
            this.isInsideResource = false;
            this.isInsideConceptScheme = false;
            this.isInsidePrefLabel = false;
            this.areStringsFound = false;
            this.strings = new HashMap<String, String>();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            try {
                parser.parse(new InputSource(inputStream), (DefaultHandler)this);
            }
            catch (SAXException e2) {
                if ("EOP".equals(e2.getMessage())) break block2;
                throw e2;
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        if (this.areStringsFound) {
            return;
        }
        if ("rdf:Description".equals(qName)) {
            this.isInsideResource = true;
            this.strings.clear();
        } else if ("rdf:type".equals(qName) && this.isInsideResource && !this.isInsideConceptScheme) {
            String type = attribs.getValue("rdf:resource");
            if ("http://www.w3.org/2004/02/skos/core#ConceptScheme".equals(type)) {
                this.isInsideConceptScheme = true;
            }
        } else if ("skos:prefLabel".equals(qName) && this.isInsideResource) {
            this.lang = attribs.getValue("xml:lang");
            this.isInsidePrefLabel = true;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.areStringsFound) {
            return;
        }
        if (this.isInsidePrefLabel) {
            String title = new String(ch, start, length).trim();
            this.strings.put(this.lang == null ? "" : this.lang, title);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.areStringsFound) {
            return;
        }
        if ("rdf:Description".equals(qName)) {
            if (this.isInsideConceptScheme) {
                this.areStringsFound = true;
                throw new SAXException("EOP");
            }
            this.isInsideResource = false;
            this.isInsideConceptScheme = false;
        } else if ("skos:prefLabel".equals(qName) && this.isInsideResource) {
            this.isInsidePrefLabel = false;
            this.lang = null;
        }
    }

    public LangStrings getTitles() {
        return new LangStrings(this.strings);
    }
}

