/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormMediator;
import ca.licef.lompad.OrderedValue;
import ca.licef.lompad.VocabularyComponent;
import ca.licef.lompad.VocabularyForm;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;

class ControlValueMediator
extends FormMediator {
    Object[] valueArray;
    Object[] exclusiveValues;
    Vector vExclusiveValues;
    private Vector vAvailableValues;
    private Dimension comboBoxPreferredSize = null;

    ControlValueMediator(VocabularyForm form, Object[] valueArray, Object[] exclusiveValues) {
        super(form);
        this.valueArray = valueArray;
        this.vAvailableValues = new Vector();
        this.exclusiveValues = exclusiveValues;
        if (exclusiveValues != null) {
            this.vExclusiveValues = new Vector();
        }
        if (valueArray != null) {
            for (int i = 0; i < valueArray.length; ++i) {
                OrderedValue v = new OrderedValue(valueArray[i], i, form.isLomVocabulary);
                if (exclusiveValues != null) {
                    for (int j = 0; j < exclusiveValues.length; ++j) {
                        if (exclusiveValues[j] == null) {
                            if (valueArray[i] != null) continue;
                            this.vExclusiveValues.addElement(v);
                            continue;
                        }
                        if (!exclusiveValues[j].equals(valueArray[i])) continue;
                        this.vExclusiveValues.addElement(v);
                    }
                }
                this.vAvailableValues.addElement(v);
            }
        }
    }

    private Vector getControlledComponents() {
        Vector<FormComponent> vRes = new Vector<FormComponent>();
        Enumeration e2 = this.form.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            if (!(c instanceof VocabularyComponent)) continue;
            vRes.add(c);
        }
        return vRes;
    }

    void buttonAddComponentPerformed(FormComponent c) {
        super.buttonAddComponentPerformed(c);
        this.setNotAvailableValue((VocabularyComponent)c, ((VocabularyComponent)c).getSelectedValue(), false);
        Vector vCtrlComp = this.getControlledComponents();
        if (this.vExclusiveValues != null && vCtrlComp.size() == 2) {
            Enumeration e2 = vCtrlComp.elements();
            while (e2.hasMoreElements()) {
                VocabularyComponent comp = (VocabularyComponent)e2.nextElement();
                Enumeration e22 = this.vExclusiveValues.elements();
                while (e22.hasMoreElements()) {
                    this.setNotAvailableValue(comp, (OrderedValue)e22.nextElement(), true);
                }
            }
        }
        boolean exclValSelected = this.vExclusiveValues != null && this.vExclusiveValues.contains(((VocabularyComponent)c).getSelectedValue());
        this.updateAddComponentButton(exclValSelected);
    }

    void buttonRemoveComponentPerformed(FormComponent c) {
        super.buttonRemoveComponentPerformed(c);
        if (!(c instanceof VocabularyComponent)) {
            return;
        }
        this.setAvailableValue((VocabularyComponent)c, ((VocabularyComponent)c).getSelectedValue());
        if (this.vExclusiveValues != null && this.getControlledComponents().size() == 1) {
            Enumeration e2 = this.vExclusiveValues.elements();
            while (e2.hasMoreElements()) {
                this.setAvailableValue((VocabularyComponent)c, (OrderedValue)e2.nextElement());
            }
        }
        this.updateAddComponentButton(false);
    }

    void comboBoxValuePerformed(VocabularyComponent c) {
        this.setAvailableValue(c, c.getPreviousSelectedValue());
        this.setNotAvailableValue(c, c.getSelectedValue(), false);
        boolean exclValSelected = this.vExclusiveValues != null && this.vExclusiveValues.contains(c.getSelectedValue());
        this.updateAddComponentButton(exclValSelected);
    }

    void updateAddComponentButton(boolean exclValSelected) {
        if (exclValSelected) {
            this.form.setEnabledButtonAdd(false);
        } else {
            this.form.setEnabledButtonAdd(((VocabularyForm)this.form).isEditable || this.vAvailableValues.size() > 0);
        }
    }

    public void setComboBoxPreferredSize(Dimension d) {
        if (this.comboBoxPreferredSize == null) {
            this.comboBoxPreferredSize = d;
        }
    }

    public Dimension getComboBoxPreferredSize() {
        return this.comboBoxPreferredSize;
    }

    Vector getAvailableValues() {
        return this.vAvailableValues;
    }

    void setNotAvailableValue(VocabularyComponent c, OrderedValue value, boolean forceSelf) {
        if (value.pos == -1) {
            return;
        }
        this.vAvailableValues.removeElement(value);
        Enumeration e2 = this.getControlledComponents().elements();
        while (e2.hasMoreElements()) {
            VocabularyComponent comp = (VocabularyComponent)e2.nextElement();
            if (comp.equals(c) && !forceSelf) continue;
            JComboBox comboBox = comp.getJComboBox();
            comboBox.removeItem(value);
        }
    }

    void setAvailableValue(VocabularyComponent c, OrderedValue value) {
        if (value.pos == -1) {
            return;
        }
        int pos = 0;
        Enumeration e2 = this.vAvailableValues.elements();
        while (e2.hasMoreElements()) {
            OrderedValue l = (OrderedValue)e2.nextElement();
            if (value.pos < l.pos) break;
            ++pos;
        }
        this.vAvailableValues.insertElementAt(value, pos);
        e2 = this.getControlledComponents().elements();
        while (e2.hasMoreElements()) {
            VocabularyComponent comp = (VocabularyComponent)e2.nextElement();
            if (comp.equals(c)) continue;
            JComboBox comboBox = comp.getJComboBox();
            for (pos = 0; pos < comboBox.getItemCount(); ++pos) {
                OrderedValue l = (OrderedValue)comboBox.getItemAt(pos);
                if (value.pos < l.pos) break;
            }
            comboBox.insertItemAt(value, pos);
        }
    }
}

