/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.EntityComponent;
import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormContainer;
import ca.licef.lompad.Util;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityForm
extends FormContainer {
    public EntityForm(String title, boolean isLine, boolean isMultipleContainer) {
        super(title, isLine, isMultipleContainer);
        this.offset = 2;
    }

    @Override
    void addFormContent() {
        boolean isFirst = this.vComponents.size() == 0;
        EntityComponent c = new EntityComponent(isFirst);
        int height = isFirst ? 50 : 25;
        c.setMinimumSize(new Dimension(10, height));
        c.setPreferredSize(new Dimension(10, height));
        c.setMaximumSize(new Dimension(2000, height));
        this.addComponent(c);
    }

    @Override
    String toXML(String key) {
        String xml = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c.toXML(key);
            if (res == null) continue;
            xml = xml + "<" + Util.getTag(key) + ">\n" + res + "</" + Util.getTag(key) + ">\n";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        EntityComponent c = null;
        if (this.isFilled()) {
            if (!this.isMultipleContainer) {
                return;
            }
            this.addFormContent();
            c = (EntityComponent)this.vComponents.lastElement();
        } else {
            c = (EntityComponent)this.vComponents.firstElement();
        }
        c.fromXML(path, e2);
    }

    @Override
    String toHTML(String key) {
        return this.toHTMLRow(key);
    }
}

