/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.DataFileFilter;
import ca.licef.lompad.FileBrowserEvent;
import ca.licef.lompad.FileBrowserListener;
import ca.licef.lompad.Preferences;
import ca.licef.lompad.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;

class FileBrowser
extends JPanel {
    public static final File TOP = new File("TOP");
    private JPanel panelLocation;
    private JTextField textFieldLocation;
    private JButton buttonClose;
    private JList listEntries;
    private JScrollPane scrollPaneEntries;
    private JCheckBox checkBoxShowHiddenFiles;
    private String currLoc;
    private String currFileLoc;
    private Vector listeners = new Vector();

    public FileBrowser() {
        this.setLayout(new BorderLayout(4, 4));
        this.textFieldLocation = new JTextField("");
        this.textFieldLocation.setEditable(false);
        this.buttonClose = new JButton("X");
        this.buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                FileBrowser.this.fireBrowserClosed();
            }
        });
        this.panelLocation = new JPanel(new BorderLayout(4, 4));
        this.panelLocation.add("Center", this.textFieldLocation);
        this.panelLocation.add("East", this.buttonClose);
        this.listEntries = new JList(){

            private boolean processEvent(MouseEvent e2) {
                int index = FileBrowser.this.listEntries.locationToIndex(e2.getPoint());
                return index > -1 && FileBrowser.this.listEntries.getCellBounds(index, index).contains(e2.getPoint());
            }

            protected void processMouseEvent(MouseEvent e2) {
                if (this.processEvent(e2)) {
                    super.processMouseEvent(e2);
                }
            }

            protected void processMouseMotionEvent(MouseEvent e2) {
                if (this.processEvent(e2)) {
                    super.processMouseMotionEvent(e2);
                }
            }
        };
        this.listEntries.setCellRenderer(new EntryRenderer());
        this.listEntries.setSelectionMode(0);
        this.listEntries.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e2) {
                if (!e2.getValueIsAdjusting()) {
                    FileBrowser.this.changeValue();
                }
            }
        });
        this.scrollPaneEntries = new JScrollPane(this.listEntries);
        this.checkBoxShowHiddenFiles = new JCheckBox("", Preferences.getInstance().isShowHiddenFiles());
        this.checkBoxShowHiddenFiles.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                try {
                    Preferences.getInstance().setShowHiddenFiles(FileBrowser.this.checkBoxShowHiddenFiles.isSelected());
                }
                catch (Exception e22) {
                    e22.printStackTrace();
                }
                FileBrowser.this.update();
            }
        });
        this.add("Center", this.scrollPaneEntries);
        this.add("North", this.panelLocation);
        if (Util.isShowHiddenDirectoryOptionAvailable()) {
            this.add("South", this.checkBoxShowHiddenFiles);
        }
        this.updateLocalization();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e2) {
                int width = e2.getComponent().getSize().width;
                try {
                    Preferences.getInstance().setFileBrowserWidth(width);
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        });
    }

    public void updateLocalization() {
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.FileBrowserRes", Preferences.getInstance().getLocale());
        this.checkBoxShowHiddenFiles.setText(resBundle.getString("showHiddenFiles"));
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.listEntries != null) {
            this.listEntries.setFont(font);
        }
        if (this.checkBoxShowHiddenFiles != null) {
            this.checkBoxShowHiddenFiles.setFont(font);
        }
    }

    public void update() {
        this.setCurrLocation(this.getCurrLocation());
    }

    public void addFileBrowserListener(FileBrowserListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeFileBrowserListener(ListSelectionListener listener) {
        this.listeners.removeElement(listener);
    }

    public void setCurrLocation(String currLoc) {
        if (currLoc == null) {
            return;
        }
        File loc = new File(currLoc);
        boolean isTop = TOP.equals(loc);
        if (!isTop && !loc.exists()) {
            loc = FileSystemView.getFileSystemView().getDefaultDirectory();
        }
        this.currLoc = loc + "";
        Object[] entries = null;
        if (isTop) {
            this.textFieldLocation.setToolTipText(null);
            this.textFieldLocation.setText(null);
            this.textFieldLocation.setCaretPosition(0);
            entries = File.listRoots();
        } else {
            File dir = loc.isDirectory() ? loc : loc.getParentFile();
            this.textFieldLocation.setToolTipText(dir + "");
            this.textFieldLocation.setText(dir + "");
            this.textFieldLocation.setCaretPosition(0);
            entries = dir.listFiles(new DataFileFilter());
        }
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        if (!isTop) {
            model.addElement(new File(".."));
        }
        if (entries != null) {
            Arrays.sort(entries);
            for (int i = 0; i < entries.length; ++i) {
                if (isTop && !((File)entries[i]).isDirectory()) continue;
                model.addElement(entries[i]);
            }
        }
        this.listEntries.setModel(model);
        if (!isTop && loc.isFile()) {
            this.currFileLoc = loc + "";
            int selectionIndex = ((DefaultListModel)this.listEntries.getModel()).indexOf(loc);
            this.listEntries.getSelectionModel().setSelectionInterval(selectionIndex, selectionIndex);
        }
    }

    public String getCurrLocation() {
        return this.currLoc;
    }

    public String getCurrFileLocation() {
        return this.currFileLoc;
    }

    public void clearSelection() {
        File tmpCurrLoc;
        this.listEntries.getSelectionModel().clearSelection();
        this.currFileLoc = null;
        if (this.currLoc != null && (tmpCurrLoc = new File(this.currLoc)).isFile()) {
            this.currLoc = tmpCurrLoc.getParentFile() + "";
        }
    }

    protected void fireFileSelected(File file) {
        FileBrowserEvent e2 = new FileBrowserEvent(this, file);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            FileBrowserListener listener = (FileBrowserListener)this.listeners.elementAt(i);
            listener.fileSelected(e2);
        }
    }

    protected void fireDirectorySelected(File file) {
        FileBrowserEvent e2 = new FileBrowserEvent(this, file);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            FileBrowserListener listener = (FileBrowserListener)this.listeners.elementAt(i);
            listener.directorySelected(e2);
        }
    }

    protected void fireBrowserClosed() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            FileBrowserListener listener = (FileBrowserListener)this.listeners.elementAt(i);
            listener.browserClosed();
        }
    }

    private void changeValue() {
        Object value = this.listEntries.getSelectedValue();
        if (value != null) {
            File file;
            File dir = new File(this.currLoc);
            if (dir.isFile()) {
                dir = dir.getParentFile();
            }
            if ((file = "..".equals(value + "") ? (dir.getParentFile() == null ? TOP : dir.getParentFile()) : (File)value).isFile()) {
                this.fireFileSelected(file);
            } else {
                this.setCurrLocation(file.toString());
                this.fireDirectorySelected(file);
            }
        }
    }

    private class EntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            File file = (File)value;
            boolean isRoot = file.getName() == null || "".equals(file.getName());
            this.setText(isRoot ? file.getPath() : file.getName());
            if (isRoot) {
                this.setIcon(Util.rootIcon);
            } else {
                this.setIcon(file.isDirectory() ? Util.folderIcon : Util.fileIcon);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

