/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.JPanelForm;
import ca.licef.lompad.JWindowAbout;
import ca.licef.lompad.Preferences;
import ca.licef.lompad.Util;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

class JFrameForm
extends JFrame {
    private JMenuItem itemNewFile;
    private JMenuItem itemOpenFile;
    private JMenuItem itemSaveFile;
    private JMenuItem itemSaveFileAs;
    private JMenuItem itemBrowseFolder;
    private JMenuItem itemViewHtml;
    private JMenuItem itemViewXml;
    private JMenuItem itemQuit;
    private JRadioButtonMenuItem itemLanguageFrench;
    private JRadioButtonMenuItem itemLanguageEnglish;
    private JRadioButtonMenuItem itemLanguageSpanish;
    private JMenuItem itemProfileIEEE;
    private JMenuItem itemProfileCanCore;
    private JMenuItem itemProfileScorm;
    private JMenuItem itemProfileNormetic_1_1_MandatoryElements;
    private JMenuItem itemProfileNormetic_1_1_MandatoryAndRecommendedElements;
    private JMenuItem itemProfileNormetic_1_1_AllElements;
    private JMenuItem itemProfileNormetic_1_2_MandatoryElements;
    private JMenuItem itemProfileNormetic_1_2_MandatoryAndRecommendedElements;
    private JMenuItem itemProfileNormetic_1_2_AllElements;
    private JMenuItem itemPreferencesManageLocalClassifs;
    private JMenuItem itemHelpRefDoc;
    private JMenuItem itemAbout;
    private JPanelForm jPanelForm;
    private JMenu menuFile;
    private JMenu menuLanguage;
    private JMenu menuProfiles;
    private JMenu menuProfilesNormetic_1_1;
    private JMenu menuProfilesNormetic_1_2;
    private JMenu menuPreferences;
    private JMenu menuHelp;

    public JFrameForm() {
        try {
            Preferences.getInstance().load();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.setTitle("title");
        SymAction lSymAction = new SymAction();
        this.setJMenuBar(this.createMenu(lSymAction));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(1024, 800);
        this.jPanelForm = new JPanelForm();
        this.setApplicationProfileView(Preferences.getInstance().getApplicationProfileView());
        this.getContentPane().add(this.jPanelForm);
        this.setIconImage(Util.imageApp);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.setLanguage(Preferences.getInstance().getLocale());
        this.setDefaultCloseOperation(0);
        this.jPanelForm.initBrowser();
    }

    public void setLanguage(Locale locale) {
        try {
            Preferences.getInstance().setLocale(locale);
            JFileChooser.setDefaultLocale(locale);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.updateLocalization();
        String lang = locale == Locale.FRENCH ? "fr" : (locale == Locale.ENGLISH ? "en" : "es");
        this.jPanelForm.changeLanguage(lang);
    }

    void updateLocalization() {
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.JFrameFormRes", Preferences.getInstance().getLocale());
        String s = "";
        int index = this.getTitle().indexOf(" -");
        if (index != -1) {
            s = this.getTitle().substring(index);
        }
        this.setTitle(" " + resBundle.getString("title") + s);
        this.menuFile.setText(resBundle.getString("file"));
        this.itemNewFile.setText(resBundle.getString("new"));
        this.itemOpenFile.setText(resBundle.getString("open"));
        this.itemSaveFile.setText(resBundle.getString("save"));
        this.itemSaveFileAs.setText(resBundle.getString("saveas") + "...");
        this.itemBrowseFolder.setText(resBundle.getString("browseFolder"));
        this.itemViewHtml.setText(resBundle.getString("viewhtml"));
        this.itemViewXml.setText(resBundle.getString("viewxml"));
        this.itemQuit.setText(resBundle.getString("quit"));
        this.menuLanguage.setText(resBundle.getString("language"));
        this.itemLanguageFrench.setText(resBundle.getString("french"));
        this.itemLanguageEnglish.setText(resBundle.getString("english"));
        this.itemLanguageSpanish.setText(resBundle.getString("spanish"));
        this.menuProfiles.setText(resBundle.getString("standards"));
        this.itemProfileIEEE.setText(resBundle.getString("IEEE"));
        this.itemProfileCanCore.setText(resBundle.getString("CANCORE"));
        this.itemProfileScorm.setText(resBundle.getString("SCORM"));
        this.itemProfileNormetic_1_1_MandatoryElements.setText(resBundle.getString("NORMETIC_1p1_MandatoryElements"));
        this.itemProfileNormetic_1_1_MandatoryAndRecommendedElements.setText(resBundle.getString("NORMETIC_1p1_MandatoryAndRecommendedElements"));
        this.itemProfileNormetic_1_1_AllElements.setText(resBundle.getString("NORMETIC_1p1_AllElements"));
        this.itemProfileNormetic_1_2_MandatoryElements.setText(resBundle.getString("NORMETIC_1p2_MandatoryElements"));
        this.itemProfileNormetic_1_2_MandatoryAndRecommendedElements.setText(resBundle.getString("NORMETIC_1p2_MandatoryAndRecommendedElements"));
        this.itemProfileNormetic_1_2_AllElements.setText(resBundle.getString("NORMETIC_1p2_AllElements"));
        this.menuPreferences.setText(resBundle.getString("preferences"));
        this.itemPreferencesManageLocalClassifs.setText(resBundle.getString("manageLocalClassifs"));
        this.menuHelp.setText(resBundle.getString("help"));
        this.itemHelpRefDoc.setText(resBundle.getString("ref"));
        this.itemAbout.setText(resBundle.getString("about"));
        this.jPanelForm.updateLocalization();
    }

    public static void main(String[] args) {
        try {
            JFrameForm app = new JFrameForm();
            JWindowAbout splash = new JWindowAbout(app, true);
            splash.setSize(376, 314);
            splash.setVisible(true);
            Thread.sleep(1500L);
            app.setVisible(true);
            splash.setVisible(false);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    JMenuBar createMenu(SymAction lSymAction) {
        JMenuBar mb = new JMenuBar();
        this.menuFile = new JMenu("file");
        this.menuFile.setFont(new Font("Dialog", 0, 12));
        this.itemNewFile = new JMenuItem("new");
        this.itemNewFile.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.itemNewFile.setFont(this.menuFile.getFont());
        this.itemNewFile.addActionListener(lSymAction);
        this.menuFile.add(this.itemNewFile);
        this.itemOpenFile = new JMenuItem("open");
        this.itemOpenFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.itemOpenFile.setFont(this.menuFile.getFont());
        this.itemOpenFile.addActionListener(lSymAction);
        this.menuFile.add(this.itemOpenFile);
        this.itemSaveFile = new JMenuItem("save");
        this.itemSaveFile.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.itemSaveFile.setFont(this.menuFile.getFont());
        this.itemSaveFile.addActionListener(lSymAction);
        this.menuFile.add(this.itemSaveFile);
        this.itemSaveFileAs = new JMenuItem("saveas");
        this.itemSaveFileAs.setFont(this.menuFile.getFont());
        this.itemSaveFileAs.addActionListener(lSymAction);
        this.menuFile.add(this.itemSaveFileAs);
        this.menuFile.addSeparator();
        this.itemBrowseFolder = new JMenuItem("browseFolder");
        this.itemBrowseFolder.setFont(this.menuFile.getFont());
        this.itemBrowseFolder.addActionListener(lSymAction);
        this.menuFile.add(this.itemBrowseFolder);
        this.menuFile.addSeparator();
        this.itemViewHtml = new JMenuItem("viewhtml");
        this.itemViewHtml.setFont(this.menuFile.getFont());
        this.itemViewHtml.addActionListener(lSymAction);
        this.menuFile.add(this.itemViewHtml);
        this.itemViewXml = new JMenuItem("viewxml");
        this.itemViewXml.setFont(this.menuFile.getFont());
        this.itemViewXml.addActionListener(lSymAction);
        this.menuFile.add(this.itemViewXml);
        this.menuFile.addSeparator();
        this.itemQuit = new JMenuItem("quit");
        this.itemQuit.setFont(this.menuFile.getFont());
        this.itemQuit.addActionListener(lSymAction);
        this.menuFile.add(this.itemQuit);
        mb.add(this.menuFile);
        this.menuLanguage = new JMenu("language");
        this.menuLanguage.setFont(this.menuFile.getFont());
        this.itemLanguageFrench = new JRadioButtonMenuItem("french");
        this.itemLanguageFrench.setFont(this.menuFile.getFont());
        this.itemLanguageFrench.addActionListener(lSymAction);
        this.menuLanguage.add(this.itemLanguageFrench);
        this.itemLanguageEnglish = new JRadioButtonMenuItem("english");
        this.itemLanguageEnglish.setFont(this.menuFile.getFont());
        this.itemLanguageEnglish.addActionListener(lSymAction);
        this.menuLanguage.add(this.itemLanguageEnglish);
        this.itemLanguageSpanish = new JRadioButtonMenuItem("spanish");
        this.itemLanguageSpanish.setFont(this.menuFile.getFont());
        this.itemLanguageSpanish.addActionListener(lSymAction);
        this.menuLanguage.add(this.itemLanguageSpanish);
        ButtonGroup groupmenuLanguage = new ButtonGroup();
        groupmenuLanguage.add(this.itemLanguageFrench);
        groupmenuLanguage.add(this.itemLanguageEnglish);
        groupmenuLanguage.add(this.itemLanguageSpanish);
        if (Preferences.getInstance().getLocale() == Locale.FRENCH) {
            this.itemLanguageFrench.setSelected(true);
        } else if (Preferences.getInstance().getLocale() == Locale.ENGLISH) {
            this.itemLanguageEnglish.setSelected(true);
        } else {
            this.itemLanguageSpanish.setSelected(true);
        }
        mb.add(this.menuLanguage);
        this.menuProfiles = new JMenu("standards");
        this.menuProfiles.setFont(this.menuFile.getFont());
        this.itemProfileIEEE = new JMenuItem("IEEE");
        this.itemProfileIEEE.setFont(this.menuFile.getFont());
        this.itemProfileIEEE.setSelected(true);
        this.itemProfileIEEE.addActionListener(lSymAction);
        this.menuProfiles.add(this.itemProfileIEEE);
        this.menuProfiles.addSeparator();
        this.itemProfileCanCore = new JMenuItem("CanCore");
        this.itemProfileCanCore.setFont(this.menuFile.getFont());
        this.itemProfileCanCore.addActionListener(lSymAction);
        this.menuProfiles.add(this.itemProfileCanCore);
        this.itemProfileScorm = new JMenuItem("SCORM");
        this.itemProfileScorm.setFont(this.menuFile.getFont());
        this.itemProfileScorm.addActionListener(lSymAction);
        this.menuProfiles.add(this.itemProfileScorm);
        this.menuProfilesNormetic_1_1 = new JMenu("Normetic 1.1");
        this.menuProfilesNormetic_1_1.setFont(this.menuFile.getFont());
        this.itemProfileNormetic_1_1_MandatoryElements = new JMenuItem("NORMETIC_1p1_MandatoryElements");
        this.itemProfileNormetic_1_1_MandatoryElements.setFont(this.menuFile.getFont());
        this.itemProfileNormetic_1_1_MandatoryElements.addActionListener(lSymAction);
        this.menuProfilesNormetic_1_1.add(this.itemProfileNormetic_1_1_MandatoryElements);
        this.itemProfileNormetic_1_1_MandatoryAndRecommendedElements = new JMenuItem("NORMETIC_1p1_MandatoryAndRecommendedElements");
        this.itemProfileNormetic_1_1_MandatoryAndRecommendedElements.setFont(this.menuFile.getFont());
        this.itemProfileNormetic_1_1_MandatoryAndRecommendedElements.addActionListener(lSymAction);
        this.menuProfilesNormetic_1_1.add(this.itemProfileNormetic_1_1_MandatoryAndRecommendedElements);
        this.itemProfileNormetic_1_1_AllElements = new JMenuItem("NORMETIC_1p1_AllElements");
        this.itemProfileNormetic_1_1_AllElements.setFont(this.menuFile.getFont());
        this.itemProfileNormetic_1_1_AllElements.addActionListener(lSymAction);
        this.menuProfilesNormetic_1_1.add(this.itemProfileNormetic_1_1_AllElements);
        this.menuProfiles.add(this.menuProfilesNormetic_1_1);
        this.menuProfilesNormetic_1_2 = new JMenu("Normetic 1.2");
        this.menuProfilesNormetic_1_2.setFont(this.menuFile.getFont());
        this.itemProfileNormetic_1_2_MandatoryElements = new JMenuItem("NORMETIC_1p2_MandatoryElements");
        this.itemProfileNormetic_1_2_MandatoryElements.setFont(this.menuFile.getFont());
        this.itemProfileNormetic_1_2_MandatoryElements.addActionListener(lSymAction);
        this.menuProfilesNormetic_1_2.add(this.itemProfileNormetic_1_2_MandatoryElements);
        this.itemProfileNormetic_1_2_MandatoryAndRecommendedElements = new JMenuItem("NORMETIC_1p2_MandatoryAndRecommendedElements");
        this.itemProfileNormetic_1_2_MandatoryAndRecommendedElements.setFont(this.menuFile.getFont());
        this.itemProfileNormetic_1_2_MandatoryAndRecommendedElements.addActionListener(lSymAction);
        this.menuProfilesNormetic_1_2.add(this.itemProfileNormetic_1_2_MandatoryAndRecommendedElements);
        this.itemProfileNormetic_1_2_AllElements = new JMenuItem("NORMETIC_1p2_AllElements");
        this.itemProfileNormetic_1_2_AllElements.setFont(this.menuFile.getFont());
        this.itemProfileNormetic_1_2_AllElements.addActionListener(lSymAction);
        this.menuProfilesNormetic_1_2.add(this.itemProfileNormetic_1_2_AllElements);
        this.menuProfiles.add(this.menuProfilesNormetic_1_2);
        mb.add(this.menuProfiles);
        this.menuPreferences = new JMenu("preferences");
        this.menuPreferences.setFont(this.menuFile.getFont());
        this.itemPreferencesManageLocalClassifs = new JMenuItem("manageLocalClassifs");
        this.itemPreferencesManageLocalClassifs.setFont(this.menuFile.getFont());
        this.itemPreferencesManageLocalClassifs.addActionListener(lSymAction);
        this.menuPreferences.add(this.itemPreferencesManageLocalClassifs);
        mb.add(this.menuPreferences);
        this.menuHelp = new JMenu("help");
        this.menuHelp.setFont(this.menuFile.getFont());
        this.itemHelpRefDoc = new JMenuItem("ref");
        this.itemHelpRefDoc.setFont(this.menuFile.getFont());
        this.itemHelpRefDoc.addActionListener(lSymAction);
        this.menuHelp.add(this.itemHelpRefDoc);
        this.menuHelp.addSeparator();
        this.itemAbout = new JMenuItem("about");
        this.itemAbout.setFont(this.menuFile.getFont());
        this.itemAbout.addActionListener(lSymAction);
        this.menuHelp.add(this.itemAbout);
        mb.add(this.menuHelp);
        return mb;
    }

    void JFrame1_windowClosing(WindowEvent event) {
        try {
            if (this.jPanelForm.manageCurrentLom()) {
                System.exit(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setApplicationProfileView(String applProfileView) {
        if ("IEEE".equals(applProfileView)) {
            this.jPanelForm.changeToIEEE();
            this.jPanelForm.updateProfile(this.itemProfileIEEE.getText());
        } else {
            this.jPanelForm.changeStandardActionPerformed(applProfileView, false);
            ResourceBundle resBundle = ResourceBundle.getBundle("properties.JFrameFormRes", Preferences.getInstance().getLocale());
            this.jPanelForm.updateProfile(resBundle.getString(applProfileView + "Label"));
        }
    }

    private void about() {
        JWindowAbout w = new JWindowAbout(this, false);
        w.setSize(376, 314);
        w.setVisible(true);
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == JFrameForm.this.itemNewFile) {
                JFrameForm.this.jPanelForm.newForm(true);
            } else if (object == JFrameForm.this.itemOpenFile) {
                JFrameForm.this.jPanelForm.openFile(JFrameForm.this.itemOpenFile.getText());
            } else if (object == JFrameForm.this.itemSaveFile) {
                JFrameForm.this.jPanelForm.saveFile(JFrameForm.this.itemSaveFile.getText());
            } else if (object == JFrameForm.this.itemSaveFileAs) {
                JFrameForm.this.jPanelForm.saveAsFile(JFrameForm.this.itemSaveFileAs.getText());
            } else if (object == JFrameForm.this.itemBrowseFolder) {
                JFrameForm.this.jPanelForm.showBrowser();
            } else if (object == JFrameForm.this.itemViewHtml) {
                JFrameForm.this.jPanelForm.viewHTML();
            } else if (object == JFrameForm.this.itemViewXml) {
                JFrameForm.this.jPanelForm.viewXML();
            } else if (object == JFrameForm.this.itemQuit) {
                JFrameForm.this.JFrame1_windowClosing(null);
            } else if (object == JFrameForm.this.itemLanguageFrench) {
                JFrameForm.this.setLanguage(Locale.FRENCH);
            } else if (object == JFrameForm.this.itemLanguageEnglish) {
                JFrameForm.this.setLanguage(Locale.ENGLISH);
            } else if (object == JFrameForm.this.itemLanguageSpanish) {
                JFrameForm.this.setLanguage(new Locale("es"));
            } else if (object == JFrameForm.this.itemProfileIEEE) {
                JFrameForm.this.setApplicationProfileView("IEEE");
            } else if (object == JFrameForm.this.itemProfileCanCore) {
                JFrameForm.this.setApplicationProfileView("CANCORE");
            } else if (object == JFrameForm.this.itemProfileScorm) {
                JFrameForm.this.setApplicationProfileView("SCORM");
            } else if (object == JFrameForm.this.itemProfileNormetic_1_1_MandatoryElements) {
                JFrameForm.this.setApplicationProfileView("NORMETIC_1p1_MandatoryElements");
            } else if (object == JFrameForm.this.itemProfileNormetic_1_1_MandatoryAndRecommendedElements) {
                JFrameForm.this.setApplicationProfileView("NORMETIC_1p1_MandatoryAndRecommendedElements");
            } else if (object == JFrameForm.this.itemProfileNormetic_1_1_AllElements) {
                JFrameForm.this.setApplicationProfileView("NORMETIC_1p1_AllElements");
            } else if (object == JFrameForm.this.itemProfileNormetic_1_2_MandatoryElements) {
                JFrameForm.this.setApplicationProfileView("NORMETIC_1p2_MandatoryElements");
            } else if (object == JFrameForm.this.itemProfileNormetic_1_2_MandatoryAndRecommendedElements) {
                JFrameForm.this.setApplicationProfileView("NORMETIC_1p2_MandatoryAndRecommendedElements");
            } else if (object == JFrameForm.this.itemProfileNormetic_1_2_AllElements) {
                JFrameForm.this.setApplicationProfileView("NORMETIC_1p2_AllElements");
            } else if (object == JFrameForm.this.itemPreferencesManageLocalClassifs) {
                JFrameForm.this.jPanelForm.manageLocalClassifications();
            } else if (object == JFrameForm.this.itemHelpRefDoc) {
                Util.launchFile("http://helios.licef.ca:8080/LomPad/LOM_1484_12_1_v1_Final_Draft.pdf");
            } else if (object == JFrameForm.this.itemAbout) {
                JFrameForm.this.about();
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == JFrameForm.this) {
                JFrameForm.this.JFrame1_windowClosing(event);
            }
        }
    }
}

