/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.FileBrowser;
import ca.licef.lompad.FileBrowserEvent;
import ca.licef.lompad.FileBrowserListener;
import ca.licef.lompad.JDialogAlert;
import ca.licef.lompad.JDialogManageClassifications;
import ca.licef.lompad.JDialogQuestion;
import ca.licef.lompad.LomForm;
import ca.licef.lompad.Preferences;
import ca.licef.lompad.Util;
import ca.licef.lompad.XMLFilter;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import licef.StringUtil;

class JPanelForm
extends JPanel {
    static JPanelForm instance;
    JPanel jPanelProfile;
    JPanel jPanelNormeticProfileIcons;
    JPanel jPanelNormeticLegend;
    JLabel jLabelRequired;
    JLabel jLabelRecommended;
    JLabel jLabelOptional;
    JLabel jLabelConditionalMandatory;
    JLabel jLabelProfileName;
    JLabel jLabelProfileIcon;
    JLabel jLabelProfile;
    JLabel jLabelLegend;
    JSplitPane splitPane;
    FileBrowser browser;
    JPanel jPanelWrapper;
    boolean bInit;
    LomForm lomForm;
    boolean isNormeticProfile = false;
    Icon normeticIcon;
    File file = null;

    public JPanelForm() {
        instance = this;
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.lomForm = new LomForm();
        this.jPanelProfile = new JPanel();
        this.jPanelProfile.setLayout(new BoxLayout(this.jPanelProfile, 0));
        this.add("North", this.jPanelProfile);
        this.jPanelProfile.add(Box.createHorizontalStrut(5));
        this.jLabelProfile = new JLabel("profile");
        this.jLabelProfile.setFont(new Font("Dialog", 0, 12));
        this.jPanelProfile.add(this.jLabelProfile);
        JLabel jLabelColon = new JLabel(" : ");
        jLabelColon.setFont(this.jLabelProfile.getFont());
        this.jPanelProfile.add(jLabelColon);
        this.jLabelProfileName = new JLabel();
        this.jLabelProfileName.setPreferredSize(new Dimension(300, 28));
        this.jLabelProfileName.setFont(this.jLabelProfile.getFont());
        this.jPanelProfile.add(this.jLabelProfileName);
        this.jPanelProfile.add(Box.createHorizontalGlue());
        this.jLabelProfileIcon = new JLabel();
        this.jLabelProfileIcon.setHorizontalAlignment(4);
        this.jLabelProfileIcon.setPreferredSize(new Dimension(40, 28));
        this.jLabelProfileIcon.setVisible(false);
        this.jPanelProfile.add(this.jLabelProfileIcon);
        this.jPanelProfile.add(Box.createHorizontalStrut(5));
        this.add("Center", this.lomForm);
        this.jPanelNormeticLegend = new JPanel(new FlowLayout(0, 10, 5));
        this.add("South", this.jPanelNormeticLegend);
        this.jLabelLegend = new JLabel("legend");
        this.jLabelLegend.setFont(this.jPanelProfile.getFont());
        this.jPanelNormeticLegend.add(this.jLabelLegend);
        this.jLabelRequired = new JLabel("required", Util.redIcon, 10);
        this.jLabelRequired.setFont(this.jLabelProfile.getFont());
        this.jPanelNormeticLegend.add(this.jLabelRequired);
        this.jLabelRecommended = new JLabel("recommended", Util.yellowIcon, 10);
        this.jLabelRecommended.setFont(this.jLabelProfile.getFont());
        this.jPanelNormeticLegend.add(this.jLabelRecommended);
        this.jLabelOptional = new JLabel("optional", Util.greenIcon, 10);
        this.jLabelOptional.setFont(this.jLabelProfile.getFont());
        this.jPanelNormeticLegend.add(this.jLabelOptional);
        this.jLabelConditionalMandatory = new JLabel("conditionalMandatory", Util.greenYellowRedIcon, 10);
        this.jLabelConditionalMandatory.setFont(this.jLabelProfile.getFont());
        this.jPanelNormeticLegend.add(this.jLabelConditionalMandatory);
        this.normeticIcon = Util.normeticDisabledIcon;
        this.browser = new FileBrowser();
        this.browser.setFont(new Font("Dialog", 0, 12));
        this.browser.addFileBrowserListener(new FileBrowserListener(){
            private boolean isEnabled = true;

            public void setEnabled(boolean isEnabled) {
                this.isEnabled = isEnabled;
            }

            public boolean isEnabled() {
                return this.isEnabled;
            }

            public void fileSelected(FileBrowserEvent e2) {
                if (this.isEnabled) {
                    this.setEnabled(false);
                    if (JPanelForm.this.openFileFromBrowser(e2.getFile() + "")) {
                        JPanelForm.this.browser.setCurrLocation(e2.getFile() + "");
                    } else {
                        String currFileLoc = JPanelForm.this.browser.getCurrFileLocation();
                        if (currFileLoc == null) {
                            JPanelForm.this.browser.clearSelection();
                        } else {
                            JPanelForm.this.browser.setCurrLocation(currFileLoc);
                        }
                    }
                    this.setEnabled(true);
                }
            }

            public void directorySelected(FileBrowserEvent e2) {
                if (this.isEnabled) {
                    try {
                        Preferences.getInstance().setFileBrowserLocation(e2.getFile());
                    }
                    catch (Exception e22) {
                        e22.printStackTrace();
                    }
                }
            }

            public void browserClosed() {
                JPanelForm.this.hideBrowser();
            }
        });
        this.bInit = true;
        this.lomForm.init();
        this.bInit = false;
        this.updateLocalization();
    }

    public void initBrowser() {
        this.browser.setCurrLocation(Preferences.getInstance().getFileBrowserLocation() + "");
        if (Preferences.getInstance().isFileBrowserOpened()) {
            this.showBrowser();
        }
    }

    public void showBrowser() {
        if (this.splitPane == null) {
            this.remove(this.jPanelProfile);
            this.remove(this.lomForm);
            this.remove(this.jPanelNormeticLegend);
            this.jPanelWrapper = new JPanel(new BorderLayout(0, 0));
            this.jPanelWrapper.add("North", this.jPanelProfile);
            this.jPanelWrapper.add("Center", this.lomForm);
            this.jPanelWrapper.add("South", this.jPanelNormeticLegend);
            this.splitPane = new JSplitPane(1, this.browser, this.jPanelWrapper);
            this.add("Center", this.splitPane);
            this.validate();
        }
        this.browser.setVisible(true);
        this.browser.update();
        try {
            Preferences.getInstance().setFileBrowserOpened(true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        int browserWidth = Preferences.getInstance().getFileBrowserWidth();
        if (browserWidth > 0) {
            this.splitPane.setDividerLocation(browserWidth);
        }
    }

    private void hideBrowser() {
        if (this.splitPane != null) {
            this.remove(this.splitPane);
            this.browser.setVisible(false);
            try {
                Preferences.getInstance().setFileBrowserOpened(false);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.splitPane.remove(this.browser);
            this.splitPane.remove(this.jPanelWrapper);
            this.splitPane = null;
            this.add("North", this.jPanelProfile);
            this.add("South", this.jPanelNormeticLegend);
            this.add("Center", this.lomForm);
            this.validate();
        }
    }

    public void updateLocalization() {
        ResourceBundle resBundle = ResourceBundle.getBundle("properties.JFrameFormRes", Preferences.getInstance().getLocale());
        this.jLabelProfile.setText(resBundle.getString("profile"));
        this.jLabelLegend.setText(resBundle.getString("legend") + " :");
        this.jLabelRequired.setText(resBundle.getString("required"));
        this.jLabelRecommended.setText(resBundle.getString("recommended"));
        this.jLabelOptional.setText(resBundle.getString("optional"));
        this.jLabelConditionalMandatory.setText(resBundle.getString("conditionalMandatory"));
        this.jLabelProfileName.setText(resBundle.getString(Preferences.getInstance().getApplicationProfileView() + "Label"));
        if (this.browser != null) {
            this.browser.updateLocalization();
        }
    }

    void doFilter() {
        if (this.bInit) {
            return;
        }
        if (!Preferences.getInstance().getApplicationProfileView().equals("IEEE")) {
            this.changeStandard(Preferences.getInstance().getApplicationProfileView(), false);
        }
    }

    void changeToIEEE() {
        this.lomForm.preUpdateVocabularies();
        this.undo();
        try {
            Preferences.getInstance().setApplicationProfileView("IEEE");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.bInit = true;
        this.lomForm.updateVocabularies();
        this.bInit = false;
    }

    void undo() {
        if (!Preferences.getInstance().getApplicationProfileView().equals("IEEE")) {
            this.changeStandard(Preferences.getInstance().getApplicationProfileView(), true);
        }
    }

    void changeStandardActionPerformed(String profile, boolean isVisible) {
        this.lomForm.preUpdateVocabularies();
        this.changeStandard(profile, isVisible);
        Util.setExternalVocabulary(this.getCurrentSelectedProfile());
        this.bInit = true;
        this.lomForm.updateVocabularies();
        this.bInit = false;
    }

    void changeStandard(String profile, boolean isVisible) {
        if (!isVisible) {
            this.undo();
            try {
                Preferences.getInstance().setApplicationProfileView(profile);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        try {
            ResourceBundle resBundle = ResourceBundle.getBundle("properties." + Preferences.getInstance().getApplicationProfileView());
            StringTokenizer st = new StringTokenizer(resBundle.getString("hideComponent"), ",");
            while (st.hasMoreTokens()) {
                this.lomForm.setFormVisible(st.nextToken(), isVisible);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateIcons();
    }

    public void updateIcons() {
        this.lomForm.clearFormIcon();
        this.lomForm.clearFormToolTipText();
        try {
            ResourceBundle resBundle = ResourceBundle.getBundle("properties." + Preferences.getInstance().getApplicationProfileView());
            this.setFormIcons(resBundle, "mandatoryComponent", Util.redIcon);
            this.setFormIcons(resBundle, "conditionalMandatoryComponent", Util.greenYellowRedIcon);
            this.setFormIcons(resBundle, "recommendedComponent", Util.yellowIcon);
            this.setFormIcons(resBundle, "optionalComponent", Util.greenIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getCurrentSelectedProfile() {
        String res = Preferences.getInstance().getApplicationProfileView();
        if (res.startsWith("NORMETIC_1p1")) {
            res = "NORMETIC_1p1";
        } else if (res.startsWith("NORMETIC_1p2")) {
            res = "NORMETIC_1p2";
        }
        return res;
    }

    public boolean isValidNormetic() {
        ResourceBundle resBundle = ResourceBundle.getBundle("properties." + this.getCurrentSelectedProfile() + "_MandatoryElements");
        StringTokenizer st = new StringTokenizer(resBundle.getString("mandatoryComponent"), ",");
        while (st.hasMoreTokens()) {
            boolean res = this.lomForm.isComplete(st.nextToken());
            if (res) continue;
            return false;
        }
        return true;
    }

    boolean manageCurrentLom() {
        if (this.lomForm.hasChanged()) {
            JDialogQuestion dialog = new JDialogQuestion(Util.getTopJFrame(this), "title", "text1");
            dialog.setVisible(true);
            int res = dialog.res;
            dialog.dispose();
            if (res == JDialogQuestion.CANCEL) {
                return false;
            }
            if (res == JDialogQuestion.NO) {
                return true;
            }
            if (res == JDialogQuestion.YES) {
                ResourceBundle resBundle = ResourceBundle.getBundle("properties.JFrameFormRes", Preferences.getInstance().getLocale());
                return this.saveFile(resBundle.getString("save"));
            }
        }
        return true;
    }

    void updateFrameTitle() {
        String s = "";
        JFrame top = Util.getTopJFrame(this);
        String title = top.getTitle();
        int index = title.indexOf(" -");
        if (index != -1) {
            title = title.substring(0, index);
        }
        if (this.file != null) {
            s = " - " + this.file.getName();
        }
        top.setTitle(title + s);
    }

    void newForm(boolean callFromMenu) {
        if (callFromMenu) {
            if (!this.manageCurrentLom()) {
                return;
            }
            if (this.browser != null) {
                this.browser.clearSelection();
            }
        }
        this.bInit = true;
        this.lomForm.init();
        this.bInit = false;
        this.doFilter();
        this.lomForm.update();
        this.lomForm.initiateHasChanged();
        this.file = null;
        if (callFromMenu) {
            this.updateFrameTitle();
            this.updateNormeticIcon();
        }
    }

    public boolean openFileFromBrowser(String file) {
        boolean isValidFile;
        block6: {
            if (!this.manageCurrentLom()) {
                return false;
            }
            this.newForm(false);
            isValidFile = true;
            try {
                this.lomForm.fromXML(new FileInputStream(file));
            }
            catch (Exception e2) {
                isValidFile = false;
                JDialogAlert dialog = new JDialogAlert(Util.getTopJFrame(this), "titleErr", "text1");
                dialog.setVisible(true);
                if (this.browser == null) break block6;
                this.browser.clearSelection();
                file = null;
            }
        }
        this.file = file == null ? null : new File(file);
        this.lomForm.initiateHasChanged();
        this.updateFrameTitle();
        this.updateNormeticIcon();
        if (isValidFile) {
            try {
                Preferences.getInstance().setFileBrowserLocation(this.file);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public void openFile(String label) {
        boolean isValidFile;
        block8: {
            if (!this.manageCurrentLom()) {
                return;
            }
            File fileTmp = this.selectFile(true, label);
            if (fileTmp == null) {
                return;
            }
            this.newForm(false);
            if (fileTmp.isDirectory()) {
                this.showBrowser();
                this.browser.setCurrLocation(fileTmp + "");
                return;
            }
            this.file = fileTmp;
            isValidFile = true;
            try {
                this.lomForm.fromXML(new FileInputStream(this.file));
            }
            catch (Exception e2) {
                isValidFile = false;
                JDialogAlert dialog = new JDialogAlert(Util.getTopJFrame(this), "titleErr", "text1");
                dialog.setVisible(true);
                if (this.browser == null) break block8;
                this.browser.clearSelection();
                this.file = null;
            }
        }
        this.lomForm.initiateHasChanged();
        this.updateFrameTitle();
        this.updateNormeticIcon();
        if (this.browser != null) {
            if (isValidFile) {
                this.browser.setCurrLocation(this.file + "");
            } else {
                this.browser.setCurrLocation(this.browser.getCurrFileLocation());
            }
        }
    }

    File selectFile(boolean openMode, String label) {
        int rVal;
        File f = null;
        JFileChooser fc = new JFileChooser();
        if (openMode) {
            fc.setFileSelectionMode(2);
        }
        fc.setCurrentDirectory(Preferences.getInstance().getWorkingDir());
        if (label != null) {
            fc.setDialogTitle(" " + label);
        }
        fc.addChoosableFileFilter(new XMLFilter());
        if (openMode) {
            rVal = fc.showOpenDialog(this);
        } else {
            String s = "lom.xml";
            if (this.file != null) {
                s = this.file.getName();
            }
            fc.setSelectedFile(new File(s));
            rVal = fc.showSaveDialog(this);
        }
        if (rVal == 0) {
            f = new File(fc.getCurrentDirectory() + File.separator + fc.getSelectedFile().getName());
        }
        if (f != null) {
            try {
                Preferences.getInstance().setWorkingDir(fc.getSelectedFile().isDirectory() ? f : f.getParentFile());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return f;
    }

    public boolean saveFile(String label) {
        if (this.file == null) {
            File selectedFile = this.selectFile(false, label);
            if (selectedFile == null) {
                return false;
            }
            if (selectedFile.exists()) {
                JDialogQuestion dialog = new JDialogQuestion(Util.getTopJFrame(this), "title", "text2");
                dialog.setVisible(true);
                int res = dialog.res;
                dialog.dispose();
                if (res == JDialogQuestion.CANCEL || res == JDialogQuestion.NO) {
                    return false;
                }
            }
            this.file = selectedFile;
        }
        this.doSaveFile();
        return true;
    }

    public void saveAsFile(String label) {
        File selectedFile = this.selectFile(false, label);
        if (selectedFile != null) {
            if (selectedFile.exists()) {
                JDialogQuestion dialog = new JDialogQuestion(Util.getTopJFrame(this), "title", "text2");
                dialog.setVisible(true);
                int res = dialog.res;
                dialog.dispose();
                if (res == JDialogQuestion.CANCEL || res == JDialogQuestion.NO) {
                    return;
                }
            }
            this.file = selectedFile;
            this.doSaveFile();
        }
    }

    private void doSaveFile() {
        if (this.file != null) {
            this.writeFile(this.file);
            this.lomForm.initiateHasChanged();
            this.updateFrameTitle();
            this.updateNormeticIcon();
            if (this.browser != null) {
                this.browser.setCurrLocation(this.file + "");
            }
        }
    }

    void writeFile(File f) {
        try {
            String lom = this.lomForm.toXML();
            FileOutputStream fos = new FileOutputStream(f);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            writer.write(lom);
            writer.flush();
            writer.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    void viewHTML() {
        this.popHTML(this.lomForm.toHTML());
    }

    void viewXML() {
        this.popXML(this.lomForm.toXML());
    }

    void popXML(String xml) {
        try {
            this.popLomFromTempFile(xml, "lom.xml");
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    void popHTML(String html) {
        try {
            this.popLomFromTempFile(html, "lom.html");
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    void changeLanguage(String lang) {
        try {
            if (lang.equals("fr")) {
                Util.setBundleLocale(Locale.FRENCH);
                this.lomForm.graphicalUpdate();
            } else if (lang.equals("en")) {
                Util.setBundleLocale(Locale.ENGLISH);
                this.lomForm.graphicalUpdate();
            } else if (lang.equals("es")) {
                Util.setBundleLocale(new Locale("es"));
                this.lomForm.graphicalUpdate();
            }
            this.lomForm.update();
            this.updateIcons();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void updateProfile(String profile) {
        this.isNormeticProfile = profile.startsWith("Normetic");
        this.jPanelNormeticLegend.setVisible(this.isNormeticProfile);
        this.jLabelProfileName.setText(profile);
        if (this.isNormeticProfile) {
            this.jLabelProfileIcon.setIcon(this.normeticIcon);
            this.jLabelProfileIcon.setVisible(true);
        } else if ("CanCore".equals(profile)) {
            this.jLabelProfileIcon.setIcon(Util.cancoreIcon);
            this.jLabelProfileIcon.setVisible(true);
        } else {
            this.jLabelProfileIcon.setIcon(null);
            this.jLabelProfileIcon.setVisible(false);
        }
        this.jLabelProfileIcon.updateUI();
    }

    private void updateNormeticIcon() {
        if (this.isNormeticProfile) {
            this.normeticIcon = this.isValidNormetic() ? Util.normeticIcon : Util.normeticDisabledIcon;
            this.jLabelProfileIcon.setIcon(this.normeticIcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popLomFromTempFile(String lom, String tempFile) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        String file = null;
        try {
            String tempDir = System.getProperty("java.io.tmpdir").replace('\\', '/');
            if (!tempDir.endsWith("/")) {
                tempDir = tempDir + "/";
            }
            file = tempDir + tempFile;
            reader = new BufferedReader(new StringReader(lom));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            Util.copy(reader, writer);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            try {
                writer.close();
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
        Util.launchFile(file);
    }

    private void setFormIcons(ResourceBundle bundle, String keyGroupLabel, ImageIcon icon) {
        String keys;
        if (bundle.containsKey(keyGroupLabel) && !StringUtil.isEmpty(keys = bundle.getString(keyGroupLabel))) {
            ResourceBundle bundleToolTipText = ResourceBundle.getBundle("properties." + this.getCurrentSelectedProfile() + "_ToolTipText", Preferences.getInstance().getLocale());
            StringTokenizer st = new StringTokenizer(keys, ",");
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                String toolTipText = bundleToolTipText == null || !bundleToolTipText.containsKey(key) ? null : bundleToolTipText.getString(key);
                this.lomForm.setFormIcon(key, icon);
                this.lomForm.setFormToolTipText(key, toolTipText);
            }
        }
    }

    public void manageLocalClassifications() {
        JDialogManageClassifications dialogManageClassif = new JDialogManageClassifications(Util.getTopJFrame(this));
        dialogManageClassif.setSize(660, 400);
        dialogManageClassif.setVisible(true);
    }
}

