/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.JDialogDateSelector;
import ca.licef.lompad.Preferences;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import licef.StringUtil;

class LightCalendar
extends JComponent {
    public static final Color BG_MONTH_NAME = new Color(117, 123, 114);
    public static final Color FG_MONTH_NAME = new Color(225, 222, 215);
    public static final Color BG_DAY_NAME = new Color(117, 123, 114);
    public static final Color FG_DAY_NAME = new Color(225, 222, 215);
    public static final Color BG_DAY = Color.white;
    public static final Color FG_DAY = Color.black;
    public static final Color SELECTION_COLOR = Color.blue;
    public static final Color TODAY_FRAME_COLOR = Color.red;
    JDialogDateSelector parent;
    protected int annee;
    protected Date dateDebutMois;
    protected boolean drawMonthName;
    protected Font font;
    protected Font fontHighlighted;
    protected FontMetrics fm;
    protected FontMetrics fmHighlighted;
    protected int mois;
    protected Date selectedDate;
    protected int selectedRow;
    protected int selectedCol;
    private Image offImage;
    private Graphics offGraphics;

    public LightCalendar(JDialogDateSelector parent, boolean drawMonthName) {
        this.parent = parent;
        this.offGraphics = null;
        this.offImage = null;
        this.drawMonthName = drawMonthName;
        this.selectedDate = null;
        this.selectedRow = -1;
        this.selectedCol = -1;
        this.font = new Font("Helvetica", 0, 12);
        this.fontHighlighted = new Font("Helvetica", 1, 12);
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
    }

    public void setDate(Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date2);
        this.annee = cal.get(1);
        this.mois = cal.get(2);
        this.dateDebutMois = this.trouveDateDebutMois(date2);
        this.selectionner(date2);
    }

    public Date getDate() {
        return this.dateDebutMois;
    }

    public Date getDateSelectionnee() {
        return this.selectedDate;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.offImage = this.createImage(width, height);
        this.offGraphics = this.offImage.getGraphics();
        this.offGraphics.setFont(this.font);
        this.fm = this.offGraphics.getFontMetrics(this.font);
        int xPen = 0;
        int yPen = 0;
        DateFormatSymbols dfs = new DateFormatSymbols(Preferences.getInstance().getLocale());
        if (this.drawMonthName) {
            String strMonthName = StringUtil.capitalize(dfs.getMonths()[this.mois]) + ", " + new Integer(this.annee).toString();
            this.offGraphics.setColor(BG_MONTH_NAME);
            this.offGraphics.fillRect(xPen, yPen, width - 1, this.fm.getHeight() + 2);
            this.offGraphics.setColor(FG_MONTH_NAME);
            this.offGraphics.drawString(strMonthName, xPen + 5, this.fm.getHeight());
            yPen += this.fm.getHeight() + 2;
        }
        int caseWidth = (width - 2) / 7;
        this.offGraphics.setColor(BG_DAY_NAME);
        this.offGraphics.fillRect(1, yPen, width - 2, this.fm.getHeight() + 5);
        this.offGraphics.setColor(FG_DAY_NAME);
        for (int i = 1; i <= 7; ++i) {
            String strNomJour = StringUtil.capitalize(dfs.getWeekdays()[i].substring(0, 1));
            int x = 1 + (i - 1) * caseWidth + (caseWidth - this.fm.stringWidth(strNomJour)) / 2;
            int y = yPen + this.fm.getHeight() - 1;
            this.offGraphics.drawString(strNomJour, x, y);
        }
        Rectangle r = new Rectangle(1, yPen += this.fm.getHeight() + 5, width - 2, height - yPen - 1);
        this.offGraphics.setFont(this.font);
        this.fm = this.offGraphics.getFontMetrics(this.font);
        this.offGraphics.setColor(BG_DAY);
        this.offGraphics.fillRect(r.x, r.y, r.width, r.height);
        int caseHeight = r.height / 7;
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.dateDebutMois);
        int nbJoursVides = cal.get(7) - 1;
        int iJoursVides = 0;
        yPen += 3;
        for (int iRow = 0; iRow < 6; ++iRow) {
            for (int iCol = 0; iCol < 7; ++iCol) {
                int day = cal.get(5);
                if (iJoursVides < nbJoursVides) {
                    ++iJoursVides;
                    continue;
                }
                if (cal.get(2) != this.mois) continue;
                String strDay = new Integer(day).toString();
                int xCase = 3 + iCol * caseWidth;
                int yCase = yPen + iRow * caseHeight;
                int x = xCase + (caseWidth - this.fm.stringWidth(strDay)) / 2;
                int y = yCase + (caseHeight - this.fm.getHeight()) / 2 + this.fm.getHeight() - 2;
                this.offGraphics.setFont(this.font);
                this.offGraphics.setColor(FG_DAY);
                if (iRow == this.selectedRow && iCol == this.selectedCol) {
                    this.offGraphics.setColor(SELECTION_COLOR);
                    this.offGraphics.drawRect(xCase + 2, yCase + 1, caseWidth - 4, caseHeight);
                    this.offGraphics.setColor(FG_DAY);
                }
                this.offGraphics.drawString(strDay, x, y);
                int dayTemp = cal.get(5);
                cal.add(5, 1);
                while (cal.get(5) == dayTemp) {
                    cal.add(12, 1);
                }
            }
        }
        this.offGraphics.setColor(Color.black);
        this.offGraphics.drawRect(0, 0, width - 1, height - 6);
        g.drawImage(this.offImage, 0, 5, null);
    }

    public void selectionner(Date date2) {
        this.selectedDate = date2;
        this.selectedRow = -1;
        this.selectedCol = -1;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date2);
        if (cal.get(1) != this.annee) {
            return;
        }
        if (cal.get(2) != this.mois) {
            return;
        }
        this.selectedCol = cal.get(7) - 1;
        Calendar calDebut = Calendar.getInstance();
        calDebut.setTime(this.dateDebutMois);
        int minJour = 1;
        int maxJour = 7 - calDebut.get(7) + 1;
        int jour = cal.get(5);
        int testedRow = 0;
        while (this.selectedRow == -1 && testedRow < 6) {
            if (minJour <= jour && jour <= maxJour) {
                this.selectedRow = testedRow;
                continue;
            }
            minJour += maxJour - minJour + 1;
            maxJour += 7;
            ++testedRow;
        }
        this.repaint();
    }

    public void deselectionner() {
        this.selectedRow = -1;
        this.selectedCol = -1;
        this.repaint();
    }

    private Date trouveDateDebutMois(Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date2);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    void LightCalendar_MousePress(MouseEvent event) {
        int h;
        int w;
        int x = 1;
        int y = this.drawMonthName ? 2 * (this.fm.getHeight() + 2) : this.fm.getHeight();
        Rectangle r = new Rectangle(x, y, w = this.getSize().width - 2, h = this.getSize().height - y + 5);
        if (r.contains(event.getPoint())) {
            int caseWidth = w / 7;
            int caseHeight = h / 7;
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.dateDebutMois);
            int nbJoursVides = cal.get(7) - 1;
            int iJoursVides = 0;
            block0: for (int iRow = 0; iRow < 6; ++iRow) {
                for (int iCol = 0; iCol < 7; ++iCol) {
                    if (iJoursVides < nbJoursVides) {
                        ++iJoursVides;
                        continue;
                    }
                    if (cal.get(2) != this.mois) continue;
                    int xCase = 1 + iCol * caseWidth;
                    int yCase = y + iRow * caseHeight;
                    Rectangle rCase = new Rectangle(xCase, yCase + 5, caseWidth, caseHeight);
                    if (rCase.contains(event.getPoint())) {
                        this.selectedDate = cal.getTime();
                        this.selectedRow = iRow;
                        this.selectedCol = iCol;
                        this.parent.currentDate = this.selectedDate;
                        this.repaint();
                        break block0;
                    }
                    cal.add(5, 1);
                }
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == LightCalendar.this) {
                LightCalendar.this.LightCalendar_MousePress(event);
            }
        }
    }
}

