/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.Util;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import javax.swing.filechooser.FileSystemView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Preferences {
    public static final int MIME_SUBTYPE_SORT_MODE_UNSORTED = 0;
    public static final int MIME_SUBTYPE_SORT_MODE_ASC_SORTED = 1;
    public static final int MIME_SUBTYPE_SORT_MODE_DESC_SORTED = 2;
    private boolean isShowHiddenFilesEnabled;
    private int mimeSubtypeSortMode = 0;
    private boolean isShowTaxumIdEnabled;
    private File prevClassifDir = null;
    private File workingDir = FileSystemView.getFileSystemView().getDefaultDirectory();
    private File fileBrowserLoc = FileSystemView.getFileSystemView().getDefaultDirectory();
    private boolean isFileBrowserOpen;
    private int fileBrowserWidth;
    private String prevSelectedClassif;
    private Locale locale = Locale.FRENCH;
    private String applProfileView = "IEEE";
    private static Preferences instance;

    public static Preferences getInstance() {
        if (instance == null) {
            instance = new Preferences();
        }
        return instance;
    }

    public void load() throws Exception {
        File prefsFile = new File(Util.getDataFolder(), "prefs.xml");
        if (prefsFile.exists()) {
            this.fromXML(new BufferedInputStream(new FileInputStream(prefsFile)));
        }
    }

    public void save() throws Exception {
        File prefsFile = new File(Util.getDataFolder(), "prefs.xml");
        FileOutputStream fos = new FileOutputStream(prefsFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
        writer.write(this.toXML());
        writer.flush();
        writer.close();
    }

    public boolean isShowHiddenFiles() {
        return this.isShowHiddenFilesEnabled;
    }

    public void setShowHiddenFiles(boolean isShowHiddenFilesEnabled) throws Exception {
        this.isShowHiddenFilesEnabled = isShowHiddenFilesEnabled;
        this.save();
    }

    public int getMimeSubtypeSortMode() {
        return this.mimeSubtypeSortMode;
    }

    public void setMimeSubtypeSortMode(int mimeSubtypeSortMode) throws Exception {
        this.mimeSubtypeSortMode = mimeSubtypeSortMode;
        this.save();
    }

    public boolean isShowTaxumId() {
        return this.isShowTaxumIdEnabled;
    }

    public void setShowTaxumId(boolean isShowTaxumIdEnabled) throws Exception {
        this.isShowTaxumIdEnabled = isShowTaxumIdEnabled;
        this.save();
    }

    public File getPrevClassifDir() {
        return this.prevClassifDir;
    }

    public void setPrevClassifDir(File prevClassifDir) throws Exception {
        this.prevClassifDir = prevClassifDir;
        this.save();
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) throws Exception {
        this.workingDir = workingDir;
        this.save();
    }

    public File getFileBrowserLocation() {
        return this.fileBrowserLoc;
    }

    public void setFileBrowserLocation(File fileBrowserLoc) throws Exception {
        this.fileBrowserLoc = fileBrowserLoc;
        this.save();
    }

    public boolean isFileBrowserOpened() {
        return this.isFileBrowserOpen;
    }

    public void setFileBrowserOpened(boolean isFileBrowserOpen) throws Exception {
        this.isFileBrowserOpen = isFileBrowserOpen;
        this.save();
    }

    public int getFileBrowserWidth() {
        return this.fileBrowserWidth;
    }

    public void setFileBrowserWidth(int width) throws Exception {
        this.fileBrowserWidth = width;
        this.save();
    }

    public String getPrevSelectedClassif() {
        return this.prevSelectedClassif;
    }

    public void setPrevSelectedClassif(String prevSelectedClassif) throws Exception {
        this.prevSelectedClassif = prevSelectedClassif;
        this.save();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) throws Exception {
        this.locale = locale;
        this.save();
    }

    public String getApplicationProfileView() {
        return this.applProfileView;
    }

    public void setApplicationProfileView(String applProfileView) throws Exception {
        this.applProfileView = applProfileView;
        this.save();
    }

    public String toXML() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        xml = xml + "<prefs>\n";
        xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("isShowHiddenFiles", this.isShowHiddenFilesEnabled + "") + "/>\n";
        xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("mimeSubtypeSortMode", this.mimeSubtypeSortMode + "") + "/>\n";
        xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("isShowTaxumId", this.isShowTaxumIdEnabled + "") + "/>\n";
        if (this.prevClassifDir != null) {
            xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("prevClassifDir", this.prevClassifDir + "") + "/>\n";
        }
        if (this.workingDir != null) {
            xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("workingDir", this.workingDir + "") + "/>\n";
        }
        if (this.fileBrowserLoc != null) {
            xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("fileBrowserLoc", this.fileBrowserLoc + "") + "/>\n";
        }
        xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("fileBrowserOpened", this.isFileBrowserOpen + "") + "/>\n";
        xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("fileBrowserWidth", this.fileBrowserWidth + "") + "/>\n";
        if (this.prevSelectedClassif != null) {
            xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("prevSelectedClassif", this.prevSelectedClassif + "") + "/>\n";
        }
        String lang = this.locale == Locale.FRENCH ? "fr" : (this.locale == Locale.ENGLISH ? "en" : "es");
        xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("locale", lang) + "/>\n";
        if (this.applProfileView != null) {
            xml = xml + "  <pref " + this.getKeyValueAsXmlAttributes("applProfView", this.applProfileView) + "/>\n";
        }
        xml = xml + "</prefs>\n";
        return xml;
    }

    public void fromXML(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setCoalescing(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(is);
        NodeList list = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            NamedNodeMap attr;
            Element e2;
            String tagName;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !"pref".equals(tagName = (e2 = (Element)node).getTagName().toLowerCase()) || (attr = e2.getAttributes()) == null) continue;
            Node keyNode = attr.getNamedItem("key");
            String key = keyNode == null ? null : keyNode.getNodeValue();
            Node valueNode = attr.getNamedItem("value");
            String string = value = valueNode == null ? null : valueNode.getNodeValue();
            if ("isShowHiddenFiles".equals(key)) {
                this.isShowHiddenFilesEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if ("mimeSubtypeSortMode".equals(key)) {
                this.mimeSubtypeSortMode = Integer.parseInt(value);
                continue;
            }
            if ("isShowTaxumId".equals(key)) {
                this.isShowTaxumIdEnabled = Boolean.parseBoolean(value);
                continue;
            }
            if ("prevClassifDir".equals(key)) {
                this.prevClassifDir = new File(value);
                continue;
            }
            if ("workingDir".equals(key)) {
                this.workingDir = new File(value);
                continue;
            }
            if ("fileBrowserLoc".equals(key)) {
                this.fileBrowserLoc = new File(value);
                continue;
            }
            if ("fileBrowserOpened".equals(key)) {
                this.isFileBrowserOpen = Boolean.parseBoolean(value);
                continue;
            }
            if ("fileBrowserWidth".equals(key)) {
                this.fileBrowserWidth = Integer.parseInt(value);
                continue;
            }
            if ("prevSelectedClassif".equals(key)) {
                this.prevSelectedClassif = value;
                continue;
            }
            if ("locale".equals(key)) {
                if ("fr".equals(value)) {
                    this.locale = Locale.FRENCH;
                    continue;
                }
                if ("en".equals(value)) {
                    this.locale = Locale.ENGLISH;
                    continue;
                }
                this.locale = new Locale("es");
                continue;
            }
            if (!"applProfView".equals(key)) continue;
            this.applProfileView = value;
        }
    }

    private Preferences() {
    }

    private String getKeyValueAsXmlAttributes(String key, String value) {
        return "key=\"" + key + "\" value=\"" + value + "\"";
    }
}

