/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.ComboBoxKeyListener;
import ca.licef.lompad.FormComponent;
import ca.licef.lompad.JTextFieldPopup;
import ca.licef.lompad.LangstringMediator;
import ca.licef.lompad.LocalizeJLabel;
import ca.licef.lompad.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.w3c.dom.Element;

class TaxonComponent
extends FormComponent {
    JPanel jPanelIdEntry;
    LocalizeJLabel jLabelId;
    LocalizeJLabel jLabelEntry;
    JTextFieldPopup jTextFieldId;
    JTextFieldPopup jTextFieldEntry;
    JComboBox jComboBoxLang;
    private boolean isFirst;

    public TaxonComponent(LangstringMediator mediator, boolean isFirst) {
        super(mediator);
        this.isFirst = isFirst;
        this.jPanelIdEntry = new JPanel();
        this.jPanelIdEntry.setLayout(new BoxLayout(this.jPanelIdEntry, 0));
        this.jPanelIdEntry.setOpaque(false);
        this.jLabelId = new LocalizeJLabel("9.2.2.1");
        this.jLabelId.setFont(new Font("Dialog", 0, 12));
        this.jLabelEntry = new LocalizeJLabel("9.2.2.2");
        this.jLabelEntry.setFont(this.jLabelId.getFont());
        this.jTextFieldId = new JTextFieldPopup();
        this.jTextFieldId.setMinimumSize(new Dimension(50, 25));
        this.jTextFieldId.setPreferredSize(new Dimension(50, 25));
        this.jTextFieldId.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldEntry = new JTextFieldPopup();
        this.jTextFieldEntry.setMinimumSize(new Dimension(50, 25));
        this.jTextFieldEntry.setPreferredSize(new Dimension(50, 25));
        this.jTextFieldEntry.setMaximumSize(new Dimension(1000, 25));
        if (this.isFirst) {
            this.jPanelIdEntry.add(Box.createHorizontalStrut(5));
            this.jPanelIdEntry.add(this.jLabelId);
            this.jPanelIdEntry.add(Box.createHorizontalStrut(5));
            this.jPanelIdEntry.add(this.jTextFieldId);
        } else {
            FontMetrics fm = this.getFontMetrics(this.jLabelId.getFont());
            this.jPanelIdEntry.add(Box.createHorizontalStrut(5 + fm.stringWidth(this.jLabelId.getText()) + 5 + 50));
        }
        this.jPanelIdEntry.add(Box.createHorizontalStrut(5));
        this.jPanelIdEntry.add(this.jLabelEntry);
        this.jPanelIdEntry.add(Box.createHorizontalStrut(5));
        this.jPanelIdEntry.add(this.jTextFieldEntry);
        this.jPanelGauche.add(this.jPanelIdEntry);
        this.jComboBoxLang = new JComboBox();
        this.jComboBoxLang.setEditable(true);
        this.jPanelControl.add(Box.createHorizontalStrut(5));
        this.jPanelControl.add(this.jComboBoxLang);
        this.jComboBoxLang.setFont(new Font("Dialog", 0, 10));
        this.jComboBoxLang.getEditor().getEditorComponent().addKeyListener(new ComboBoxKeyListener(this.jComboBoxLang));
        Object[] values = mediator.getValues();
        for (int i = 0; i < values.length; ++i) {
            this.jComboBoxLang.addItem(values[i]);
        }
        mediator.computePreferredSize(this.jComboBoxLang);
        this.jComboBoxLang.setPreferredSize(mediator.getComboBoxPreferredSize());
    }

    boolean isFilled() {
        return !this.jTextFieldEntry.getText().trim().equals("");
    }

    public void setEnabled(boolean b) {
        this.jTextFieldId.setEditable(b);
        this.jTextFieldId.setBackground(Color.white);
        this.jTextFieldEntry.setEditable(b);
        this.jTextFieldEntry.setBackground(Color.white);
        this.jComboBoxLang.setEnabled(b);
    }

    public void clear() {
        this.jTextFieldId.setText(null);
        this.jTextFieldEntry.setText(null);
    }

    public void setValues(String id, String entry, String lang) {
        if (this.isFirst) {
            this.jTextFieldId.setText(id);
            this.jTextFieldId.setCaretPosition(0);
        }
        this.jTextFieldEntry.setText(entry);
        this.jTextFieldEntry.setCaretPosition(0);
        this.jComboBoxLang.setSelectedItem(lang);
    }

    String toXML_Id(String key) {
        String xml = "";
        if (!this.jTextFieldId.getText().trim().equals("")) {
            xml = xml + "<" + Util.getTag(key + ".1") + ">" + Util.convertSpecialCharactersForXML(this.jTextFieldId.getText().trim()) + "</" + Util.getTag(key + ".1") + ">\n";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    String toXML_Entry() {
        String xml = "";
        if (!this.jTextFieldEntry.getText().trim().equals("")) {
            String lang = "";
            String selectedItem = (String)this.jComboBoxLang.getSelectedItem();
            if (selectedItem != null && !"".equals(selectedItem)) {
                lang = " language=\"" + selectedItem + "\"";
            }
            xml = "<string" + lang + ">" + Util.convertSpecialCharactersForXML(this.jTextFieldEntry.getText().trim()) + "</string>";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    void fromXML_Id(Element e2) {
        String value = e2.getFirstChild().getNodeValue();
        this.jTextFieldId.setText(value);
        this.jTextFieldId.setCaretPosition(0);
    }

    void fromXML_Entry(Element e2) {
        String value = e2.getFirstChild().getNodeValue();
        this.jTextFieldEntry.setText(value);
        this.jTextFieldEntry.setCaretPosition(0);
        this.jComboBoxLang.setSelectedItem(e2.getAttribute("language"));
    }

    String toHTML(String key) {
        String html = "";
        if (this.isFirst && !this.jTextFieldId.getText().trim().equals("")) {
            html = html + this.jTextFieldId.getText().trim();
        }
        if (!this.jTextFieldEntry.getText().trim().equals("")) {
            String lang = "";
            if (this.jComboBoxLang.getSelectedItem() != null && !"".equals(this.jComboBoxLang.getSelectedItem())) {
                lang = " (" + this.jComboBoxLang.getSelectedItem() + ")";
            }
            html = !html.equals("") ? html + ":" + this.jTextFieldEntry.getText().trim() + lang : this.jTextFieldEntry.getText().trim() + lang;
        }
        if (html.equals("")) {
            html = null;
        }
        return html;
    }
}

