/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.ControlValueMediator;
import ca.licef.lompad.FormComponent;
import ca.licef.lompad.IllegalTagException;
import ca.licef.lompad.OrderedValue;
import ca.licef.lompad.Util;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VocabularyComponent
extends FormComponent {
    JComboBox jComboBoxVocabulary;
    OrderedValue previousVocabulary;
    boolean isEditable;
    boolean isLomVocabulary;
    String source = "LOMv1.0";

    public VocabularyComponent(ControlValueMediator mediator, boolean isLomVocabulary, boolean isEditable) {
        super(mediator);
        this.isLomVocabulary = isLomVocabulary;
        this.jComboBoxVocabulary = new JComboBox();
        this.jComboBoxVocabulary.setFont(new Font("Dialog", 0, 11));
        this.jPanelGauche.add(this.jComboBoxVocabulary);
        this.isEditable = isEditable;
        this.jComboBoxVocabulary.setEditable(isEditable);
        if (mediator != null) {
            Enumeration e2 = mediator.getAvailableValues().elements();
            while (e2.hasMoreElements()) {
                Object obj = e2.nextElement();
                this.jComboBoxVocabulary.addItem(obj);
            }
            this.previousVocabulary = this.getSelectedValue();
        }
        SymAction lSymAction = new SymAction();
        this.jComboBoxVocabulary.addActionListener(lSymAction);
        if (this.isEditable) {
            this.jComboBoxVocabulary.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e2) {
                    VocabularyComponent.this.jComboBoxVocabulary.setSelectedItem(VocabularyComponent.this.jComboBoxVocabulary.getEditor().getItem());
                }
            });
        }
    }

    @Override
    boolean isFilled() {
        return this.getSelectedValue().value != null && !this.getSelectedValue().value.toString().trim().equals("");
    }

    @Override
    public void setEnabled(boolean b) {
        this.jComboBoxVocabulary.setEnabled(b);
    }

    void jComboBoxVocabulary_actionPerformed() {
        if (this.mediator != null && !this.getSelectedValue().equals(this.previousVocabulary)) {
            ((ControlValueMediator)this.mediator).comboBoxValuePerformed(this);
            this.previousVocabulary = this.getSelectedValue();
        }
    }

    public JComboBox getJComboBox() {
        return this.jComboBoxVocabulary;
    }

    public OrderedValue getSelectedValue() {
        Object obj = this.jComboBoxVocabulary.getSelectedItem();
        OrderedValue v = null;
        v = obj instanceof OrderedValue ? (OrderedValue)obj : new OrderedValue((String)obj, -1, false);
        return v;
    }

    public Object getMatchedValue(String s) {
        for (int i = 0; i < this.jComboBoxVocabulary.getItemCount(); ++i) {
            Object o = this.jComboBoxVocabulary.getItemAt(i);
            if (!((OrderedValue)o).toString().equals(s)) continue;
            return o;
        }
        return s;
    }

    public OrderedValue getPreviousSelectedValue() {
        return this.previousVocabulary;
    }

    @Override
    String toXML(String key) {
        String xml = null;
        if (this.isFilled()) {
            if (this.isLomVocabulary) {
                String value = null;
                value = this.getSelectedValue().value.toString();
                if (value.startsWith("x")) {
                    this.source = Util.getProfileVocabularySource(value.substring(1, value.indexOf("-")));
                }
                value = Util.getXMLVocabulary(value);
                xml = "<source>" + this.source + "</source>\n" + "<value>" + value + "</value>\n";
            } else {
                xml = Util.convertSpecialCharactersForXML(this.getSelectedValue().toString());
            }
        }
        return xml;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void fromXML(String path, Element e2, Hashtable tableImportXML, boolean firstField, List<String> observations) {
        if (this.isLomVocabulary) {
            NodeList listSrc = e2.getElementsByTagNameNS("http://ltsc.ieee.org/xsd/LOM", "source");
            Element childSrc = (Element)listSrc.item(0);
            String source = childSrc.getFirstChild().getNodeValue();
            NodeList list = e2.getElementsByTagNameNS("http://ltsc.ieee.org/xsd/LOM", "value");
            if (list.getLength() <= 0) return;
            Element child = (Element)list.item(0);
            String value = child.getFirstChild().getNodeValue().trim();
            try {
                if (child.getFirstChild() == null) return;
                int pos = Util.getPosVocabulary(value, !source.equals("LOMv1.0"));
                Integer index = (Integer)tableImportXML.remove(new Integer(pos));
                if (index == null) {
                    return;
                }
                this.jComboBoxVocabulary.setSelectedIndex(index);
                Enumeration en = tableImportXML.keys();
                while (en.hasMoreElements()) {
                    Integer i = (Integer)en.nextElement();
                    int val = (Integer)tableImportXML.get(i);
                    if (firstField) {
                        --val;
                    }
                    if (i > pos) {
                        --val;
                    }
                    tableImportXML.put(i, new Integer(val));
                }
                return;
            }
            catch (IllegalTagException illegalTagException) {
                return;
            }
        } else {
            if (e2.getFirstChild() == null) return;
            this.jComboBoxVocabulary.setSelectedItem(this.getMatchedValue(e2.getFirstChild().getNodeValue().trim()));
        }
    }

    @Override
    String toHTML(String key) {
        String html = null;
        if (this.isFilled()) {
            html = this.isLomVocabulary ? Util.getVocabulary(this.getSelectedValue().value.toString()) + "<br>" : this.getSelectedValue() + "<br>";
        }
        return html;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == VocabularyComponent.this.jComboBoxVocabulary) {
                VocabularyComponent.this.jComboBoxVocabulary_actionPerformed();
            }
        }
    }
}

