/*
 * Decompiled with CFR 0.152.
 */
package ca.licef.lompad;

import ca.licef.lompad.ControlValueMediator;
import ca.licef.lompad.ExternalVocabularyComponent;
import ca.licef.lompad.FormComponent;
import ca.licef.lompad.FormContainer;
import ca.licef.lompad.JPanelForm;
import ca.licef.lompad.Util;
import ca.licef.lompad.VocabularyComponent;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VocabularyForm
extends FormContainer {
    Object[] values = null;
    Object[] exclusiveValues = null;
    boolean isLomVocabulary = true;
    boolean isEditable = false;
    Hashtable tableImportXML;
    String currentXML;
    boolean isControlValueMediatorNeeded = true;

    public VocabularyForm(String title, boolean isLine, boolean isMultipleContainer, Object[] exclusiveValues, boolean isLomVocabulary) {
        super(title, isLine, isMultipleContainer);
        this.exclusiveValues = exclusiveValues;
        this.isLomVocabulary = isLomVocabulary;
        this.values = Util.initVocabularyValues(title);
        this.mediator = new ControlValueMediator(this, this.values, exclusiveValues);
    }

    public VocabularyForm(String title, boolean isLine, boolean isMultipleContainer, Object[] values, Object[] exclusiveValues, boolean isLomVocabulary) {
        super(title, isLine, isMultipleContainer);
        this.values = values;
        this.exclusiveValues = exclusiveValues;
        this.isLomVocabulary = isLomVocabulary;
        this.mediator = new ControlValueMediator(this, values, exclusiveValues);
    }

    void setEditable(boolean b) {
        this.isEditable = b;
    }

    @Override
    public void preUpdateVocabularies() {
        this.currentXML = this.toXML(this.title);
    }

    @Override
    public void updateVocabularies() {
        if (!this.isLomVocabulary) {
            return;
        }
        this.values = Util.initVocabularyValues(this.title);
        this.mediator = new ControlValueMediator(this, this.values, this.exclusiveValues);
        this.vComponents.clear();
        this.jPanelGaucheContainer.removeAll();
        this.addFormContent();
        if (this.currentXML != null) {
            this.currentXML = "<vocabularies xmlns=\"http://ltsc.ieee.org/xsd/LOM\">" + this.currentXML + "</vocabularies>";
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setCoalescing(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new ByteArrayInputStream(this.currentXML.getBytes()));
                NodeList list = document.getDocumentElement().getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element e2 = (Element)node;
                    this.fromXML(null, e2, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    void addFormContent() {
        FormComponent c = this.isControlValueMediatorNeeded ? new VocabularyComponent((ControlValueMediator)this.mediator, this.isLomVocabulary, this.isEditable) : new ExternalVocabularyComponent();
        c.setMinimumSize(new Dimension(10, 25));
        c.setPreferredSize(new Dimension(10, 25));
        c.setMaximumSize(new Dimension(2000, 25));
        this.addComponent(c);
        if (this.isControlValueMediatorNeeded) {
            this.mediator.buttonAddComponentPerformed(c);
        }
    }

    void removeFirstComponent() {
        FormComponent c = (FormComponent)this.jPanelGaucheContainer.getComponent(0);
        this.jPanelGaucheContainer.remove(c);
        if (this.isMultipleContainer) {
            c = (FormComponent)((FormContainer)c).jPanelGaucheContainer.getComponent(0);
        }
        this.vComponents.removeElement(c);
    }

    @Override
    String toXML(String key) {
        String xml = "";
        Enumeration e2 = this.vComponents.elements();
        while (e2.hasMoreElements()) {
            FormComponent c = (FormComponent)e2.nextElement();
            String res = c.toXML(key);
            if (res == null || "".equals(res.trim())) continue;
            xml = xml + "<" + Util.getTag(key) + ">" + res.trim() + "</" + Util.getTag(key) + ">\n";
        }
        if (xml.equals("")) {
            xml = null;
        }
        return xml;
    }

    @Override
    void fromXML(String path, Element e2, List<String> observations) {
        if (e2.getFirstChild() == null) {
            return;
        }
        boolean firstField = false;
        FormComponent c = (FormComponent)this.vComponents.firstElement();
        this.isControlValueMediatorNeeded = this.isControlValueMediatorNeeded(e2);
        if (this.isFilled()) {
            if (!this.isMultipleContainer) {
                return;
            }
            this.addFormContent();
            c = (FormComponent)this.vComponents.lastElement();
        } else {
            if (this.isLomVocabulary) {
                this.tableImportXML = new Hashtable();
                for (int i = 1; i < this.values.length; ++i) {
                    this.tableImportXML.put(new Integer(i), new Integer(i));
                }
                if (!this.isControlValueMediatorNeeded) {
                    this.removeFirstComponent();
                    c = new ExternalVocabularyComponent();
                    c.setMinimumSize(new Dimension(10, 25));
                    c.setPreferredSize(new Dimension(10, 25));
                    c.setMaximumSize(new Dimension(2000, 25));
                    this.addComponent(c);
                    if (this.isMultipleContainer) {
                        this.setEnabledButtonAdd(true);
                    }
                }
                firstField = true;
            }
            c = (FormComponent)this.vComponents.firstElement();
        }
        if (this.isControlValueMediatorNeeded) {
            ((VocabularyComponent)c).fromXML(path, e2, this.tableImportXML, firstField, observations);
        } else {
            ((ExternalVocabularyComponent)c).fromXML(path, e2, firstField, observations);
        }
        this.isControlValueMediatorNeeded = true;
    }

    private boolean isControlValueMediatorNeeded(Element e2) {
        if (!this.isLomVocabulary) {
            return true;
        }
        NodeList listSrc = e2.getElementsByTagNameNS("http://ltsc.ieee.org/xsd/LOM", "source");
        if (listSrc.getLength() == 0) {
            return false;
        }
        Element childSrc = (Element)listSrc.item(0);
        String source = childSrc.getFirstChild().getNodeValue();
        if (source.equals("LOMv1.0")) {
            return true;
        }
        String profile = Util.getExternalProfileFromVocabularySource(source);
        String selectedProfile = JPanelForm.instance.getCurrentSelectedProfile();
        return profile != null && profile.equals(selectedProfile);
    }

    @Override
    String toHTML(String key) {
        return this.toHTMLRow(key);
    }
}

