/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Collection;
import java.util.HashSet;

public class CollectionGraph
extends GraphBase {
    private Capabilities cgCapabilities = new Capabilities(){

        @Override
        public boolean sizeAccurate() {
            return true;
        }

        @Override
        public boolean addAllowed() {
            return true;
        }

        @Override
        public boolean addAllowed(boolean everyTriple) {
            return true;
        }

        @Override
        public boolean deleteAllowed() {
            return true;
        }

        @Override
        public boolean deleteAllowed(boolean everyTriple) {
            return true;
        }

        @Override
        public boolean iteratorRemoveAllowed() {
            return false;
        }

        @Override
        public boolean canBeEmpty() {
            return true;
        }

        @Override
        public boolean findContractSafe() {
            return true;
        }

        @Override
        public boolean handlesLiteralTyping() {
            return false;
        }
    };
    private Collection<Triple> triples;

    public CollectionGraph() {
        this(new HashSet<Triple>());
    }

    public CollectionGraph(Collection<Triple> triples) {
        this.triples = triples;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        return WrappedIterator.createNoRemove(this.triples.iterator()).filterKeep(new MatchFilter(m));
    }

    @Override
    public void performAdd(Triple t) {
        if (!this.triples.contains(t)) {
            this.triples.add(t);
        }
    }

    @Override
    public void performDelete(Triple t) {
        this.triples.remove(t);
    }

    @Override
    public Capabilities getCapabilities() {
        return this.cgCapabilities;
    }

    private class MatchFilter
    extends Filter<Triple> {
        TripleMatch m;

        public MatchFilter(TripleMatch m) {
            if (m == null) {
                throw new IllegalArgumentException("Match must not be null");
            }
            this.m = m;
        }

        @Override
        public boolean accept(Triple t) {
            if (t == null) {
                throw new IllegalArgumentException("triple must not be null");
            }
            return this.matches(t.getMatchSubject(), this.m.getMatchSubject()) && this.matches(t.getMatchPredicate(), this.m.getMatchPredicate()) && this.matches(t.getMatchObject(), this.m.getMatchObject());
        }

        private boolean isWild(Node n) {
            return n == null || Node.ANY.equals(n);
        }

        private boolean matches(Node t, Node m) {
            return this.isWild(m) || this.isWild(t) || m.equals(t);
        }
    }
}

