/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.riot.other.GLib;

public class GraphView
extends GraphBase
implements Sync {
    private final DatasetGraph dsg;
    private final Node gn;

    public static GraphView createDefaultGraph(DatasetGraph dsg) {
        return new GraphView(dsg, Quad.defaultGraphNodeGenerated);
    }

    public static GraphView createNamedGraph(DatasetGraph dsg, Node graphIRI) {
        return new GraphView(dsg, graphIRI);
    }

    protected GraphView(DatasetGraph dsg, Node gn) {
        this.dsg = dsg;
        this.gn = gn;
    }

    public Node getGraphName() {
        return this.gn == Quad.defaultGraphNodeGenerated ? null : this.gn;
    }

    public DatasetGraph getDataset() {
        return this.dsg;
    }

    protected final boolean isDefaultGraph() {
        return GraphView.isDefaultGraph(this.gn);
    }

    protected final boolean isUnionGraph() {
        return GraphView.isUnionGraph(this.gn);
    }

    protected static final boolean isDefaultGraph(Node gn) {
        return gn == null || Quad.isDefaultGraph(gn);
    }

    protected static final boolean isUnionGraph(Node gn) {
        return Quad.isUnionGraph(gn);
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return new PrefixMappingImpl();
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        if (m == null) {
            m = Triple.ANY;
        }
        Node s = m.getMatchSubject();
        Node p = m.getMatchPredicate();
        Node o = m.getMatchObject();
        return this.graphBaseFind(s, p, o);
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Node s, Node p, Node o) {
        Node g = GraphView.graphNode(this.gn);
        Iter<Triple> iter = GLib.quads2triples(this.dsg.find(g, s, p, o));
        if (Quad.isUnionGraph(this.gn)) {
            return this.graphUnionFind(s, p, o);
        }
        return WrappedIterator.createNoRemove(iter);
    }

    private static Node graphNode(Node gn) {
        return gn == null ? Quad.defaultGraphNodeGenerated : gn;
    }

    protected ExtendedIterator<Triple> graphUnionFind(Node s, Node p, Node o) {
        Node g = GraphView.graphNode(this.gn);
        Iterator<Quad> iterQuads = this.getDataset().find(g, s, p, o);
        Iterator<Triple> iter = GLib.quads2triples(iterQuads);
        iter = Iter.distinct(iter);
        return WrappedIterator.createNoRemove(iter);
    }

    @Override
    public void performAdd(Triple t) {
        Node g = GraphView.graphNode(this.gn);
        if (Quad.isUnionGraph(g)) {
            throw new GraphViewException("Can't update the default union graph of a dataset");
        }
        Node s = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        this.dsg.add(g, s, p, o);
    }

    @Override
    public void performDelete(Triple t) {
        Node g = GraphView.graphNode(this.gn);
        if (Quad.isUnionGraph(g)) {
            throw new GraphViewException("Can't update the default union graph of a dataset");
        }
        Node s = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        this.dsg.delete(g, s, p, o);
    }

    @Override
    public void sync() {
        SystemARQ.sync(this.dsg);
    }

    static class GraphViewException
    extends JenaException {
        public GraphViewException() {
        }

        public GraphViewException(String message) {
            super(message);
        }

        public GraphViewException(Throwable cause) {
            super(cause);
        }

        public GraphViewException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

