/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphWrapper;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.util.Context;

public class QueryEngineFactoryWrapper
implements QueryEngineFactory {
    private static QueryEngineFactory instance = new QueryEngineFactoryWrapper();

    public static QueryEngineFactory get() {
        return instance;
    }

    @Override
    public boolean accept(Query query2, DatasetGraph dsg, Context context) {
        if (!(dsg instanceof DatasetGraphWrapper)) {
            return false;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(query2, dsg2, context).accept(query2, dsg2, context);
    }

    @Override
    public Plan create(Query query2, DatasetGraph dsg, Binding inputBinding, Context context) {
        if (!(dsg instanceof DatasetGraphWrapper)) {
            return null;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(query2, dsg2, context).create(query2, dsg2, inputBinding, context);
    }

    @Override
    public boolean accept(Op op, DatasetGraph dsg, Context context) {
        if (!(dsg instanceof DatasetGraphWrapper)) {
            return false;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(op, dsg2, context).accept(op, dsg2, context);
    }

    @Override
    public Plan create(Op op, DatasetGraph dsg, Binding inputBinding, Context context) {
        if (!(dsg instanceof DatasetGraphWrapper)) {
            return null;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(op, dsg2, context).create(op, dsg2, inputBinding, context);
    }
}

