/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;

public class AggCountVarDistinct
extends AggregatorBase {
    private Expr expr;

    public AggCountVarDistinct(Expr expr) {
        this.expr = expr;
    }

    @Override
    public Aggregator copy(Expr expr) {
        return new AggCountVarDistinct(expr);
    }

    @Override
    public String toString() {
        return "count(distinct " + this.expr + ")";
    }

    @Override
    public String toPrefixString() {
        return "(count distinct " + WriterExpr.asString(this.expr) + ")";
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCountVarDistinct();
    }

    @Override
    public Expr getExpr() {
        return this.expr;
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.expr.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AggCountVarDistinct)) {
            return false;
        }
        AggCountVarDistinct agg = (AggCountVarDistinct)other;
        return agg.getExpr().equals(this.getExpr());
    }

    class AccCountVarDistinct
    extends AccumulatorDistinctExpr {
        private long count;

        public AccCountVarDistinct() {
            super(AggCountVarDistinct.this.expr);
            this.count = 0L;
        }

        @Override
        public void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getValue() {
            return this.getAccValue();
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

