/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementData;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementExists;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementMinus;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementNotExists;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;

public class ElementWalker {
    public static void walk(Element el, ElementVisitor visitor) {
        ElementWalker.walk(el, visitor, null, null);
    }

    public static void walk(Element el, ElementVisitor visitor, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
        Walker w = new Walker(visitor, beforeVisitor, afterVisitor);
        el.visit(w);
    }

    protected static void walk$(Element el, Walker walker) {
        el.visit(walker);
    }

    public static class Walker
    implements ElementVisitor {
        protected final ElementVisitor proc;
        protected final ElementVisitor beforeVisitor;
        protected final ElementVisitor afterVisitor;

        protected Walker(ElementVisitor visitor, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
            this.proc = visitor;
            this.beforeVisitor = beforeVisitor;
            this.afterVisitor = afterVisitor;
        }

        private void before(Element elt) {
            if (this.beforeVisitor != null) {
                elt.visit(this.beforeVisitor);
            }
        }

        private void after(Element elt) {
            if (this.afterVisitor != null) {
                elt.visit(this.afterVisitor);
            }
        }

        @Override
        public void visit(ElementTriplesBlock el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementFilter el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementAssign el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementBind el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementData el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementUnion el) {
            this.before(el);
            for (Element e2 : el.getElements()) {
                e2.visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementGroup el) {
            this.before(el);
            for (Element e2 : el.getElements()) {
                e2.visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementOptional el) {
            this.before(el);
            if (el.getOptionalElement() != null) {
                el.getOptionalElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementDataset el) {
            this.before(el);
            if (el.getPatternElement() != null) {
                el.getPatternElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementNamedGraph el) {
            this.before(el);
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementService el) {
            this.before(el);
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementExists el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementNotExists el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementMinus el) {
            this.before(el);
            if (el.getMinusElement() != null) {
                el.getMinusElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementSubQuery el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementPathBlock el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }
    }
}

