/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class OneToManyMap<From, To>
implements Map<From, To> {
    private Map<From, List<To>> m_table = new HashMap<From, List<To>>();

    public OneToManyMap() {
    }

    public OneToManyMap(OneToManyMap<From, To> map) {
        for (From key : map.keySet()) {
            Iterator<To> j = map.getAll(key);
            while (j.hasNext()) {
                this.put(key, j.next());
            }
        }
    }

    @Override
    public void clear() {
        this.m_table.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_table.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (List<To> x : this.m_table.values()) {
            if (!x.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object key, Object value) {
        Iterator<To> i = this.getAll(key);
        while (i.hasNext()) {
            if (!i.next().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<From, To>> entrySet() {
        Set<Map.Entry<From, To>> s = CollectionFactory.createHashedSet();
        for (From key : this.m_table.keySet()) {
            List<To> values = this.m_table.get(key);
            ListIterator<To> e1 = values.listIterator();
            while (e1.hasNext()) {
                s.add(new Entry(key, e1.next()));
            }
        }
        return s;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Map && this.entrySet().equals(((Map)o).entrySet());
    }

    @Override
    public To get(Object key) {
        List<To> entry = this.m_table.get(key);
        if (entry != null && !entry.isEmpty()) {
            return entry.get(0);
        }
        return null;
    }

    public Iterator<To> getAll(Object key) {
        List<To> entry = this.m_table.get(key);
        return entry != null ? entry.iterator() : new NullIterator();
    }

    @Override
    public int hashCode() {
        int hc = 0;
        Iterator<Map.Entry<From, To>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            hc ^= i.next().hashCode();
        }
        return hc;
    }

    @Override
    public boolean isEmpty() {
        return this.m_table.isEmpty();
    }

    @Override
    public Set<From> keySet() {
        return this.m_table.keySet();
    }

    @Override
    public To put(From key, To value) {
        List<To> entries = this.m_table.get(key);
        if (entries == null) {
            entries = new ArrayList<To>();
        }
        entries.add(value);
        this.m_table.put(key, entries);
        return null;
    }

    @Override
    public void putAll(Map<? extends From, ? extends To> m) {
        boolean many = m instanceof OneToManyMap;
        for (From key : m.keySet()) {
            if (many) {
                OneToManyMap Z;
                OneToManyMap X = Z = (OneToManyMap)m;
                Iterator<To> j = X.getAll(key);
                while (j.hasNext()) {
                    this.put(key, j.next());
                }
                continue;
            }
            this.put(key, m.get(key));
        }
    }

    @Override
    public To remove(Object key) {
        this.m_table.remove(key);
        return null;
    }

    public void remove(Object key, Object value) {
        List<To> entries = this.m_table.get(key);
        if (entries != null) {
            entries.remove(value);
            if (entries.isEmpty()) {
                this.m_table.remove(key);
            }
        }
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<From> i = this.m_table.keySet().iterator();
        while (i.hasNext()) {
            size += this.m_table.get(i.next()).size();
        }
        return size;
    }

    @Override
    public Collection<To> values() {
        Set s = CollectionFactory.createHashedSet();
        Iterator<From> e2 = this.m_table.keySet().iterator();
        while (e2.hasNext()) {
            s.addAll((Collection)this.m_table.get(e2.next()));
        }
        return s;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("OneToManyMap{");
        String sep = "";
        for (From key : this.keySet()) {
            buf.append(sep);
            buf.append(key);
            buf.append("={");
            String sep1 = "";
            Iterator<To> j = this.getAll(key);
            while (j.hasNext()) {
                buf.append(sep1);
                buf.append(j.next());
                sep1 = ",";
            }
            buf.append("}");
            sep = ",";
        }
        buf.append("}");
        return buf.toString();
    }

    public static class Entry<From, To>
    implements Map.Entry<From, To> {
        private From m_key = null;
        private To m_value = null;

        private Entry(From key, To value) {
            this.m_key = key;
            this.m_value = value;
        }

        @Override
        public boolean equals(Object x) {
            if (x instanceof Map.Entry) {
                Map.Entry e1 = (Map.Entry)x;
                return (e1.getKey() == null ? this.m_key == null : e1.getKey().equals(this.m_key)) && (e1.getValue() == null ? this.m_value == null : e1.getValue().equals(this.m_value));
            }
            return false;
        }

        @Override
        public From getKey() {
            return this.m_key;
        }

        @Override
        public To getValue() {
            return this.m_value;
        }

        @Override
        public To setValue(To value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

