/*
 * Decompiled with CFR 0.152.
 */
package licef;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.Vector;

public class StringUtil {
    public static final char NEW_LINE = '\n';

    public static String capitalize(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        if (text.length() == 1) {
            return text.substring(0, 1).toUpperCase();
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }

    public static String insertLeading(char c, int numberOfChars, String str2) {
        StringBuffer result = new StringBuffer(numberOfChars);
        int n = numberOfChars - str2.length();
        for (int i = 0; i < n; ++i) {
            result.append(c);
        }
        result.append(str2);
        return result.toString();
    }

    public static String join(Object[] strToJoin, char limiter, char delimiter) {
        int i;
        StringBuffer str2 = new StringBuffer();
        for (i = 0; i < strToJoin.length - 1; ++i) {
            str2.append(limiter + strToJoin[i].toString() + limiter + delimiter);
        }
        str2.append(limiter + strToJoin[i].toString() + limiter);
        return str2.toString();
    }

    public static String join(Object[] strToJoin, char delimiter) {
        int i;
        if (strToJoin == null || strToJoin.length == 0) {
            return "";
        }
        StringBuffer str2 = new StringBuffer();
        for (i = 0; i < strToJoin.length - 1; ++i) {
            if (strToJoin[i] != null) {
                str2.append(strToJoin[i].toString());
            }
            str2.append(delimiter);
        }
        if (strToJoin[i] != null) {
            str2.append(strToJoin[i].toString());
        }
        return str2.toString();
    }

    public static String[] split(String strToSplit, char delimiter) {
        Vector<String> words = new Vector<String>();
        int fromNdx = 0;
        int toNdx = -1;
        String word = null;
        int strLength = strToSplit.length();
        while (fromNdx < strLength) {
            toNdx = strToSplit.indexOf(delimiter, fromNdx);
            if (toNdx == -1) {
                toNdx = strLength;
            }
            word = strToSplit.substring(fromNdx, toNdx);
            words.addElement(word);
            fromNdx = toNdx + 1;
        }
        if (words.size() == 0) {
            return new String[]{strToSplit};
        }
        Object[] wordArray = new String[words.size()];
        words.copyInto(wordArray);
        return wordArray;
    }

    public static String escapeHTMLEntities(String strToConvert) {
        StringBuffer str2 = new StringBuffer(strToConvert.length());
        for (int i = 0; i < strToConvert.length(); ++i) {
            char c = strToConvert.charAt(i);
            if (c == '\"') {
                str2.append("&quot;");
                continue;
            }
            if (c == '&') {
                str2.append("&amp;");
                continue;
            }
            if (c == '<') {
                str2.append("&lt;");
                continue;
            }
            if (c == '>') {
                str2.append("&gt;");
                continue;
            }
            str2.append(c);
        }
        return str2.toString();
    }

    public static String getFileExtension(String filename) {
        int lastIndexOfDot = filename.lastIndexOf(".");
        if (lastIndexOfDot != -1 && lastIndexOfDot + 1 < filename.length()) {
            return filename.substring(lastIndexOfDot + 1);
        }
        return null;
    }

    public static boolean isEmpty(String str2) {
        if (str2 == null) {
            return true;
        }
        if (str2.length() == 0) {
            return true;
        }
        char[] chars = str2.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static String escapeSingleQuotes(String str2) {
        return str2.replaceAll("'", "\\\\'");
    }

    public static String getEncodedString(String str2) {
        try {
            return URLEncoder.encode(str2, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            return str2;
        }
    }

    public static int occurrenceOf(String pattern, String str2) {
        int len = pattern.length();
        int result = 0;
        if (len > 0) {
            int index = str2.indexOf(pattern);
            while (index != -1) {
                ++result;
                index = str2.indexOf(pattern, index + len);
            }
        }
        return result;
    }

    public static String unquote(String str2) {
        int length;
        int n = length = str2 == null ? -1 : str2.length();
        if (str2 == null || length == 0) {
            return str2;
        }
        if (length > 1 && str2.charAt(0) == '\"' && str2.charAt(length - 1) == '\"') {
            str2 = str2.substring(1, length - 1);
        }
        return str2;
    }

    public static String removeAccents(String str2) {
        if (str2 == null || str2.length() == 0) {
            return str2;
        }
        return Normalizer.normalize(str2, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }
}

