/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import net.sf.saxon.Configuration;
import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class ComplexContentProcessor
implements EventIterator {
    private Configuration config;
    private EventIterator base;
    private PullEvent[] startEventStack;
    private int depth;
    private NodeInfo pendingTextNode;
    private boolean pendingTextNodeIsMutable;
    private boolean prevAtomic = false;
    private PullEvent pendingOutput = null;

    public ComplexContentProcessor(Configuration config, EventIterator base) {
        this.config = config;
        this.base = EventStackIterator.flatten(base);
        this.startEventStack = new PullEvent[20];
        this.depth = 0;
    }

    public PullEvent next() throws XPathException {
        if (this.pendingOutput != null) {
            PullEvent next = this.pendingOutput;
            this.pendingOutput = null;
            return next;
        }
        return this.advance();
    }

    private PullEvent advance() throws XPathException {
        block3: while (true) {
            FastStringBuffer sb;
            Orphan o;
            FastStringBuffer sb2;
            NodeInfo next;
            PullEvent e2;
            if (this.depth == 0) {
                e2 = this.base.next();
                if (e2 instanceof StartElementEvent) {
                    this.push(e2);
                } else if (e2 instanceof StartDocumentEvent) {
                    this.push(e2);
                }
                return e2;
            }
            e2 = this.base.next();
            if (e2 instanceof StartElementEvent) {
                this.prevAtomic = false;
                this.push(e2);
                if (this.pendingTextNode != null) {
                    this.pendingOutput = e2;
                    next = this.pendingTextNode;
                    this.pendingTextNode = null;
                    return next;
                }
                return e2;
            }
            if (e2 instanceof StartDocumentEvent) {
                this.prevAtomic = false;
                this.push(e2);
                if (this.pendingTextNode == null) continue;
                this.pendingOutput = e2;
                next = this.pendingTextNode;
                this.pendingTextNode = null;
                return next;
            }
            if (e2 instanceof EndElementEvent) {
                this.prevAtomic = false;
                this.pop();
                if (this.pendingTextNode != null) {
                    this.pendingOutput = e2;
                    next = this.pendingTextNode;
                    this.pendingTextNode = null;
                    return next;
                }
                return e2;
            }
            if (e2 instanceof EndDocumentEvent) {
                this.prevAtomic = false;
                this.pop();
                if (this.pendingTextNode != null) {
                    this.pendingOutput = e2;
                    next = this.pendingTextNode;
                    this.pendingTextNode = null;
                    return next;
                }
                return e2;
            }
            if (e2 instanceof NodeInfo) {
                this.prevAtomic = false;
                switch (((NodeInfo)e2).getNodeKind()) {
                    case 3: {
                        if (this.pendingTextNode == null) {
                            this.pendingTextNode = (NodeInfo)e2;
                            this.pendingTextNodeIsMutable = false;
                            continue block3;
                        }
                        if (this.pendingTextNodeIsMutable) {
                            sb2 = (FastStringBuffer)((Orphan)this.pendingTextNode).getStringValueCS();
                            sb2.append(((NodeInfo)e2).getStringValueCS());
                            continue block3;
                        }
                        o = new Orphan(this.config);
                        o.setNodeKind((short)3);
                        sb = new FastStringBuffer(40);
                        sb.append(this.pendingTextNode.getStringValueCS());
                        sb.append(((NodeInfo)e2).getStringValueCS());
                        o.setStringValue(sb);
                        this.pendingTextNode = o;
                        this.pendingTextNodeIsMutable = true;
                        continue block3;
                    }
                }
                if (this.pendingTextNode != null) {
                    this.pendingOutput = e2;
                    next = this.pendingTextNode;
                    this.pendingTextNode = null;
                    return next;
                }
                return e2;
            }
            if (!(e2 instanceof AtomicValue)) break;
            if (this.prevAtomic) {
                sb2 = (FastStringBuffer)((Orphan)this.pendingTextNode).getStringValueCS();
                sb2.append(' ');
                sb2.append(((AtomicValue)e2).getStringValueCS());
                continue;
            }
            if (this.pendingTextNode != null) {
                this.prevAtomic = true;
                if (this.pendingTextNodeIsMutable) {
                    sb2 = (FastStringBuffer)((Orphan)this.pendingTextNode).getStringValueCS();
                    sb2.append(((AtomicValue)e2).getStringValueCS());
                    continue;
                }
                o = new Orphan(this.config);
                o.setNodeKind((short)3);
                sb = new FastStringBuffer(40);
                sb.append(this.pendingTextNode.getStringValueCS());
                sb.append(((AtomicValue)e2).getStringValueCS());
                o.setStringValue(sb);
                this.pendingTextNode = o;
                this.pendingTextNodeIsMutable = true;
                continue;
            }
            this.prevAtomic = true;
            o = new Orphan(this.config);
            o.setNodeKind((short)3);
            sb = new FastStringBuffer(40);
            sb.append(((AtomicValue)e2).getStringValueCS());
            o.setStringValue(sb);
            this.pendingTextNode = o;
            this.pendingTextNodeIsMutable = true;
        }
        throw new AssertionError((Object)"Unknown event");
    }

    private void push(PullEvent p) {
        if (this.depth >= this.startEventStack.length - 1) {
            PullEvent[] b2 = new PullEvent[this.depth * 2];
            System.arraycopy(this.startEventStack, 0, b2, 0, this.startEventStack.length);
            this.startEventStack = b2;
        }
        if (p instanceof StartElementEvent) {
            int retained = 0;
            int[] nsp = ((StartElementEvent)p).getLocalNamespaces();
            block0: for (int nspi = 0; nspi < nsp.length && nsp[nspi] != -1; ++nspi) {
                ++retained;
                for (int i = this.depth - 1; i >= 0; --i) {
                    PullEvent q = this.startEventStack[i];
                    if (!(q instanceof StartElementEvent)) continue;
                    int[] nsq = ((StartElementEvent)q).getLocalNamespaces();
                    for (int nsqi = 0; nsqi < nsq.length; ++nsqi) {
                        if (nsp[nspi] == nsq[nsqi]) {
                            nsp[nspi] = -1;
                            --retained;
                            continue block0;
                        }
                        if (nsp[nspi] >> 16 == nsq[nsqi] >> 16) continue block0;
                    }
                }
            }
            if (retained < nsp.length) {
                int[] nsr = new int[retained];
                int nsri = 0;
                for (int nspi = 0; nspi < nsp.length; ++nspi) {
                    if (nsp[nspi] == -1) continue;
                    nsr[nsri++] = nsp[nspi];
                    if (nsri == retained) break;
                }
                ((StartElementEvent)p).setLocalNamespaces(nsr);
            }
        }
        this.startEventStack[this.depth++] = p;
        this.prevAtomic = false;
    }

    private void pop() {
        --this.depth;
        this.prevAtomic = false;
    }

    public boolean isFlatSequence() {
        return true;
    }
}

