/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public final class InstanceOfExpression
extends UnaryExpression {
    ItemType targetType;
    int targetCardinality;

    public InstanceOfExpression(Expression source, SequenceType target) {
        super(source);
        this.targetType = target.getPrimaryType();
        if (this.targetType == null) {
            throw new IllegalArgumentException("Primary item type must not be null");
        }
        this.targetCardinality = target.getCardinality();
    }

    public ItemType getRequiredItemType() {
        return this.targetType;
    }

    public int getRequiredCardinality() {
        return this.targetCardinality;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        if (this.operand instanceof Literal) {
            return Literal.makeLiteral((AtomicValue)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()));
        }
        if (Cardinality.subsumes(this.targetCardinality, this.operand.getCardinality())) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            int relation = th.relationship(this.operand.getItemType(th), this.targetType);
            if (relation == 0 || relation == 2) {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            if (!(relation != 4 || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(this.operand.getCardinality()))) {
                return Literal.makeLiteral(BooleanValue.FALSE);
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        if (Cardinality.subsumes(this.targetCardinality, this.operand.getCardinality())) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            int relation = th.relationship(this.operand.getItemType(th), this.targetType);
            if (relation == 0 || relation == 2) {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            if (!(relation != 4 || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(this.operand.getCardinality()))) {
                return Literal.makeLiteral(BooleanValue.FALSE);
            }
        }
        return this;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.targetType == ((InstanceOfExpression)other).targetType && this.targetCardinality == ((InstanceOfExpression)other).targetCardinality;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression copy() {
        return new InstanceOfExpression(this.getBaseExpression().copy(), SequenceType.makeSequenceType(this.targetType, this.targetCardinality));
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item item;
        SequenceIterator iter = this.operand.iterate(context);
        int count = 0;
        while ((item = iter.next()) != null) {
            ++count;
            if (!this.targetType.matchesItem(item, false, context.getConfiguration())) {
                return false;
            }
            if (count != 2 || Cardinality.allowsMany(this.targetCardinality)) continue;
            return false;
        }
        return count != 0 || (this.targetCardinality & 0x2000) != 0;
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("instance");
        destination.emitAttribute("of", this.targetType.toString(destination.getNamePool()));
        destination.emitAttribute("occurs", Cardinality.getOccurrenceIndicator(this.targetCardinality));
        this.operand.explain(destination);
        destination.endElement();
    }
}

