/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;

public class Error
extends SystemFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        QualifiedNameValue qname = null;
        if (this.argument.length > 0) {
            qname = (QualifiedNameValue)this.argument[0].evaluateItem(context);
        }
        if (qname == null) {
            qname = new QNameValue("err", "http://www.w3.org/2005/xqt-errors", this.argument.length == 1 ? "FOTY0004" : "FOER0000", BuiltInAtomicType.QNAME, null);
        }
        String description = this.argument.length > 1 ? this.argument[1].evaluateItem(context).getStringValue() : "Error signalled by application call on error()";
        XPathException e2 = new XPathException(description);
        e2.setErrorCode(qname.getNamespaceURI(), qname.getLocalName());
        e2.setXPathContext(context);
        e2.setLocator(this);
        if (this.argument.length > 2) {
            NodeInfo root;
            Value errorObject = ((Value)SequenceExtent.makeSequenceExtent(this.argument[2].iterate(context))).reduce();
            if (errorObject instanceof SingletonNode && (root = ((SingletonNode)errorObject).getNode()).getNodeKind() == 9) {
                XPathEvaluator xpath = new XPathEvaluator();
                XPathExpression exp = xpath.createExpression("/error/@module");
                NodeInfo moduleAtt = (NodeInfo)exp.evaluateSingle(root);
                String module = moduleAtt == null ? null : moduleAtt.getStringValue();
                exp = xpath.createExpression("/error/@line");
                NodeInfo lineAtt = (NodeInfo)exp.evaluateSingle(root);
                int line = lineAtt == null ? -1 : Integer.parseInt(lineAtt.getStringValue());
                exp = xpath.createExpression("/error/@column");
                NodeInfo columnAtt = (NodeInfo)exp.evaluateSingle(root);
                int column = columnAtt == null ? -1 : Integer.parseInt(columnAtt.getStringValue());
                ExpressionLocation locator = new ExpressionLocation();
                locator.setSystemId(module);
                locator.setLineNumber(line);
                locator.setColumnNumber(column);
                e2.setLocator(locator);
            }
            e2.setErrorObject(errorObject);
        }
        throw e2;
    }
}

