/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class Idref
extends SystemFunction {
    private KeyDefinitionSet idRefKey;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Idref f = (Idref)super.simplify(visitor);
        f.addContextDocumentArgument(1, "idref");
        return f;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextItemType);
        this.idRefKey = visitor.getExecutable().getKeyManager().getKeyDefinitionSet(StandardNames.getStructuredQName(562));
        return e2;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], false);
    }

    public int computeSpecialProperties() {
        int prop = 0xC20000;
        if (this.getNumberOfArguments() == 1 || (this.argument[1].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        PathMap.PathMapNodeSet target = this.argument[1].addToPathMap(pathMap, pathMapNodeSet);
        AxisExpression allElements = new AxisExpression(4, AnyNodeTest.getInstance());
        allElements.setContainer(this.getContainer());
        target = target.createArc(allElements);
        return target;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        NodeInfo arg2 = (NodeInfo)this.argument[1].evaluateItem(context);
        if ((arg2 = arg2.getRoot()).getNodeKind() != 9) {
            this.dynamicError("In the idref() function, the tree being searched must be one whose root is a document node", "FODC0001", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)arg2;
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            SequenceIterator keys = this.argument[0].iterate(context);
            return Idref.getIdrefMultiple(doc, keys, context);
        }
        AtomicValue keyValue = (AtomicValue)this.argument[0].evaluateItem(context);
        if (keyValue == null) {
            return EmptyIterator.getInstance();
        }
        KeyManager keyManager = controller.getKeyManager();
        return keyManager.selectByKey(this.idRefKey, doc, keyValue, context);
    }

    public static SequenceIterator getIdrefMultiple(DocumentInfo doc, SequenceIterator keys, XPathContext context) throws XPathException {
        IdrefMappingFunction map = new IdrefMappingFunction();
        map.document = doc;
        map.keyContext = context;
        map.keyManager = context.getController().getKeyManager();
        map.keySet = map.keyManager.getKeyDefinitionSet(StandardNames.getStructuredQName(562));
        MappingIterator allValues = new MappingIterator(keys, map);
        return new DocumentOrderIterator(allValues, LocalOrderComparer.getInstance());
    }

    private static class IdrefMappingFunction
    implements MappingFunction {
        public DocumentInfo document;
        public XPathContext keyContext;
        public KeyManager keyManager;
        public KeyDefinitionSet keySet;

        private IdrefMappingFunction() {
        }

        public SequenceIterator map(Item item) throws XPathException {
            KeyManager keyManager = this.keyContext.getController().getKeyManager();
            AtomicValue keyValue = item instanceof AtomicValue ? (AtomicValue)item : new StringValue(item.getStringValue());
            return keyManager.selectByKey(this.keySet, this.document, keyValue, this.keyContext);
        }
    }
}

